/* $Id: vircam_wcsutils.h,v 1.12 2008/05/06 08:40:10 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2008/05/06 08:40:10 $
 * $Revision: 1.12 $
 * $Name:  $
 */

/* Includes */

#ifndef VIRCAM_WCSUTIL_H
#define VIRCAM_WCSUTIL_H

#include <cpl.h>

/* Useful constants */

#define DEGRAD 57.2957795130823229

/* WCS utility prototypes */

extern void vircam_xytoradec(cpl_wcs *wcs, double x, double y,
			     double *ra, double *dec);
extern void vircam_radectoxy(cpl_wcs *wcs, double ra, double dec,
			     double *x, double *y);
extern void vircam_radectoxieta(cpl_wcs *wcs, double ra, double dec,
				double *xi, double *eta);
extern int vircam_coverage(cpl_propertylist *plist, int fudge, double *ra1, 
			   double *ra2, double *dec1, double *dec2, 
			   int *status);
extern int vircam_crpixshift(cpl_propertylist *p, double scalefac, 
			     double offs[]);
extern int vircam_rescalecd(cpl_propertylist *p, double scalefac);
extern int vircam_diffxywcs(cpl_wcs *wcs, cpl_wcs *wcsref, float *xoff,
			    float *yoff, int *status);
extern int vircam_removewcs(cpl_propertylist *p, int *status);
extern int vircam_tabwcs(cpl_propertylist *p, int xcol, int ycol, int *status);

#endif

/*

$Log: vircam_wcsutils.h,v $
Revision 1.12  2008/05/06 08:40:10  jim
Modified to use cpl_wcs interface

Revision 1.11  2007/05/03 11:15:33  jim
Fixed little problem with table wcs

Revision 1.10  2007/05/02 09:16:12  jim
Added vircam_tabwcs

Revision 1.9  2006/08/11 12:45:41  jim
Modified to use wcslib

Revision 1.8  2006/06/13 14:09:54  jim
Added vircam_removewcs

Revision 1.7  2006/05/24 13:36:15  jim
Added vircam_diffxywcs

Revision 1.6  2006/04/24 08:51:43  jim
Fixed bug in type for naxis1 and naxis2 elements

Revision 1.5  2006/04/20 11:30:29  jim
Added naxis1 and naxis2 to the structure

Revision 1.4  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.3  2006/01/23 10:30:32  jim
Modifications mainly to docs

Revision 1.2  2005/11/03 15:16:29  jim
Lots of changes mainly to strengthen error reporting

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/

