/* $Id: vircam_tfits.h,v 1.3 2006/05/24 13:34:36 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2006/05/24 13:34:36 $
 * $Revision: 1.3 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_TFITS_H
#define VIRCAM_TFITS_H

#include <cpl.h>

/* VIRCAM TFITS structure. Basically a subclass of cpl_table */

typedef struct {
    cpl_table        *table;
    cpl_propertylist *phu;
    cpl_propertylist *ehu;
    char             *fname;
    char             *extname;
    char             *fullname;
    int              nexten;
    int              status;
} vir_tfits;

/* VIRCAM_TFITS methods prototypes */

extern vir_tfits *vircam_tfits_load(cpl_frame *frame, int nexten);
extern vir_tfits *vircam_tfits_extract(vir_tfits *in);
extern vir_tfits **vircam_tfits_load_list(cpl_frameset *f, int exten);
extern void vircam_tfits_delete(vir_tfits *p);
extern void vircam_tfits_delete_list(vir_tfits **p, int n);
extern cpl_table *vircam_tfits_get_table(vir_tfits *p);
extern int vircam_tfits_get_nexten(vir_tfits *p);
extern char *vircam_tfits_get_filename(vir_tfits *p);
extern char *vircam_tfits_get_fullname(vir_tfits *p);
extern cpl_propertylist *vircam_tfits_get_phu(vir_tfits *p);
extern cpl_propertylist *vircam_tfits_get_ehu(vir_tfits *p);
extern int vircam_tfits_get_status(vir_tfits *p);
extern int vircam_tfits_set_error(vir_tfits *p, int status);
extern vir_tfits *vircam_tfits_wrap(cpl_table *im, vir_tfits *model,
				    cpl_propertylist *phu,
				    cpl_propertylist *ehu);

#endif

/*

$Log: vircam_tfits.h,v $
Revision 1.3  2006/05/24 13:34:36  jim
Added vircam_tfits_wrap

Revision 1.2  2006/04/20 11:21:21  jim
Added _fullname method

Revision 1.1  2006/03/15 14:35:17  jim
new file


*/
