/* $Id: vircam_pfits.h,v 1.12 2007/11/20 09:39:39 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/11/20 09:39:39 $
 * $Revision: 1.12 $
 * $Name:  $
 */

/* Includes */

#ifndef VIRCAM_PFITS_H
#define VIRCAM_PFITS_H

#include <cpl.h>

/* Function prototypes */

extern int vircam_pfits_get_crval1(const cpl_propertylist *plist, 
				   double *crval1);
extern int vircam_pfits_get_crpix1(const cpl_propertylist *plist,
				   double *crpix1);
extern int vircam_pfits_get_crval2(const cpl_propertylist *plist,
				   double *crval2);
extern int vircam_pfits_get_crpix2(const cpl_propertylist *plist, 
				   double *crpix2);
extern int vircam_pfits_get_cd11(const cpl_propertylist *plist, double *cd11);
extern int vircam_pfits_get_cd12(const cpl_propertylist *plist, double *cd12);
extern int vircam_pfits_get_cd21(const cpl_propertylist *plist, double *cd21);
extern int vircam_pfits_get_cd22(const cpl_propertylist *plist, double *cd22);
extern int vircam_pfits_get_pv21(const cpl_propertylist *plist, double *pv21);
extern int vircam_pfits_get_pv23(const cpl_propertylist *plist, double *pv23);
extern int vircam_pfits_get_exptime(const cpl_propertylist *plist, 
				    float *exptime);
extern int vircam_pfits_get_mindit(const cpl_propertylist *plist, 
				   float *mindit);
extern int vircam_pfits_get_ditdelay(const cpl_propertylist *plist, 
				     float *ditdelay);
extern int vircam_pfits_get_naxis1(const cpl_propertylist *plist, 
				   long *naxis1);
extern int vircam_pfits_get_naxis2(const cpl_propertylist *plist, 
				   long *naxis2);
extern int vircam_pfits_get_chipno(const cpl_propertylist *plist, int *chipno);
extern int vircam_pfits_get_jxoff(const cpl_propertylist *plist, float *xoff);
extern int vircam_pfits_get_jyoff(const cpl_propertylist *plist, float *yoff);
extern int vircam_pfits_get_airmass(const cpl_propertylist *plist, 
				    float *airmass);
extern int vircam_pfits_get_nusteps(const cpl_propertylist *plist, 
				    int *nusteps);
extern int vircam_pfits_get_ustepnum(const cpl_propertylist *plist, 
				     int *ustepnum);
extern int vircam_pfits_get_jitternum(const cpl_propertylist *plist, 
				      int *jitternum);
extern int vircam_pfits_get_ndit(const cpl_propertylist *plist, int *ndit);
extern int vircam_pfits_get_filter(const cpl_propertylist *plist, char *filt);
extern int vircam_pfits_get_saturation(const cpl_propertylist *plist,
				       float *saturation);
extern int vircam_pfits_get_gain(const cpl_propertylist *plist, float *gain);
extern int vircam_pfits_get_mjd(const cpl_propertylist *plist, double *mjd);
extern int vircam_pfits_get_detlive(const cpl_propertylist *plist, int *detlive);

#endif

/*

$Log: vircam_pfits.h,v $
Revision 1.12  2007/11/20 09:39:39  jim
added vircam_pfits_get_mjd

Revision 1.11  2007/11/14 10:45:23  jim
Added vircam_pfits_get_saturation

Revision 1.10  2006/07/11 14:52:14  jim
Added vircam_pfits_get_detlive

Revision 1.9  2006/06/20 19:00:07  jim
Added vircam_pfits_get_ndit

Revision 1.8  2006/06/13 14:08:13  jim
Added vircam_pfits_get_gain

Revision 1.7  2006/05/24 13:35:23  jim
Added _get_nusteps, _get_ustepnum, _get_jitternum and _get_filter

Revision 1.6  2006/05/17 12:05:48  jim
Add vircam_pfits_get_airmass

Revision 1.5  2006/05/15 13:15:11  jim
Added vircam_pfits_j[x,y]off

Revision 1.4  2006/03/01 10:59:25  jim
Added vircam_pfits_get_ditdelay

Revision 1.3  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.2  2005/11/03 13:28:50  jim
All sorts of changes to tighten up error handling

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/
