/* $Id: vircam_paf.h,v 1.5 2007/04/30 09:40:01 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/04/30 09:40:01 $
 * $Revision: 1.5 $
 * $Name:  $
 */

#ifndef VIRCAM_PAF_H
#define VIRCAM_PAF_H

/* Includes */

#include <cpl.h>

/* Size of PAF keywords and format */

#define SZKEY 21
#define KEYFMT "%-21s"


/* Exported routine */

extern int vircam_paf_print(char *ftemp, const char *paf_id, 
			    const char *paf_desc, cpl_propertylist *incl);
extern cpl_propertylist *vircam_paf_req_items(cpl_propertylist *src);
extern cpl_propertylist *vircam_paf_phu_items(cpl_propertylist *src);
extern void vircam_paf_append(cpl_propertylist *dest, cpl_propertylist *src,
			      char *prop);

#endif


/*

$Log: vircam_paf.h,v $
Revision 1.5  2007/04/30 09:40:01  jim
Added vircam_paf_append

Revision 1.4  2007/04/04 10:33:05  jim
Modified to add vircam_paf_phu_items

Revision 1.3  2007/03/01 12:42:42  jim
Modified slightly after code checking

Revision 1.2  2007/02/14 14:00:40  jim
Added vircam_paf_req_items

Revision 1.1  2007/02/14 12:53:51  jim
New entry


*/

