/* $Id: vircam_mask.h,v 1.4 2007/07/18 15:34:07 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/07/18 15:34:07 $
 * $Revision: 1.4 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_MASK_H
#define VIRCAM_MASK_H

#include <cpl.h>
#include "vircam_fits.h"

/* Definitions of mask types */

#define MASK_NONE 0
#define MASK_BPM  1
#define MASK_CPM  2

typedef struct {
    cpl_frame      *master_mask;
    vir_fits       *mask_image;
    int            masktype;
    int            nx;
    int            ny;
    unsigned char  *mdata;
} vir_mask;

/* VIRCAM_MASK method prototypes */

extern vir_mask *vircam_mask_define(cpl_frameset *framelist, int *labels,
				    int nlab);
extern int vircam_mask_load(vir_mask *m, int nexten, int nx, int ny);
extern void vircam_mask_delete(vir_mask *m);
extern void vircam_mask_clear(vir_mask *m);
extern void vircam_mask_force(vir_mask *m, int nx, int ny);
extern vir_fits *vircam_mask_get_fits(vir_mask *m);
extern const char *vircam_mask_get_filename(vir_mask *m);
extern unsigned char *vircam_mask_get_data(vir_mask *m);
extern int vircam_mask_get_size_x(vir_mask *m);
extern int vircam_mask_get_size_y(vir_mask *m);
extern int vircam_mask_get_type(vir_mask *m);

#endif

/*

$Log: vircam_mask.h,v $
Revision 1.4  2007/07/18 15:34:07  jim
Added vircam_mask_get_filename and vircam_mask_force

Revision 1.3  2006/03/22 12:13:08  jim
Fixed comments

Revision 1.2  2006/03/22 11:42:46  jim
Added mask types

Revision 1.1  2006/03/22 11:37:58  jim
new file


*/

				  
