/* $Id: vircam_jmp_utils.h,v 1.10 2007/10/19 06:55:06 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/10/19 06:55:06 $
 * $Revision: 1.10 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_JMP_UTILS_H
#define VIRCAM_JMP_UTILS_H

#include <cpl.h>

#define INITALLOC 16

extern int vircam_jmp_save_simple(cpl_frameset *framelist, 
				  cpl_parameterlist *parlist);
extern int vircam_jmp_save_super(cpl_frameset *framelist, 
				 cpl_parameterlist *parlist);
extern int vircam_jmp_save_stack(cpl_frameset *framelist, 
				 cpl_parameterlist *parlist);
extern int vircam_jmp_save_catalogue(cpl_frameset *framelist, 
				     cpl_parameterlist *parlist);
extern int vircam_jmp_save_illum(cpl_frameset *framelist, 
				 cpl_parameterlist *parlist);
extern void vircam_jmp_ustep_seq(void);
extern void vircam_jmp_interleave(void);
extern void vircam_jmp_dither_offsets(void);
extern void vircam_jmp_dither_images(void);
extern void vircam_jmp_catalogue(void);
extern void vircam_jmp_matched_stds(void);
extern void vircam_jmp_wcsfit(void);
extern void vircam_jmp_photcal(void);
extern void vircam_jmp_bpm2conf(void);
extern void vircam_jmp_skycor(void);
extern void vircam_jmp_get_readnoise_gain(int jext, float *readnoise, 
					  float *gain);
extern void vircam_jmp_illum(void);
extern void vircam_jmp_init(void);
extern void vircam_jmp_tidy(int level);


struct {

    /* Input */

    int         ipix;
    float       threshold;
    int         icrowd;
    float       rcore;
    int         nbsize;
    int         savecat;
    int         destripe;
    int         skycor;
    int         nord;
    int         extenum;

} vircam_jmp_config;

typedef struct {
    int          ustep_number;
    int          nframes;
    int          ngood;
    int          nustep;
    int          status;
    vir_fits     **f;
    vir_fits     *super;
    vir_fits     *superc;
} ustep_set;
    
struct {

    /* Level 0 stuff */

    int              *labels;
    cpl_frame        *master_dark;
    cpl_frame        *master_twilight_flat;
    cpl_frame        *master_conf;
    vir_mask         *mask;
    cpl_frame        *chantab;
    cpl_frame        *phottab;
    cpl_table        *tphottab;
    cpl_frame        *readgain_file;
    cpl_frameset     *science_frames;
    cpl_frame        *product_frame_stack;
    cpl_frame        *product_frame_stackc;
    cpl_frame        *product_frame_cat;
    cpl_frame        *product_frame_illcor;
    cpl_frame        **product_frames_simple;
    cpl_frame        **product_frames_super;
    cpl_frame        **product_frames_superc;
    cpl_propertylist *phupaf;
    float            *gaincors;
    char             *catpath;
    char             *catname;
    char             *catpath2;
    char             *catname2;

    /* Level 1 stuff */

    vir_fits         *fdark;
    vir_fits         *fflat;
    vir_fits         *fconf;
    vir_tfits        *fchantab;

    int              nscience;
    vir_fits         **sci_fits;

    int              nustep_sets;
    ustep_set        *ustep_sets;

    int              ndith;
    int              ndithc;
    vir_fits         **dith_input;
    vir_fits         **dithc_input;

    vir_fits         *stack_frame;
    vir_fits         *stackc_frame;
    vir_tfits        *outcat;

    cpl_table        *matchstds;

    vir_tfits        *illcor;

} ps;

# define VIRCAM_PATHSZ 128

int isfirst;
int interlv;
char current_cat[VIRCAM_PATHSZ];
char current_catpath[VIRCAM_PATHSZ];
char vircam_recipename[VIRCAM_PATHSZ];
char vircam_recipepaf[VIRCAM_PATHSZ];
cpl_propertylist *dummyqc = NULL;
int recflag;

/* Define the flags for which recipe these routines are servicing... */

# define RECSCI 1
# define RECSTD 2
# define RECMES 3

#endif

/*

$Log: vircam_jmp_utils.h,v $
Revision 1.10  2007/10/19 06:55:06  jim
Modifications made to use new method for directing the recipes to the
standard catalogues using the sof

Revision 1.9  2007/05/08 10:41:50  jim
Added gaincor variables

Revision 1.8  2007/04/04 16:05:59  jim
Modified to make paf information a bit more correct

Revision 1.7  2007/04/04 10:34:55  jim
Modified to use new dfs tags

Revision 1.6  2007/03/14 14:49:13  jim
Fixed problem with missing paf files in jmp recipes if detlive = F. Also
fixed problem where extra dummy products were being created

Revision 1.5  2007/03/01 12:42:42  jim
Modified slightly after code checking

Revision 1.4  2006/12/04 21:08:26  jim
Added nord to vircam_jmp_config

Revision 1.3  2006/11/29 12:28:45  jim
Modified so that the correct recipe names would appear in the headers of
data products

Revision 1.2  2006/11/28 20:55:10  jim
Added illcor to ps structure

Revision 1.1  2006/11/27 11:54:37  jim
Initial entry


*/
