/* $Id: vircam_fits.h,v 1.6 2006/10/31 10:26:51 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2006/10/31 10:26:51 $
 * $Revision: 1.6 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_FITS_H
#define VIRCAM_FITS_H

#include <cpl.h>

/* VIRCAM FITS structure. Basically a subclass of cpl_image */

typedef struct {
    cpl_image        *image;
    cpl_propertylist *phu;
    cpl_propertylist *ehu;
    char             *fname;
    char             *extname;
    char             *fullname;
    int              nexten;
    int              status;
} vir_fits;

/* VIRCAM_FITS methods prototypes */

extern vir_fits *vircam_fits_load(cpl_frame *frame, cpl_type type, int nexten);
extern vir_fits *vircam_fits_duplicate(vir_fits *in);
extern vir_fits **vircam_fits_load_list(cpl_frameset *f, cpl_type type, 
					int exten);
extern void vircam_fits_delete(vir_fits *p);
extern void vircam_fits_delete_list(vir_fits **p, int n);
extern cpl_image *vircam_fits_get_image(vir_fits *p);
extern int vircam_fits_get_nexten(vir_fits *p);
extern char *vircam_fits_get_filename(vir_fits *p);
extern cpl_propertylist *vircam_fits_get_phu(vir_fits *p);
extern cpl_propertylist *vircam_fits_get_ehu(vir_fits *p);
extern char *vircam_fits_get_extname(vir_fits *p);
extern char *vircam_fits_get_fullname(vir_fits *p);
extern int vircam_fits_get_status(vir_fits *p);
extern int vircam_fits_set_error(vir_fits *p, int status);
extern vir_fits *vircam_fits_wrap(cpl_image *im, vir_fits *model, 
				  cpl_propertylist *phu,
				  cpl_propertylist *ehu);
#endif

/*

$Log: vircam_fits.h,v $
Revision 1.6  2006/10/31 10:26:51  jim
Added vircam_fits_get_extname

Revision 1.5  2006/08/07 14:20:14  jim
Added vircam_fits_duplicate

Revision 1.4  2006/05/24 13:34:20  jim
Added vircam_fits_wrap

Revision 1.3  2006/04/20 11:21:21  jim
Added _fullname method

Revision 1.2  2006/03/03 14:29:45  jim
Modified definition of vir_fits and channel table

Revision 1.1  2006/03/01 10:31:03  jim
new files


*/
