/* $Id: vircam_dfs.h,v 1.33 2007/11/22 12:32:27 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/11/22 12:32:27 $
 * $Revision: 1.33 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_DFS_H
#define VIRCAM_DFS_H

/*********************************************************/
/*       PRO.CATG keywords for main data products        */
/*********************************************************/

/* Products from vircam_crosstalk_analyse */

/* Products from vircam_dark_combine */

#define VIRCAM_PRO_DARK                "MASTER_DARK"
#define VIRCAM_PRO_DIFFIMG_DARK        "DIFFIMG_DARK"
#define VIRCAM_PRO_DIFFIMG_DARK_STATS  "DIFFIMG_STATS_DARK"

/* Products from vircam_dark_current */

#define VIRCAM_PRO_DARKCUR             "MASTER_DARK_CURRENT"

/* Products from vircam_detector_noise */

#define VIRCAM_PRO_READGAINFILE        "MASTER_READGAIN_TABLE"

/* Products from vircam_dome_flat_combine */

#define VIRCAM_PRO_DOME_FLAT                "MASTER_DOME_FLAT"
#define VIRCAM_PRO_RATIOIMG_DOME_FLAT       "RATIOIMG_DOME_FLAT"
#define VIRCAM_PRO_RATIOIMG_DOME_FLAT_STATS "RATIOIMG_STATS_DOME_FLAT"

/* Products from vircam_jitter_microstep_process */

#define VIRCAM_PRO_SIMPLE_SCI          "SIMPLE_IMAGE_SCI"
#define VIRCAM_PRO_INTER_SCI           "INTERLEAVED_IMAGE_SCI"
#define VIRCAM_PRO_JITTERED_SCI        "JITTERED_IMAGE_SCI"
#define VIRCAM_PRO_CONF_SCI            "CONFIDENCE_MAP_SCI"
#define VIRCAM_PRO_OBJCAT_SCI          "OBJECT_CATALOGUE_SCI"

/* Products from vircam_linearity_analyse */

#define VIRCAM_PRO_BPM                 "MASTER_BPM"
#define VIRCAM_PRO_CHANTAB             "MASTER_CHANNEL_TABLE"
#define VIRCAM_PRO_LIN_DIAG1           "LINEARITY_SEQ_DIAG"
#define VIRCAM_PRO_LIN_DIAG2           "LINEARITY_CHECK_DIAG"

/* Products from vircam_mesostep_analyse */

#define VIRCAM_PRO_ILLCOR_MES          "ILLCOR_TAB_MES"

/* Products from vircam_persistence_analyse */

/* Products from vircam_reset_combine */

#define VIRCAM_PRO_RESET               "MASTER_BIAS"
#define VIRCAM_PRO_DIFFIMG_RESET       "DIFFIMG_BIAS"
#define VIRCAM_PRO_DIFFIMG_RESET_STATS "DIFFIMG_STATS_BIAS"

/* Products from vircam_standard_process */

#define VIRCAM_PRO_SIMPLE_STD          "SIMPLE_IMAGE_STD"
#define VIRCAM_PRO_INTER_STD           "INTERLEAVED_IMAGE_STD"
#define VIRCAM_PRO_JITTERED_STD        "JITTERED_IMAGE_STD"
#define VIRCAM_PRO_CONF_STD            "CONFIDENCE_MAP_STD"
#define VIRCAM_PRO_OBJCAT_STD          "OBJECT_CATALOGUE_STD"
#define VIRCAM_PRO_ILLCOR_STD          "ILLCOR_TAB_STD"

/* Products from vircam_twilight_flat_combine */

#define VIRCAM_PRO_TWILIGHT_FLAT                "MASTER_TWILIGHT_FLAT"
#define VIRCAM_PRO_CONF                         "MASTER_CONF"
#define VIRCAM_PRO_RATIOIMG_TWILIGHT_FLAT       "RATIOIMG_TWILIGHT_FLAT"
#define VIRCAM_PRO_RATIOIMG_TWILIGHT_FLAT_STATS "RATIOIMG_STATS_TWILIGHT_FLAT"

/*********************************************************/
/*    PRO.CATG keywords for intermediate products        */
/*    (Test recipes only)                                */
/*********************************************************/

#define VIRCAM_PRO_SIMPLE_TEST         "SIMPLE_IMAGE_TEST"
#define VIRCAM_PRO_STDTAB              "STANDARDS_TABLE"
#define VIRCAM_PRO_MSTDTAB             "MATCHED_STANDARDS_TABLE"
#define VIRCAM_PRO_OBJCAT_TEST         "OBJECT_CATALOGUE_TEST"
#define VIRCAM_PRO_JITTERED_TEST       "JITTERED_IMAGE_TEST"
#define VIRCAM_PRO_CONF_TEST           "CONFIDENCE_MAP_TEST"
#define VIRCAM_PRO_INTER_TEST          "INTERLEAVED_IMAGE_TEST"


/*********************************************************/
/*         DO.CATG keywords for raw data frames          */
/*********************************************************/

/* Raw input for vircam_crosstalk_analyse */

#define VIRCAM_CROSSTALK_RAW           "OBJECT_CROSSTALK"                 

/* Raw input for vircam_dark_combine */

#define VIRCAM_DARK_RAW                "DARK"

/* Raw input for vircam_dark_current */

#define VIRCAM_DARKCUR_RAW             "DARK_DARKCURRENT"

/* Raw input for vircam_detector_noise */

#define VIRCAM_NOISE_FLAT_RAW          "FLAT_LAMP_GAIN"
#define VIRCAM_NOISE_DARK_RAW          "DARK_GAIN"

/* Raw input for vircam_dome_flat_combine */

#define VIRCAM_DOME_RAW                "FLAT_LAMP"

/* Raw input for vircam_jitter_microstep_process */

#define VIRCAM_SCI_OBJECT_RAW          "OBJECT"
#define VIRCAM_SCI_OBJECT_EXT_RAW      "OBJECT_EXTENDED"

/* Raw input for vircam_linearity_analyse */

#define VIRCAM_LIN_DOME_RAW            "FLAT_LAMP_LINEARITY"
#define VIRCAM_LIN_DOME_CHECK          "FLAT_LAMP_CHECK"
#define VIRCAM_LIN_DARK_RAW            "DARK_LINEARITY"
#define VIRCAM_LIN_DARK_CHECK          "DARK_LINEARITY_CHECK"

/* Raw input for vircam_mesostep_analyse */

#define VIRCAM_ILLUM_RAW               "STD_ILLUMINATION"

/* Raw input for vircam_persistence_analyse */

#define VIRCAM_PERSIST_OBJ_RAW         "OBJECT_PERSISTENCE"
#define VIRCAM_PERSIST_DARK_RAW        "DARK_PERSISTENCE"

/* Raw input for vircam_reset_combine */

#define VIRCAM_RESET_RAW               "BIAS"

/* Raw input for vircam_standard_process */

#define VIRCAM_STD_OBJECT_RAW          "STD_FLUX"

/* Raw input for vircam_twilight_flat_combine */

#define VIRCAM_TWI_RAW                 "FLAT_TWILIGHT"

/* Raw input for test routines */

#define VIRCAM_TEST_SCIENCE_RAW        "SCIENCE_IMAGE"

/*********************************************************/
/*     DO.CATG keywords for reference data frames        */
/*     Used for comparison of new master calibrations    */
/*********************************************************/

#define VIRCAM_REF_RESET               "REFERENCE_BIAS"
#define VIRCAM_REF_DARK                "REFERENCE_DARK"
#define VIRCAM_REF_DOME_FLAT           "REFERENCE_DOME_FLAT"
#define VIRCAM_REF_TWILIGHT_FLAT       "REFERENCE_TWILIGHT_FLAT"

/*********************************************************/
/*   DO.CATG keywords for master calibration frames      */
/*********************************************************/

#define VIRCAM_CAL_RESET               "MASTER_BIAS"
#define VIRCAM_CAL_DARK                "MASTER_DARK"
#define VIRCAM_CAL_DOME_FLAT           "MASTER_DOME_FLAT"
#define VIRCAM_CAL_TWILIGHT_FLAT       "MASTER_TWILIGHT_FLAT"
#define VIRCAM_CAL_CONF                "MASTER_CONF"
#define VIRCAM_CAL_BPM                 "MASTER_BPM"
#define VIRCAM_CAL_FRINGE              "MASTER_FRINGE"
#define VIRCAM_CAL_CHANTAB             "MASTER_CHANNEL_TABLE"
#define VIRCAM_CAL_READGAINFILE        "MASTER_READGAIN_TABLE"
#define VIRCAM_CAL_2MASS               "MASTER_2MASS_CATALOGUE"
#define VIRCAM_CAL_REFCAT              "MASTER_REFERENCE_CATALOGUE"

/*********************************************************/
/*    DO.CATG keywords for static calibration            */
/*********************************************************/

#define VIRCAM_CAL_CHANTAB_INIT        "CHANNEL_TABLE_INIT"
#define VIRCAM_CAL_PHOTTAB             "PHOTCAL_TAB"

/*********************************************************/
/*    DO.CATG keywords for intermediate products         */
/*    (Test recipes only)                                */
/*********************************************************/

#define VIRCAM_CAL_STDTAB              "STANDARDS_TABLE"
#define VIRCAM_CAL_MSTDTAB             "MATCHED_STANDARDS_TABLE"
#define VIRCAM_CAL_OBJCAT              "OBJECT_CATALOGUE"

/* Function prototypes */

extern int vircam_dfs_set_groups(cpl_frameset *);
extern void vircam_dfs_set_product_primary_header(cpl_propertylist *plist,
						  cpl_frame *frame,
						  cpl_frameset *frameset,
						  cpl_parameterlist *parlist,
						  char *recipeid,
						  const char *dict);
extern void vircam_dfs_set_product_exten_header(cpl_propertylist *plist,
						cpl_frame *frame,
						cpl_frameset *frameset,
						cpl_parameterlist *parlist,
						char *recipeid,
						const char *dict);
#endif

/*

$Log: vircam_dfs.h,v $
Revision 1.33  2007/11/22 12:32:27  jim
Added LINEARITY_SEQ_DIAG and LINEARITY_CHECK_DIAG

Revision 1.32  2007/11/20 09:37:56  jim
Added VIRCAM_LIN_DOME_CHECK and VIRCAM_LIN_DARK_CHECK

Revision 1.31  2007/10/22 09:36:07  jim
Modified entries for reset type frames

Revision 1.30  2007/10/19 06:55:06  jim
Modifications made to use new method for directing the recipes to the
standard catalogues using the sof

Revision 1.29  2007/06/13 08:12:15  jim
Modified tags for DO.CATG to remove commas

Revision 1.28  2007/04/13 12:29:37  jim
Fixed typo

Revision 1.27  2007/04/04 10:34:42  jim
Complete rewrite of the dfs tags

Revision 1.26  2007/03/01 12:42:41  jim
Modified slightly after code checking

Revision 1.25  2007/02/15 11:53:45  jim
Added type CHANNEL_TABLE_INIT

Revision 1.24  2007/02/05 13:54:00  jim
Added REFERENCE tags

Revision 1.23  2006/12/06 12:58:57  jim
Added MASTER_FRINGE

Revision 1.22  2006/11/28 20:57:05  jim
Added ILLUM types

Revision 1.21  2006/07/03 09:33:18  jim
Fixed a few things to keep the compiler happy

Revision 1.20  2006/06/13 21:26:02  jim
Added VIRCAM_CALIB_READNOISE_FILE

Revision 1.19  2006/05/24 13:33:56  jim
Added VIRCAM_PHOTTAB

Revision 1.18  2006/05/15 13:15:49  jim
Added dither frame product

Revision 1.17  2006/04/27 14:22:06  jim
Fixed docs

Revision 1.16  2006/04/27 09:46:27  jim
Modified to conform to new dictionary

Revision 1.15  2006/04/26 09:39:35  jim
Fixes the pipeline id to the header

Revision 1.14  2006/04/25 13:47:59  jim
Modified calls to vircam_dfs_set_product_*_header routines

Revision 1.13  2006/04/20 11:20:17  jim
Added some more categories

Revision 1.12  2006/03/22 13:14:24  jim
Sorted data categories

Revision 1.11  2006/03/22 11:39:05  jim
added VIRCAM_CALIB_BPM

Revision 1.10  2006/03/15 10:43:41  jim
Fixed a few things

Revision 1.9  2006/03/01 10:31:28  jim
Now uses new vir_fits objects

Revision 1.8  2006/02/27 13:52:46  jim
Added some new entries

Revision 1.7  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.6  2005/11/25 09:56:14  jim
Tidied up some more documentation

Revision 1.5  2005/11/03 15:16:28  jim
Lots of changes mainly to strengthen error reporting

Revision 1.4  2005/11/03 13:28:48  jim
All sorts of changes to tighten up error handling

Revision 1.3  2005/10/14 13:16:34  jim
Added some new definitions

Revision 1.2  2005/09/20 15:07:46  jim
Fixed a few bugs and added a few things

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/
