/*

$Id: create_table_4.c,v 1.4 2007/05/03 11:15:34 jim Exp $

*/

#include <stdio.h>
#include <math.h>
#include "imcore.h"
#include "util.h"
#include "../vircam_fits.h"

extern void tabinit_4(ap_t *ap) {
    long npts,i;
    cpl_binary *opm;

    /* The output table doesn't exist */

    tab = NULL;
    npts = (ap->lsiz)*(ap->csiz);
    ap->opmask = cpl_mask_new(ap->lsiz,ap->csiz);
    opm = cpl_mask_get_data(ap->opmask);
    for (i = 0; i < npts; i++) 
	opm[i] = 0;

    /* Undefined RA and Dec columns */

    imcore_xcol = -1;
    imcore_ycol = -1;
    
}

extern int do_seeing_4(ap_t *ap) {

    /* Get out of here */

    ap->fwhm = 0.0;
    return(VIR_OK);
}
        

extern int process_results_4(ap_t *ap) {
    int i,j,np;
    long nx;
    plstruct *plarray;
    cpl_binary *opm;

    /* Loop for each object in the array */

    opm = cpl_mask_get_data(ap->opmask);
    plarray = ap->plarray;
    np = ap->npl_pix;
    nx = ap->lsiz;
    for (i = 0; i < np; i++) {
	j = nx*(plarray[i].y - 1) + plarray[i].x - 1;
	opm[j] = 1;
    }

    /* Get outta here */

    return(VIR_OK);
}

extern int tabclose_4(ap_t *ap) {

    cpl_image_reject_from_mask(ap->inframe,ap->opmask);
    cpl_mask_delete(ap->opmask);
    return(VIR_OK);
}

/*

$Log: create_table_4.c,v $
Revision 1.4  2007/05/03 11:15:34  jim
Fixed little problem with table wcs

Revision 1.3  2007/05/02 09:11:35  jim
Modified to allow for inclusion of table WCS keywords into FITS header

Revision 1.2  2006/03/01 10:31:29  jim
Now uses new vir_fits objects

Revision 1.1  2005/09/13 13:25:28  jim
Initial entry after modifications to make cpl compliant


*/
