/*

$Id: create_table_3.c,v 1.8 2007/05/03 11:15:34 jim Exp $

*/

#include <stdio.h>
#include <math.h>
#include "imcore.h"
#include "util.h"
#include "floatmath.h"

/* Column numbers for each item to be stored */

#define COL_NUMBER      1
#define COL_X           2
#define COL_Y           3
#define COL_FLUXISO     4
#define COL_PEAKHEIGHT  5
#define COL_ELLIPT      6
#define COL_SIGMA       7
#define COL_PA          8
#define COL_AREAL1      9
#define COL_AREAL2     10
#define COL_AREAL3     11
#define COL_AREAL4     12
#define COL_AREAL5     13
#define COL_AREAL6     14
#define COL_AREAL7     15
#define COL_AREAL8     16

/* Number of columns in the table */

#define NCOLS 32

/* Column definitions */

static const char *ttype[NCOLS]={"No.","X_coordinate","Y_coordinate",
				 "Isophotal_flux","Peak_height","Ellipticity",
				 "Gaussian_sigma","Position_angle",
				 "Areal_1_profile","Areal_2_profile","Areal_3_profile",
				 "Areal_4_profile","Areal_5_profile","Areal_6_profile",
				 "Areal_7_profile","Areal_8_profile",
				 "Blank","Blank","Blank","Blank","Blank","Blank",
				 "Blank","Blank","Blank","Blank","Blank","Blank",
				 "Blank","Blank","Blank","Blank"};
static const char *tunit[NCOLS]={" ","Pixels","Pixels","Counts","Counts"," ",
				 "Pixels","Degrees","Pixels","Pixels","Pixels",
				 "Pixels","Pixels","Pixels","Pixels","Pixels",
				 "Blank","Blank","Blank","Blank","Blank","Blank",
				 "Blank","Blank","Blank","Blank","Blank","Blank",
				 "Blank","Blank","Blank","Blank"};

static cpl_type tform[NCOLS]={CPL_TYPE_INT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,CPL_TYPE_FLOAT,
			      CPL_TYPE_FLOAT,CPL_TYPE_FLOAT};

static int areal_cols[NAREAL] = {COL_AREAL1,COL_AREAL2,COL_AREAL3,COL_AREAL4,
				 COL_AREAL5,COL_AREAL6,COL_AREAL7,COL_AREAL8};

extern void tabinit_3(void) {

    /* Call the generic routine to open a new output table */

    tabinit_gen(NCOLS,ttype,tunit,tform);

    /* RA and DEC columns are undefined */

    imcore_xcol = COL_X;
    imcore_ycol = COL_Y;
}

extern int do_seeing_3(ap_t *ap) {
    int retval,i;
    char *areal_colnames[NAREAL];

    /* Sort out the areal profile column names */

    for (i = 0; i < NAREAL; i++) 
	areal_colnames[i] = (char *)ttype[areal_cols[i]-1];
 
    /* Just call the generic seeing routine */
 
    retval = do_seeing_gen(ap,ttype[COL_ELLIPT-1],ttype[COL_PEAKHEIGHT-1],
			   areal_colnames);

    /* Get out of here */
 
    return(retval);
}
        

extern int process_results_3(ap_t *ap) {
    float momresults[8],parmall[NPAR];
    float sxx,syy,srr,sxy,ecc,temp,xx,theta,radeg,ell;
    float yy,sigma,peak,areal1,iso_flux;
    float areal2,areal3,areal4,areal5,areal6,areal7,areal8,aa,bb;
    int iareal[NAREAL],i,k,nn,nr;
    long nrows;
    plstruct *pl;
    unsigned char *mflag;

    /* Do a basic moments analysis and work out the areal profiles*/

    moments(ap,momresults);
    if (momresults[0] < 0)
	return(VIR_FATAL);
    areals(ap,iareal);

    /* See if this object makes the cut in terms of its size.  If not, then
       just return with good status */

    if (iareal[0] < ap->ipnop || momresults[3] < ap->xintmin)
	return(VIR_OK);

    /* Try and deblend the images if it is requested and justified */

    parmall[0] = momresults[3];
    parmall[1] = momresults[1];
    parmall[2] = momresults[2];
    parmall[3] = ap->thresh;
    for (i = 4; i < 8; i++) 
        parmall[i] = momresults[i];
    for (i = 0; i < NAREAL; i++)
        parmall[i+8] = (float)iareal[i];

    /* Massage the results and write them to the fits table */

    radeg = 180.0/M_PI;
    sxx = parmall[4];
    sxy = parmall[5];
    syy = parmall[6];    
    if(sxy > 0.0)
      sxy = MAX(1.0e-4,MIN(sxy,sqrtf(sxx*syy)));
    else
      sxy = MIN(-1.0e-4,MAX(sxy,-sqrtf(sxx*syy)));

    srr = MAX(0.5,sxx+syy);
    ecc = sqrtf((syy-sxx)*(syy-sxx)+4.0*sxy*sxy)/srr;
    temp = MAX((1.0-ecc)/(1.0+ecc),0.0);
    ell = 1.0 - sqrtf(temp);
    ell = MIN(0.99,MAX(0.0,ell));
    xx = 0.5*(1.0+ecc)*srr-sxx;
    if(xx == 0.0)
	theta = 0.0;
    else
	theta = 90.0-radeg*atanf(sxy/xx);

    /* Create a list of values */

    nrows = cpl_table_get_nrow(tab);
    nobjects++;
    if (nobjects > nrows) 
	(void)cpl_table_set_size(tab,nrows+INITROWS);
    nr = nobjects - 1;
    iso_flux = parmall[0];
    xx = parmall[1];
    yy = parmall[2];
    sigma = sqrt(srr);
    peak = parmall[7];
    areal1 = parmall[8];
    areal2 = parmall[9];
    areal3 = parmall[10];
    areal4 = parmall[11];
    areal5 = parmall[12];
    areal6 = parmall[13];
    areal7 = parmall[14];
    areal8 = parmall[15];

    /* Store away the results for this object */

    cpl_table_set_int(tab,ttype[COL_NUMBER-1],nr,nr);
    cpl_table_set_float(tab,ttype[COL_X-1],nr,xx);
    cpl_table_set_float(tab,ttype[COL_Y-1],nr,yy);
    cpl_table_set_float(tab,ttype[COL_FLUXISO-1],nr,iso_flux);
    cpl_table_set_float(tab,ttype[COL_PEAKHEIGHT-1],nr,peak);
    cpl_table_set_float(tab,ttype[COL_ELLIPT-1],nr,ell);
    cpl_table_set_float(tab,ttype[COL_SIGMA-1],nr,sigma);
    cpl_table_set_float(tab,ttype[COL_PA-1],nr,theta);
    cpl_table_set_float(tab,ttype[COL_AREAL1-1],nr,areal1);
    cpl_table_set_float(tab,ttype[COL_AREAL2-1],nr,areal2);
    cpl_table_set_float(tab,ttype[COL_AREAL3-1],nr,areal3);
    cpl_table_set_float(tab,ttype[COL_AREAL4-1],nr,areal4);
    cpl_table_set_float(tab,ttype[COL_AREAL5-1],nr,areal5);
    cpl_table_set_float(tab,ttype[COL_AREAL6-1],nr,areal6);
    cpl_table_set_float(tab,ttype[COL_AREAL7-1],nr,areal7);
    cpl_table_set_float(tab,ttype[COL_AREAL8-1],nr,areal8);

    /* Write out the .ell file info... */

    if (ellfp != NULL) {
	aa = sqrtf(areal1/(M_PI*(1.0 - ell)));
	bb = aa*(1.0 - ell);
	fprintf(ellfp,"image; ellipse %9.3f %9.3f %7.2f %7.2f %6.1f\n",
		xx,yy,aa,bb,theta);
    }

    /* Flag all pixels as object pixels */

    pl = ap->plarray;
    mflag = ap->mflag;
    for (k = 0; k < ap->npl_pix; k++) {
        nn = ap->lsiz*(pl[k].y - 1) + pl[k].x - 1;
	mflag[nn] = MF_POBJPIX;
    }

    /* Get outta here */

    return(VIR_OK);
}


/*

$Log: create_table_3.c,v $
Revision 1.8  2007/05/03 11:15:34  jim
Fixed little problem with table wcs

Revision 1.7  2007/05/02 09:11:35  jim
Modified to allow for inclusion of table WCS keywords into FITS header

Revision 1.6  2007/03/01 12:38:26  jim
Small modifications after a bit of code checking

Revision 1.5  2006/05/30 12:14:08  jim
Fixed indexing bug in table that was causing a memory overwrite

Revision 1.4  2005/11/25 09:56:15  jim
Tidied up some more documentation

Revision 1.3  2005/09/22 08:40:42  jim
Fixed some bugs in imcore and added classification Removed some unnecessary
files

Revision 1.2  2005/09/20 15:07:47  jim
Fixed a few bugs and added a few things

Revision 1.1  2005/09/13 13:25:28  jim
Initial entry after modifications to make cpl compliant


*/
