/* 

$Id: create_table.c,v 1.3 2007/03/01 12:38:26 jim Exp $

*/

#include <stdio.h>
#include <string.h>
#include "imcore.h"

static float *work = NULL;

static void tidy(void);

extern void tabinit(ap_t *ap) {

    switch (cattype) {
    case CAT_INTWFC:
	tabinit_1();
	break;
    case CAT_WFCAM:
	tabinit_2();
	break;
    case CAT_BASIC:
	tabinit_3();
	break;
    case CAT_OBJMASK:
	tabinit_4(ap);
	break;
    default:
	cpl_msg_error("tabinit","Option %d does not exist",cattype);
	tab = NULL;
	break;
    }
}

extern int do_seeing(ap_t *ap) {
    int status;

    switch (cattype) {
    case CAT_INTWFC:
	status = do_seeing_1(ap);
	break;
    case CAT_WFCAM:
	status = do_seeing_2(ap);
	break;
    case CAT_BASIC:
	status = do_seeing_3(ap);
	break;
    case CAT_OBJMASK:
	status = do_seeing_4(ap);
	break;
    default:
	status = VIR_FATAL;
	cpl_msg_error("do_seeing","Option %d does not exist",cattype);
	break;
    }
    return(status);
}

extern int process_results(ap_t *ap) {
    int status;
    
    switch (cattype) {
    case CAT_INTWFC:
	status = process_results_1(ap);
	break;
    case CAT_WFCAM:
	status = process_results_2(ap);
	break;
    case CAT_BASIC:
	status = process_results_3(ap);
	break;
    case CAT_OBJMASK:
	status = process_results_4(ap);
	break;
    default:
	status = VIR_FATAL;
	cpl_msg_error("process_result","Option %d does not exist",cattype);
	break;
    }
    return(status);
}

extern int tabclose(ap_t *ap) {
    int status;

    switch (cattype) {
    case CAT_OBJMASK:
	status = tabclose_4(ap);
        break;
    default:
	status = VIR_OK;
	break;
    }
    return(status);
}

extern void tabinit_gen(int ncols, const char *ttype[], const char *tunit[], 
			cpl_type tform[]) {
    int i;
    const char *fctid = "tabinit_gen";
    
    /* First, create the table with a default number of rows. */

    if ((tab = cpl_table_new(0)) == NULL) {
        cpl_msg_error(fctid,"Unable to open cpl table!");
	return;
    }

    /* Now define all of the columns */

    for (i = 0; i < ncols; i++) {
	cpl_table_new_column(tab,ttype[i],tform[i]);
	cpl_table_set_column_unit(tab,ttype[i],tunit[i]);
    }

}

extern int do_seeing_gen(ap_t *ap, const char *col_ellipt, 
			 const char *col_pkht, char *col_areals[NAREAL]) {
    int i;
    float fwhm,*areal[NAREAL],*ellipt,*pkht;

    /* Get some space and read the relevant columns */

    if (nobjects >= 3) {
	ellipt = cpl_table_get_data_float(tab,col_ellipt);
	pkht = cpl_table_get_data_float(tab,col_pkht);
	work = cpl_malloc(nobjects*sizeof(*work));
	for (i = 0; i < NAREAL; i++)
	    areal[i] = cpl_table_get_data_float(tab,col_areals[i]);

	/* Do the seeing calculation */

	seeing(ap,nobjects,ellipt,pkht,areal,work,&fwhm);
    } else 
	fwhm = 0.0;
    ap->fwhm = fwhm;

    /* Get out of here */

    tidy();
    return(VIR_OK);
}

static void tidy (void) {

    /* Free up workspace */

    freespace(work);
}

/*

$Log: create_table.c,v $
Revision 1.3  2007/03/01 12:38:26  jim
Small modifications after a bit of code checking

Revision 1.2  2006/11/10 09:25:39  jim
Modifed tabinit to only start with a single row

Revision 1.1  2005/09/13 13:25:27  jim
Initial entry after modifications to make cpl compliant


*/
