/*

$Id: apinit.c,v 1.3 2007/03/01 12:38:26 jim Exp $

*/

#include <stdlib.h>
#include <cpl.h>
#include "imcore.h"

#define freespace(_p) if (_p != NULL) {cpl_free(_p); _p = NULL;}

void apinit(ap_t *ap) {
    int maxpa;

    int i;

    maxpa = ap->lsiz / 2;		/* max possible parents */
    ap->lastline = cpl_calloc(ap->lsiz + 1, sizeof(short int));
    ap->maxip = 0;
    ap->maxpa = maxpa;
    ap->pstack = cpl_malloc(maxpa*sizeof(*ap->pstack));
    ap->parent = cpl_malloc(maxpa*sizeof(*(ap->parent)));
    for(i = 0; i < maxpa; i++) {
	ap->pstack[i] = i;
	ap->parent[i].pnop = -1;	/* mark all parents inactive */
	ap->parent[i].pnbp = -1;	/* mark all parents inactive */
    }
    ap->ipstack = 1;
    ap->maxbl = MAXBL;
    ap->bstack = cpl_malloc(ap->maxbl*sizeof(*ap->bstack));
    ap->blink = cpl_malloc(ap->maxbl*sizeof(*ap->blink));
    ap->plessey = cpl_malloc(ap->maxbl*sizeof(*ap->plessey));
    for (i = 0; i < MAXBL; i++)
        ap->bstack[i] = i;
    ap->ibstack = 2;	/* block 1 will get overwritten; don't use it */
    ap->nimages = 0;

    /* set up exponential areal-profile levels: */

    ap->areal[0] = 1;
    for (i = 1; i < 8; i++)
        ap->areal[i] = ap->areal[i-1]*2;

    /* allocate some space for a processing array */

    ap->npl = ap->lsiz;
    ap->npl_pix = 0;
    ap->plarray = cpl_malloc(ap->npl*sizeof(plstruct));

    /* set these to null values as you may not need the background structure */

    ap->backmap.nby = -1;
    ap->backmap.bvals = NULL;

    /* Initialise some info about the input images */

    ap->indata = NULL;
    ap->confdata = NULL;
}

void apreinit(ap_t *ap) {
    int i;

    for (i = 0; i < ap->lsiz+1; i++)
	ap->lastline[i] = 0;
    ap->maxip = 0;
    for(i = 0; i < ap->maxpa; i++) {
	ap->pstack[i] = i;
	ap->parent[i].pnop = -1;	/* mark all parents inactive */
	ap->parent[i].pnbp = -1;	/* mark all parents inactive */
    }
    ap->ipstack = 1;
    ap->ibstack = 2;	/* block 1 will get overwritten; don't use it */
    ap->nimages = 0;
    ap->npl_pix = 0;

}

void apclose(ap_t *ap) {
    int i;
    freespace(ap->lastline);
    freespace(ap->pstack);
    freespace(ap->parent);
    freespace(ap->bstack);
    freespace(ap->blink);
    freespace(ap->plessey);
    freespace(ap->plarray);
    for (i = 0; i < ap->backmap.nby; i++)
	freespace(ap->backmap.bvals[i]);
    freespace(ap->backmap.bvals);
}

/*

$Log: apinit.c,v $
Revision 1.3  2007/03/01 12:38:26  jim
Small modifications after a bit of code checking

Revision 1.2  2005/09/20 15:07:46  jim
Fixed a few bugs and added a few things

Revision 1.1  2005/09/13 13:25:27  jim
Initial entry after modifications to make cpl compliant


*/
