/* $Id: vircam_stats.h,v 1.5 2007/02/06 11:59:17 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/02/06 11:59:17 $
 * $Revision: 1.5 $
 * $Name:  $
 */

/* Includes */

#ifndef VIRCAM_STATS_H
#define VIRCAM_STATS_H

#include <cpl.h>

/* Stat utility prototypes */

extern float vircam_med(float *data, unsigned char *bpm, long npts);
extern double vircam_dmed(double *data, unsigned char *bpm, long npts);
extern float vircam_mean(float *data, unsigned char *bpm, long npts);
extern double vircam_dmean(double *data, unsigned char *bpm, long npts);
extern int vircam_meansig(float *data, unsigned char *bpm, long npts, 
			  float *mean, float *sig);
extern int vircam_meansigcut(float *data, unsigned char *bpm, long npts,
			     float lcut, float hcut, float *mean, float *sig);
extern void vircam_qmedsig(float *data, unsigned char *bpm, long npts,
			   float thresh, int niter, float lowv, float highv,
			   float *median, float *sigma);
extern void vircam_medmad(float *data, unsigned char *bpm, long np, float *med,
			  float *mad);
extern void vircam_medmadcut(float *data, unsigned char *bpm, long np, 
			     float lcut, float hcut, float *med, float *mad);
extern void vircam_medsig(float *data, unsigned char *bpm, long np, float *med,
			  float *sig);
extern int vircam_sumbpm(unsigned char *bpm, int npts, int *sumb);

#endif

/*

$Log: vircam_stats.h,v $
Revision 1.5  2007/02/06 11:59:17  jim
Added vircam_medmadcut

Revision 1.4  2006/06/06 13:06:48  jim
Added vircam_medsig

Revision 1.3  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.2  2005/10/14 13:19:13  jim
Added vircam_medmad

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/
