/* $Id: vircam_utils.h,v 1.35 2008/05/06 12:15:02 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2008/05/06 12:15:02 $
 * $Revision: 1.35 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_UTILS_H
#define VIRCAM_UTILS_H

#include <stdio.h>
#include <cpl.h>
#include "vircam_fits.h"
#include "vircam_tfits.h"
#include "vircam_mask.h"

/* Useful Macros */

#define vircam_nint(_x) ((int)(_x + ((_x) < 0.0 ? -0.5 : 0.5)))
#define min(_x,_y) (_x < _y ? _x : _y)
#define max(_x,_y) (_x > _y ? _x : _y)

/* Macros for freeing up space */

#define freespace(_p) if (_p != NULL) {cpl_free(_p); _p = NULL;}
#define freespace2(_p,_n) if (_p != NULL) {int _nfs2; for (_nfs2 = 0; _nfs2 < _n; _nfs2++) {freespace(_p[_nfs2])}}; freespace(_p);
#define freeframe(_p) if (_p != NULL) {cpl_frame_delete(_p); _p = NULL;}
#define freeimage(_p) if (_p != NULL) {cpl_image_delete(_p); _p = NULL;}
#define freeframeset(_p) if (_p != NULL) {cpl_frameset_delete(_p); _p = NULL;}
#define freeplist(_p) if (_p != NULL) {cpl_propertylist_delete(_p); _p = NULL;}
#define freetable(_p) if (_p != NULL) {cpl_table_delete(_p); _p = NULL;}
#define freepropertylist(_p) if (_p != NULL) {cpl_propertylist_delete(_p); _p = NULL;}
#define freeimagelist(_p) if (_p != NULL) {cpl_imagelist_delete(_p); _p = NULL;}
#define freefitslist(_p,_n) if (_p != NULL) {vircam_fits_delete_list(_p,_n); _p = NULL;}
#define freearray(_p) if (_p != NULL) {cpl_array_delete(_p); _p = NULL;}
#define freefits(_p) if (_p != NULL) {vircam_fits_delete(_p); _p = NULL;}
#define freetfits(_p) if (_p != NULL) {vircam_tfits_delete(_p); _p = NULL;}
#define freemask(_p) if (_p != NULL) {vircam_mask_delete(_p); _p = NULL;}
#define closefile(_p) if (_p != NULL) {fclose(_p); _p = NULL;}

/* Function prototypes */

extern const char *vircam_get_license(void);
extern int vircam_compare_tags(const cpl_frame *frame1, const cpl_frame *frame2);
extern cpl_frameset *vircam_frameset_subgroup(cpl_frameset *frameset, 
					      int *labels, int nlab, 
					      const char *tag);
extern cpl_frame *vircam_frameset_subgroup_1(cpl_frameset *frameset, 
					     int *labels, int nlab, 
					     const char *tag);
extern void vircam_exten_range(int inexten, const cpl_frame *fr, int *out1, 
			       int *out2);
extern void vircam_madfit(int npts, float *xdata, float *ydata, 
			  float *intercept, float *slope);
extern void vircam_linfit(int npts, double *xdata, double *ydata, 
			  double *intercept, double *slope, double *sig);
extern int vircam_solve_gauss(double **a, double *b, int);
extern int vircam_polyfit(const cpl_array *xarray, const cpl_array *yarray, 
			  int ncoefs, int ilim, int niter, float lclip, 
			  float hclip, cpl_array **polycf, double *sigfit);
extern void vircam_difference_image(cpl_image *master, cpl_image *prog, 
				    unsigned char *bpm, cpl_table *chantab, 
				    int ncells, int oper, float *global_diff, 
				    float *global_rms, cpl_image **diffim,
				    cpl_table **diffimstats);
extern cpl_table *vircam_create_diffimg_stats(int nrows);
extern void vircam_sort(float **a, int n, int m);
extern long vircam_getnpts(cpl_image *in);
extern int vircam_fndmatch(float x, float y, float *xlist, float *ylist, 
			   int nlist, float err);
extern int *vircam_dummy_confidence(long n);
extern int vircam_compare_dims(cpl_image *im1, cpl_image *im2);
extern void vircam_prov(cpl_propertylist *p, vir_fits **inlist, int n);
extern void vircam_merge_propertylists(cpl_propertylist *p1, 
				       cpl_propertylist *p2);
extern void vircam_dummy_property(cpl_propertylist *p);
extern int vircam_is_dummy(cpl_propertylist *p);
extern void vircam_overexp(vir_fits **fitslist, int *n, float lthr, 
			   float hthr, int ditch);
extern cpl_image *vircam_dummy_image(vir_fits *model);
extern cpl_table *vircam_dummy_catalogue(int type);
extern cpl_table *vircam_illcor_newtab(int nrows);
extern void vircam_timestamp(char *out, int n);
extern void vircam_backmap(vir_fits *in, vir_mask *mask, int nbsize, 
			   cpl_image **out, float *med);
extern int vircam_findcol(cpl_propertylist *p, char *col);
extern void vircam_rename_property(cpl_propertylist *p, char *oldname,
				   char *newname);
extern int vircam_catpars(cpl_frame *index, char **catpath, char **catname);
extern int vircam_gaincor_calc(cpl_frame *frame, int *n, float **cors,
			       int *status);

/* Define error return values */

#define VIR_OK 0
#define VIR_WARN 1
#define VIR_FATAL 2

/* Useful error handling macros for routines with inherited status */

#define FATAL_ERROR {*status = VIR_FATAL; return(*status);}
#define WARN_RETURN {*status = VIR_WARN; return(*status);}
#define WARN_CONTINUE {*status = VIR_WARN;}
#define GOOD_STATUS {*status = VIR_OK; return(*status);}

/* Define size for recipe description character variables */

#define SZ_ALLDESC 4096

/* A few useful constants */

#define M_PI               3.14159265358979323846  /* pi */
#define M_TWOPI            6.28218530717958647692 
#define M_SQRT2            1.41421356237309504880  /* sqrt(2) */

#endif

/*

$Log: vircam_utils.h,v $
Revision 1.35  2008/05/06 12:15:02  jim
Changed vircam_catpars to check that we can read the index file and to send
out error messages if there are problems

Revision 1.34  2007/11/14 14:47:53  jim
vircam_linfit now works only with doubles

Revision 1.33  2007/10/25 17:33:32  jim
Modified to add vircam_polyfit and to remove lint warnings

Revision 1.32  2007/10/19 06:55:07  jim
Modifications made to use new method for directing the recipes to the
standard catalogues using the sof

Revision 1.31  2007/10/15 12:50:28  jim
Modified for compatibility with cpl_4.0

Revision 1.30  2007/07/09 13:21:06  jim
Changed argument list to vircam_exten_range to include a cpl_frame

Revision 1.29  2007/05/08 10:41:01  jim
Added vircam_gaincor_calc

Revision 1.28  2007/05/02 09:14:48  jim
Added vircam_findcol and vircam_rename_property

Revision 1.27  2007/02/14 12:53:34  jim
Removed vircam_paf_print_header

Revision 1.26  2007/02/07 10:12:15  jim
Removed vircam_ndit_correct as it is now no longer necessary

Revision 1.25  2006/12/01 14:08:33  jim
added vircam_backmap

Revision 1.24  2006/11/28 20:52:17  jim
Added vircam_illcor_newtab

Revision 1.23  2006/08/27 20:28:15  jim
added vircam_is_dummy

Revision 1.22  2006/08/21 09:09:29  jim
Added routines vircam_create_diffimg_stats and vircam_dummy_property

Revision 1.21  2006/06/09 22:24:47  jim
Added vircam_ndit_correct

Revision 1.20  2006/05/30 13:31:48  jim
Added vircam_timestamp

Revision 1.19  2006/05/24 13:35:49  jim
Added vircam_dummy_image and vircam_dummy_catalogue

Revision 1.18  2006/04/26 09:39:35  jim
Fixes the pipeline id to the header

Revision 1.17  2006/04/20 11:29:41  jim
Added vircam_overexp

Revision 1.16  2006/03/22 11:42:32  jim
Moved some routines into vircam_mask

Revision 1.15  2006/03/15 10:43:42  jim
Fixed a few things

Revision 1.14  2006/03/08 14:32:22  jim
Lots of little modifications

Revision 1.13  2006/03/03 14:29:46  jim
Modified definition of vir_fits and channel table

Revision 1.12  2006/03/01 10:31:29  jim
Now uses new vir_fits objects

Revision 1.11  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.10  2006/01/23 10:30:31  jim
Modifications mainly to docs

Revision 1.9  2005/12/02 10:45:54  jim
Added SZ_ALLDESC definition

Revision 1.8  2005/12/01 16:26:03  jim
Added vircam_dummy_confidence

Revision 1.7  2005/11/25 09:36:43  jim
Added vircam_linfit

Revision 1.6  2005/11/23 13:45:33  jim
Added freepropertylist macro

Revision 1.5  2005/11/07 13:15:16  jim
Fixed lots of bugs and added some error checking

Revision 1.4  2005/11/03 15:16:29  jim
Lots of changes mainly to strengthen error reporting

Revision 1.3  2005/11/03 13:28:51  jim
All sorts of changes to tighten up error handling

Revision 1.2  2005/10/14 13:21:04  jim
Added some new routines

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/
