# VIRCAM_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([VIRCAM_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


# VIRCAM_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([VIRCAM_SET_VERSION_INFO],
[
    vircam_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    vircam_major_version=`echo "$vircam_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    vircam_minor_version=`echo "$vircam_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    vircam_micro_version=`echo "$vircam_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$vircam_major_version"; then vircam_major_version=0
    fi

    if test -z "$vircam_minor_version"; then vircam_minor_version=0
    fi

    if test -z "$vircam_micro_version"; then vircam_micro_version=0
    fi

    VIRCAM_VERSION="$vircam_version"
    VIRCAM_MAJOR_VERSION=$vircam_major_version
    VIRCAM_MINOR_VERSION=$vircam_minor_version
    VIRCAM_MICRO_VERSION=$vircam_micro_version

    if test -z "$4"; then VIRCAM_INTERFACE_AGE=0
    else VIRCAM_INTERFACE_AGE="$4"
    fi

    VIRCAM_BINARY_AGE=`expr 100 '*' $VIRCAM_MINOR_VERSION + $VIRCAM_MICRO_VERSION`
    VIRCAM_BINARY_VERSION=`expr 10000 '*' $VIRCAM_MAJOR_VERSION + \
                          $VIRCAM_BINARY_AGE`

    AC_SUBST(VIRCAM_VERSION)
    AC_SUBST(VIRCAM_MAJOR_VERSION)
    AC_SUBST(VIRCAM_MINOR_VERSION)
    AC_SUBST(VIRCAM_MICRO_VERSION)
    AC_SUBST(VIRCAM_INTERFACE_AGE)
    AC_SUBST(VIRCAM_BINARY_VERSION)
    AC_SUBST(VIRCAM_BINARY_AGE)

    AC_DEFINE_UNQUOTED(VIRCAM_MAJOR_VERSION, $VIRCAM_MAJOR_VERSION,
                       [VIRCAM major version number])
    AC_DEFINE_UNQUOTED(VIRCAM_MINOR_VERSION, $VIRCAM_MINOR_VERSION,
                       [VIRCAM minor version number])
    AC_DEFINE_UNQUOTED(VIRCAM_MICRO_VERSION, $VIRCAM_MICRO_VERSION,
                       [VIRCAM micro version number])
    AC_DEFINE_UNQUOTED(VIRCAM_INTERFACE_AGE, $VIRCAM_INTERFACE_AGE,
                       [VIRCAM interface age])
    AC_DEFINE_UNQUOTED(VIRCAM_BINARY_VERSION, $VIRCAM_BINARY_VERSION,
                       [VIRCAM binary version number])
    AC_DEFINE_UNQUOTED(VIRCAM_BINARY_AGE, $VIRCAM_BINARY_AGE,
                       [VIRCAM binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# VIRCAM_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([VIRCAM_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/${PACKAGE}/plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$htmldir"; then
        htmldir='${datadir}/doc/${PACKAGE}/html'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(htmldir)
    AC_SUBST(configdir)


    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(VIRCAM_PLUGIN_DIR, "${PACKAGE}/plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(VIRCAM_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

])


# VIRCAM_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([VIRCAM_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    VIRCAM_INCLUDES=' -I$(top_srcdir)/vircam/catalogue -I$(top_srcdir)/vircam'
    VIRCAM_LDFLAGS='-L$(top_srcdir)/vircam -L$(top_srcdir)/vircam/catalogue'

    all_includes='$(VIRCAM_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(VIRCAM_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    # Library aliases

    LIBVIRCAM='$(top_srcdir)/vircam/libvircam.la'
    LIBVIRCAM_CAT='$(top_srcdir)/vircam/catalogue/libvircam_catalogue.la'

    # Substitute the defined symbols

    AC_SUBST(VIRCAM_INCLUDES)
    AC_SUBST(VIRCAM_LDFLAGS)

    AC_SUBST(LIBVIRCAM)
    AC_SUBST(LIBVIRCAM_CAT)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(VIRCAM_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(VIRCAM_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
