/*

$Id: imcore.h,v 1.10 2007/05/03 11:15:34 jim Exp $

*/

/* Required information */

#include <cpl.h>
#include "ap.h"
#include "classify.h"
#include "../vircam_utils.h"
#include "../vircam_fits.h"

/* imcore specific macros */

#define MINHISTVAL -1000 /* Minimum value to histog9ram for background stats */
#define MAXHISTVAL 65535 /* Maximum value to histogram for background stats */
#define MAXHIST (MAXHISTVAL-MINHISTVAL+1) /* maximum size of histogram array */
#define HIST_ELEM(a, i) ((a)[(i) - MINHISTVAL]);

/* Catalogue generation parameters */

#define MINSATURATE 20000 /* Minimum background saturation level */
#define IMNUM 200         /* Maximum number of images to be deblended */
#define NPAR 16           /* Number of parameters in a basic results array */
#define NAREAL 8          /* Number of areal profiles */
#define IDBLIM 10000      /* Maximum number of pixels to use in deblending */
#define INITROWS 2048     /* Allocation size for rows in the output table */

#define STUPID_VALUE -1000 /* Minimum value of a pixel */

/* MFLAG values used for tracking the quality of individual pixels */

#define MF_CLEANPIX     0
#define MF_OBJPIX       1
#define MF_SATURATED    2
#define MF_ZEROCONF     3
#define MF_UNSATPIX     4
#define MF_POBJPIX      5
#define MF_STUPID_VALUE 6

/* Flags for types of catalogues to be created */

#define CAT_INTWFC      1   /* Original 32 column catalogue used for INT WFC */
#define CAT_WFCAM       2   /* Catalogue proposed for WFCAM */
#define CAT_BASIC       3   /* Very basic with positions, moments and areals */
#define CAT_OBJMASK     4   /* No table, just an object mask */

/* Useful constants */

#define M_PI            3.14159265358979323846  /* pi */
#define M_SQRT2         1.41421356237309504880  /* sqrt(2) */
#define M_LN2           0.69314718055994530942  /* log_e 2 */

/* Tidy-up macros */

#define freespace(_p) if (_p != NULL) {cpl_free(_p); _p = NULL;}
#define closefile(_p) if (_p != NULL) {fclose(_p); _p = NULL;}

/* External Function Prototypes. First, main processing routines */

extern int imcore_conf(vir_fits *infile, vir_fits *conf, int ipix,
                       float threshold, int icrowd, float rcore, int nbsize,
                       int cattyp, float filtfwhm, vir_tfits **outcat);
extern int imcore_background(ap_t *ap, int nbsize, float nullval);
extern int imcore_backstats(ap_t *ap, float nullval, int satonly, 
			    float *skymed, float *skysig, float *sat);
extern void imcore_backest(ap_t *ap, float x, float y, float *skylev, 
			   float *skyrms);
extern void imcore_medsig(int *hist, int nh, int ist, int itarg, float *med, 
			  float *sig);
extern int extend(ap_t *, float, float, float, float, float, 
		  float, float, float, float *);
extern void overlp(ap_t *ap, float [IMNUM][NPAR], int *, float, float, float,
		   int, float);
extern void phopt(ap_t *, float [IMNUM][NPAR], int, int, float [], 
		  float [], float [], int);
extern void seeing(ap_t *, int, float *, float *, float **, float *, float *);

/* Filter routines */

extern void bfilt(float **, int, int);
extern void filt1d(float [], int, int);
extern void padext(float [], int);
extern void hanning(float [], int);
extern void median(float[], int, int);
extern void polynm(float [], float [], int, float [], int, int);
extern void solve (double a[25][25], double b[25], int m);

/* Routines that generate the catalogues */

extern void tabinit(ap_t *);
extern int tabclose(ap_t *);
extern int do_seeing(ap_t *);
extern int process_results(ap_t *);
extern void tabinit_1(void);
extern int do_seeing_1(ap_t *);
extern int process_results_1(ap_t *);
extern void tabinit_2(void);
extern int do_seeing_2(ap_t *);
extern int process_results_2(ap_t *);
extern void tabinit_3(void);
extern int do_seeing_3(ap_t *);
extern int process_results_3(ap_t *);
extern void tabinit_4(ap_t *);
extern int do_seeing_4(ap_t *);
extern int process_results_4(ap_t *);
extern int tabclose_4(ap_t *);
extern void tabinit_gen(int, const char *[], const char *[], cpl_type[]);
extern int do_seeing_gen(ap_t *, const char *, const char *, char *[]);

/* AP routines */

extern void apclose(ap_t *);
extern void apfu(ap_t *);
extern void apinit(ap_t *);
extern void apreinit(ap_t *);
extern void apline(ap_t *, float [], int [], float [], float [], int, 
		   unsigned char *);
extern void apclust(ap_t *, int, plstruct *);
extern void moments (ap_t *, float []);
extern void areals(ap_t *, int [NAREAL]);
extern void restack(ap_t *, int);
extern void terminate(ap_t *);
extern void extract_data(ap_t *, int);

/* Global variables */
 
int verbose;               /* Verbose flag */
int cattype;               /* Flag for the type of table */
FILE *ellfp;               /* File descriptor for .ell file */
float gain;                /* Gain of the chip */
cpl_table *tab;            /* Table descriptor */
int nobjects;              /* Running total of objects catalogued */
int imcore_xcol;           /* Column in table for x position */
int imcore_ycol;           /* Column in table for y position */

/*

$Log: imcore.h,v $
Revision 1.10  2007/05/03 11:15:34  jim
Fixed little problem with table wcs

Revision 1.9  2007/05/02 09:11:35  jim
Modified to allow for inclusion of table WCS keywords into FITS header

Revision 1.8  2007/03/01 12:38:26  jim
Small modifications after a bit of code checking

Revision 1.7  2006/08/01 11:27:53  jim
Modifications to imcore background estimation and to add ability to
specify the smoothing kernel width

Revision 1.6  2006/06/30 21:31:09  jim
MOdifications to background routines and smoothing kernel

Revision 1.5  2006/06/06 13:04:22  jim
Fixed apline so that it now takes confidence map info correctly

Revision 1.4  2006/03/01 10:31:29  jim
Now uses new vir_fits objects

Revision 1.3  2005/11/28 13:49:45  jim
Fixed some MF_ definitions so that they aren't every negative

Revision 1.2  2005/09/22 08:40:42  jim
Fixed some bugs in imcore and added classification Removed some unnecessary
files

Revision 1.1  2005/09/13 13:25:28  jim
Initial entry after modifications to make cpl compliant


*/
