/* $Id: vircam_mods.h,v 1.31 2007/11/26 09:57:39 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2007/11/26 09:57:39 $
 * $Revision: 1.31 $
 * $Name:  $
 */

#ifndef VIRCAM_MODS_H
#define VIRCAM_MODS_H

#include <cpl.h>
#include "vircam_fits.h"
#include "vircam_tfits.h"
#include "vircam_mask.h"

/* Function prototypes */

extern int vircam_darkcor(vir_fits *infile, vir_fits *darksrc, float darkscl,
                          int *status);

extern int vircam_defringe(vir_fits **infiles, int nimages, vir_fits **fringes,
			   int nfringes, vir_mask *mask, int nbsize, 
			   int *status);

extern int vircam_destripe(vir_fits *in, vir_mask *inbpm, int *status);

extern int vircam_flatcor(vir_fits *infile, vir_fits *flatsrc, int *status);

extern int vircam_gaincor(vir_fits *infile, float gainscl, int *status);

extern int vircam_genbpm(vir_fits **flatlist, int nflatlist, float lthr,
			 float hthr, cpl_array **bpm_array, int *nbad,
			 float *badfrac, int *status);

extern int vircam_genlincur(double **fdata, int nimages, double *exps,
			    double mindit, vir_tfits *chantab, 
			    int norder, cpl_table **lchantab, 
			    double **lindata, int *status);

extern int vircam_getstds(cpl_propertylist *plist, int cache, char *path,
			  char *catname, cpl_table **stds, int *status);

extern int vircam_illum(vir_fits **images, cpl_table **mstds, 
			cpl_propertylist **pl, int nimages, char *filt,
			cpl_table *phottab, int nbsize, cpl_table **illcor, 
			float *illcor_rms, int *status);

extern int vircam_imcombine(vir_fits **fset, int nfits, int combtype, 
			    int scaletype, int xrej, float thresh,
                            cpl_image **outimage, unsigned char **rejmask,
                            unsigned char **rejplus, 
			    cpl_propertylist **drs, int *status);

extern int vircam_imcore(vir_fits *infile, vir_fits *conf, int ipix,
                         float threshold, int icrowd, float rcore, int nbsize,
                         int cattype, float filtfwhm, vir_tfits **outtab, 
			 int *status);

extern int vircam_imdither(vir_fits **inf, vir_fits **inconf, int nimages,
                           int nconfs, float lthr, float hthr,
                           cpl_propertylist **p, cpl_image **out,
                           cpl_image **outc, int *status);

extern int vircam_interleave(vir_fits **infiles, int ninputs, 
			     vir_fits **inconfs, int nconfs, int nsteps,
			     cpl_propertylist **p, cpl_image **outimage, 
			     cpl_image **outconf, int *status);

extern int vircam_lincor(vir_fits *infile, vir_tfits *lchantab,
			 int kconst, int ndit, int *status);

extern int vircam_matchxy(cpl_table *progtab, cpl_table *template, float srad,
			  float *xoffset, float *yoffset, int *nm, 
			  int *status);

extern int vircam_matchstds(cpl_table *objtab, cpl_table *stdstab, float srad,
			    cpl_table **outtab, int *status);

extern int vircam_xyarrays_match(float *x1, float *y1, int n1, float *x2,
				 float *y2, int n2,  float srad, int *matches,
				 int *nm, int *status);

extern int vircam_mkconf(cpl_image *flat, char *flatfile, vir_mask *bpm, 
			 cpl_image **outconf, cpl_propertylist **drs, 
			 int *status);

extern int vircam_photcal(vir_fits **images, cpl_table **mstds, 
			  cpl_propertylist **pl, int nimages, char *filt, 
			  cpl_table *phottab, int *status);

extern int vircam_platesol(cpl_propertylist *plist, cpl_propertylist *tlist,
			   cpl_table *matchedstds, int nconst, int shiftan, 
			   int *status);

#endif

/*

$Log: vircam_mods.h,v $
Revision 1.31  2007/11/26 09:57:39  jim
vircam_lincor now take account of ndit

Revision 1.30  2007/11/22 12:34:46  jim
Modifed calling parameters for vircam_genlincur

Revision 1.29  2007/11/14 10:44:28  jim
Modified to add vircam_genbpm and to rewrite the entry for vircam_genlincur

Revision 1.28  2007/10/25 17:34:00  jim
Modified to remove lint warnings

Revision 1.27  2007/05/08 10:42:00  jim
Added vircam_gaincor

Revision 1.26  2007/05/02 09:13:29  jim
Modified to change api of vircam_imcore (outtab is now vir_tfits) and
vircam_platesol (takes table propertylist)

Revision 1.25  2006/12/01 14:10:35  jim
Added vircam_defringe

Revision 1.24  2006/11/28 22:10:22  jim
Added illcor_rms to calling sequence of vircam_illum

Revision 1.23  2006/11/28 20:53:45  jim
Added vircam_illum

Revision 1.22  2006/11/27 12:04:02  jim
Modified prototype for vircam_getstds

Revision 1.21  2006/10/02 13:44:04  jim
Added vircam_destripe

Revision 1.20  2006/08/01 11:27:53  jim
Modifications to imcore background estimation and to add ability to
specify the smoothing kernel width

Revision 1.19  2006/05/30 14:27:54  jim
Added illcor parameter to call for photcal

Revision 1.18  2006/05/17 12:06:17  jim
Added vircam_photcal

Revision 1.17  2006/05/15 13:15:28  jim
added vircam_imdither

Revision 1.16  2006/04/20 11:28:29  jim
Added vircam_platesol and a few minor mods

Revision 1.15  2006/03/22 13:19:29  jim
modified vircam_mkconf

Revision 1.14  2006/03/22 12:02:55  jim
modified vircam_mkconf prototype

Revision 1.13  2006/03/15 10:43:41  jim
Fixed a few things

Revision 1.12  2006/03/08 14:32:22  jim
Lots of little modifications

Revision 1.11  2006/03/06 13:49:08  jim
Modified so that the DRS keywords are written directly to the extension header
for the input image

Revision 1.10  2006/03/03 14:29:46  jim
Modified definition of vir_fits and channel table

Revision 1.9  2006/03/01 10:31:29  jim
Now uses new vir_fits objects

Revision 1.8  2006/02/22 10:09:33  jim
Added status variables to vircam_imcombine and vircam_imcore

Revision 1.7  2006/02/18 11:48:55  jim
*** empty log message ***

Revision 1.6  2006/01/23 22:58:41  jim
*** empty log message ***

Revision 1.5  2006/01/23 10:30:31  jim
Modifications mainly to docs

Revision 1.4  2006/01/03 10:30:22  jim
Modified vircam_darkcor and vircam_flatcor

Revision 1.3  2005/10/14 13:18:25  jim
Modified parameter list for vircam_imcombine

Revision 1.2  2005/09/20 15:07:46  jim
Fixed a few bugs and added a few things

Revision 1.1.1.1  2005/08/05 08:29:09  jim
Initial import


*/
