/* $Id: vircam_channel.h,v 1.5 2006/11/10 09:26:18 jim Exp $
 *
 * This file is part of the VIRCAM Pipeline
 * Copyright (C) 2005 Cambridge Astronomy Survey Unit
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jim $
 * $Date: 2006/11/10 09:26:18 $
 * $Revision: 1.5 $
 * $Name:  $
 */


/* Includes */

#ifndef VIRCAM_CHANNEL_H
#define VIRCAM_CHANNEL_H

#include <cpl.h>


#define SECSIZ 64

/* Parquet structure for each channel */

typedef struct {
    int     channum;         /* Index of the channel on the current detector */
    int     ixmin;           /* X coordinate minimum */
    int     ixmax;           /* X coordinate maximum */
    int     iymin;           /* Y coordinate minimum */
    int     iymax;           /* Y coordinate maximum */
    long    fpix[2];         /* X,Y coordinate of first corner of channel */
    long    lpix[2];         /* X,Y coordinate of last corner of channel */
    char    imsec[SECSIZ];   /* Image section specification for channel */
    int     delta_i;         /* X length of channel */
    int     delta_j;         /* Y length of channel */
    int     Lx;              /* X location of readout point (starts with 0) */
    int     Ly;              /* Y location of readout point (starts with 0) */
    int     dcd1_1;          /* The number of fast readout coordinates for 
				each fast detector coordinate (x). 
				Can have values (-1,0,1) */
    int     dcd1_2;          /* The number of fast readout coordinates for 
				each slow detector coordinate (y). 
				Can have values (-1,0,1) */
    int     dcd2_1;          /* The number of slow readout coordinates for 
				each fast detector coordinate (x). 
				Can have values (-1,0,1) */
    int     dcd2_2;          /* The number of slow readout coordinates for 
				each slow detector coordinate (y). 
				Can have values (-1,0,1) */
    int     det_cd;          /* Determinant of the CD matrix */
    int     delta_x;         /* Dimension of fast readout axis */
    int     delta_y;         /* Dimension of the slow readout axis */
    float   *data;           /* Pointer to the channel data array */
    int     norder;          /* Order of the linearity fit */
    double  *bb;             /* Pointer to array of linearity coefficients */
} parquet;

/* External routine prototypes */

extern int vircam_chantab_verify(cpl_table *tab);
extern cpl_table *vircam_chantab_new(int nord, cpl_table *template);
extern int vircam_chan_fill(cpl_table *tab, parquet **p, long *np);
extern void vircam_chan_free(int np, parquet **p);
extern long vircam_chan_d2r(parquet *p, long l);
extern long vircam_chan_r2d(parquet *p, long k);
extern long vircam_chan_r2a(parquet *p, long naxis[2], long k);

#endif

/*

$Log: vircam_channel.h,v $
Revision 1.5  2006/11/10 09:26:18  jim
Modified definition of vircam_chantab_new

Revision 1.4  2006/09/08 09:21:02  jim
Added routine vircam_chantab_new

Revision 1.3  2006/03/15 10:43:41  jim
Fixed a few things

Revision 1.2  2006/03/03 14:29:45  jim
Modified definition of vir_fits and channel table

Revision 1.1  2006/01/23 10:29:20  jim
new file


*/
