/* Copyright (C) 2011 Steven Gratton */
#include "vecops.h"

vec_ig make_vecmuladdig(int r3,int r0,int4 chan0,int r1,int4 chan1,int r2, int4 chan2)
{
	vec_ig ig;
	reginfo dst,src0,src1,src2;
	dst.reg=r3;dst.chan=0;
	src0.reg=r0;src0.chan=chan0.i[0];
	src1.reg=r1;src1.chan=chan1.i[0];
	src2.reg=r2;src2.chan=chan2.i[0];
	ig.three_op[0]=simple_make_alu_three_op(OP3_INST_MULADD_IEEE,
				  dst,
				  src0,
				  src1,
				  src2,
				  0);
	dst.reg=r3;dst.chan=1;
	src0.reg=r0;src0.chan=chan0.i[1];
	src1.reg=r1;src1.chan=chan1.i[1];
	src2.reg=r2;src2.chan=chan2.i[1];
	ig.three_op[1]=simple_make_alu_three_op(OP3_INST_MULADD_IEEE,
				  dst,
				  src0,
				  src1,
				  src2,
				  0);
	dst.reg=r3;dst.chan=2;
	src0.reg=r0;src0.chan=chan0.i[2];
	src1.reg=r1;src1.chan=chan1.i[2];
	src2.reg=r2;src2.chan=chan2.i[2];
	ig.three_op[2]=simple_make_alu_three_op(OP3_INST_MULADD_IEEE,
				  dst,
				  src0,
				  src1,
				  src2,
				  0);
	dst.reg=r3;dst.chan=3;
	src0.reg=r0;src0.chan=chan0.i[3];
	src1.reg=r1;src1.chan=chan1.i[3];
	src2.reg=r2;src2.chan=chan2.i[3];
	ig.three_op[3]=simple_make_alu_three_op(OP3_INST_MULADD_IEEE,
				  dst,
				  src0,
				  src1,
				  src2,
				  1);
	return ig;
}

vec_ig make_vecmulig(int r3,int r0, int4 chan0, int r1, int4 chan1)
{
	vec_ig ig;
	reginfo dst,src0,src1;
	dst.reg=r3;dst.chan=0;
	src0.reg=r0;src0.chan=chan0.i[0];
	src1.reg=r1;src1.chan=chan1.i[0];
	ig.two_op[0]=simple_make_alu_two_op(OP2_INST_MUL,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=1;
	src0.reg=r0;src0.chan=chan0.i[1];
	src1.reg=r1;src1.chan=chan1.i[1];
	ig.two_op[1]=simple_make_alu_two_op(OP2_INST_MUL,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=2;
	src0.reg=r0;src0.chan=chan0.i[2];
	src1.reg=r1;src1.chan=chan1.i[2];
	ig.two_op[2]=simple_make_alu_two_op(OP2_INST_MUL,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=3;
	src0.reg=r0;src0.chan=chan0.i[3];
	src1.reg=r1;src1.chan=chan1.i[3];
	ig.two_op[3]=simple_make_alu_two_op(OP2_INST_MUL,
				  dst,
				  src0,
				  src1,
				  1);
	return ig;
}

vec_ig make_vecaddig(int r3,int r0,int4 chan0, int r1, int4 chan1)
{
	vec_ig ig;
	reginfo dst,src0,src1;
	dst.reg=r3;dst.chan=0;
	src0.reg=r0;src0.chan=chan0.i[0];
	src1.reg=r1;src1.chan=chan1.i[0];
	ig.two_op[0]=simple_make_alu_two_op(OP2_INST_ADD,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=1;
	src0.reg=r0;src0.chan=chan0.i[1];
	src1.reg=r1;src1.chan=chan1.i[1];
	ig.two_op[1]=simple_make_alu_two_op(OP2_INST_ADD,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=2;
	src0.reg=r0;src0.chan=chan0.i[2];
	src1.reg=r1;src1.chan=chan1.i[2];
	ig.two_op[2]=simple_make_alu_two_op(OP2_INST_ADD,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=3;
	src0.reg=r0;src0.chan=chan0.i[3];
	src1.reg=r1;src1.chan=chan0.i[3];
	ig.two_op[3]=simple_make_alu_two_op(OP2_INST_ADD,
				  dst,
				  src0,
				  src1,
				  1);
	return ig;
}

vec_ig make_vecmovig(int r3,int r0,int4 chan0)
{
	vec_ig ig;
	reginfo dst,src0,src1;
	dst.reg=r3;dst.chan=0;
	src0.reg=r0;src0.chan=0;
	src1.reg=ALU_SRC_0;src1.chan=chan0.i[0];
	ig.two_op[0]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=1;
	src0.reg=r0;src0.chan=chan0.i[1];
	src1.reg=ALU_SRC_0;src1.chan=1;
	ig.two_op[1]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=2;
	src0.reg=r0;src0.chan=chan0.i[2];
	src1.reg=ALU_SRC_0;src1.chan=2;
	ig.two_op[2]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=3;
	src0.reg=r0;src0.chan=chan0.i[3];
	src1.reg=ALU_SRC_0;src1.chan=3;
	ig.two_op[3]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  1);
	return ig;
}

vec_ig make_veczeroig(int r3)
{
	vec_ig ig;
	reginfo dst,src0,src1;
	dst.reg=r3;dst.chan=0;
	src0.reg=ALU_SRC_0;src0.chan=0;
	src1.reg=ALU_SRC_0;src1.chan=0;
	ig.two_op[0]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=1;
	src0.reg=ALU_SRC_0;src0.chan=1;
	src1.reg=ALU_SRC_0;src1.chan=1;
	ig.two_op[1]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=2;
	src0.reg=ALU_SRC_0;src0.chan=2;
	src1.reg=ALU_SRC_0;src1.chan=2;
	ig.two_op[2]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  0);
	dst.reg=r3;dst.chan=3;
	src0.reg=ALU_SRC_0;src0.chan=3;
	src1.reg=ALU_SRC_0;src1.chan=3;
	ig.two_op[3]=simple_make_alu_two_op(OP2_INST_MOV,
				  dst,
				  src0,
				  src1,
				  1);
	return ig;
}
