/* Copyright (C) 2011 Steven Gratton */
%{

  #include <stdio.h>
  #include <stdlib.h>
#include <string.h>

  int yyparse(void);
void yyerror(char*);
  int yylex(void);
  extern FILE* yyin;

  int useinputs[256]={0};
  int useoutputs[8]={0};
  int useuavs[16]={0};
  int usecbs[16]={0};
  int usecbssz[16]={0};
unsigned int codelen=0; // not tested for codelen > 0xffff
unsigned int numgprs=1; // total num used (no -1), but sometimes set to zero! 
unsigned int stacksize=1; // increase if necessary
 int useglob=0;
 int usevwin=0;
 int usevobj=0;
 int useintconstforloop=0;

  %}

%union {
  int i;
}

%start info

%token<i> UGLOB UIC UVWIN UVOBJ STACKSIZEEQ CODELENEQ NUMGPRSEQ
%token<i> INPUTS OUTPUTS UAVS CBS INP OUT UAV CB CBSZ
%type<i> info line inputs outputs inplist 
%type<i> cblist outlist uavlist cbinfo uavs cbs


%%

info: {$$=0;}
| info line {;}
;

line: UGLOB {useglob=1;}
| UVWIN {printf("received UVWIN\n");usevwin=1;}
| UVOBJ {usevobj=1;}
| UIC {useintconstforloop=1;}
| STACKSIZEEQ {stacksize=$1;}
| CODELENEQ {codelen=$1;}
| NUMGPRSEQ {numgprs=$1;}
| inputs 
| outputs
| uavs
| cbs
| '\n' {$$=0;}
;

inputs: INPUTS inplist {$$=0;}
;

inplist: {$$=0;}
| inplist INP { useinputs[$2]=1; $$=0;}
;

outputs: OUTPUTS outlist {$$=0;}
;

outlist: {$$=0;}
| outlist OUT {printf("received output %d.\n",$2);useoutputs[$2]=1;}
;

uavs: UAVS uavlist {$$=0;}
;

uavlist: {$$=0;}
| uavlist UAV {useuavs[$2]=1;}
;

cbs: CBS cblist {$$=0;}
;

cblist: {$$=0;}
| cblist cbinfo {$$=0;}
;

cbinfo: CB CBSZ {usecbs[$1]=1; usecbssz[$1]=$2;}
;

%%

#include "makeelf.h"

void yyerror (char *s) {
  printf("%s",s);
}

unsigned char* loadprog(char* fname, int *progsize){
	FILE* fp;
	fpos_t fpos;
	unsigned char* progpoint;
	fp=fopen(fname,"rb");
	fseek(fp,0L,SEEK_END);
	fgetpos(fp,&fpos);
	*progsize=fpos.__pos;
	printf("In load prog, file=%s.\n",fname);
	printf("In load prog, progsize=%d.\n",*progsize);
	rewind(fp);
	progpoint=(unsigned char*) malloc(*progsize);
	fread(progpoint,1,*progsize,fp);
	fclose(fp);
	return progpoint;
}

int readsampinfo(char* fname, int arr[1000][2]){
  FILE* fp;
  int pos=0;
  fp=fopen(fname,"r");
  while(fscanf(fp,"%d %d",&arr[pos][0], &arr[pos][1])!=EOF) pos++;
  fclose(fp);
  return pos;
}

int main(int argc,char* argv[])
{
	Elf32_Ehdr hdr;
	Elf32_Phdr phdr[3];
	CALEncodingDictionaryEntry progenc;
	Elf32_Shdr shdr[6];
	unsigned char shstrtab[]="\0.shstrtab\0.text\0.data\0.symtab\0.strtab\0";
	unsigned char data[0x1280];
	unsigned char* prog;
	CALNoteHeader mynoteheader[18];
	CALProgramInfoEntry caymanproginfo[62];
	char strtabbuf[10000];
	char* strtab;
	Elf32_Sym symtab[1000];

	int sampinfo[1000][2]={0,};
	int numsampinfo=0;

	int progsize;

	char progfile[80];
	char sizesfile[80];
	char setupfile[80];
	char sampinfofile[80];
	char elffile[80];

	char progfilepostfix[20]=".out";
	char sizesfilepostfix[20]=".sizes";
	char setupfilepostfix[20]=".setup";
	char sampinfofilepostfix[20]=".tex.sampinfo";
	char elffilepostfix[20]=".elf";
	
	numsampinfo=readsampinfo(
	   strcat(strcpy(sampinfofile,argv[1]),sampinfofilepostfix),
		     sampinfo);


	prog=loadprog(strcat(strcpy(progfile,argv[1]),progfilepostfix)
		      ,&progsize);

	memset(data,0,0x1280);

	int numinputs=0;
	int numoutputs=0;
	int numuavs=0;
	int numcbs=0;


int cftot,alutot,textot,alustart,texstart;

 FILE* sizesfp;
sizesfp=fopen(strcat(strcpy(sizesfile,argv[1]),sizesfilepostfix),"r");
fscanf(sizesfp,"%d %d %d %d %d",&cftot,&alutot,&textot,&alustart,&texstart);
fclose(sizesfp);

printf("%d %d %d %d %d\n",cftot,alutot,textot,alustart,texstart);

 codelen=cftot;

  for (int i=0;i<8;i++) printf("useoutputs[%d]=%d.\n",i,useoutputs[i]);

  yyin=fopen(strcat(strcpy(setupfile,argv[1]),setupfilepostfix),"r");
  printf("Now calling yyparse...\n");
  yyparse();

  for (int i=0;i<8;i++) printf("useoutputs[%d]=%d.\n",i,useoutputs[i]);


  int inputs[256]={0};
  int outputs[8]={0};
  int uavs[16]={0};
  int cbs[16]={0};
  int cbssz[16]={0};

  for (int i=0;i<8;i++) printf("outputs[%d]=%d.\n",i,outputs[i]);

	  int ipos=0;
	for (int i=255; i>=0;i--) {
	  if(useinputs[i]==1) {inputs[ipos++]=i; numinputs++;}
	}

	  int opos=0;
	for (int i=7; i>=0;i--) {
	  if(useoutputs[i]==1) { outputs[opos++]=i; numoutputs++;}
	}

  for (int i=0;i<8;i++) printf("outputs[%d]=%d.\n",i,outputs[i]);

	  int upos=0;
	for (int i=15; i>=0;i--) {
	  if(useuavs[i]==1) {uavs[upos++]=i; numuavs++;}
	}

	  int cbpos=0;
	for (int i=15; i>=0;i--) {
	  if(usecbs[i]==1) {cbs[cbpos]=i; cbssz[cbpos++]=usecbssz[i]; numcbs++;}
	}


	printf("\nInputs complete: \n");
	printf("CF codelen=%d.\n",codelen);
	printf("stacksize=%d.\n",stacksize);
	printf("numgprs=%d.\n",numgprs);
	printf("numinputs=%d.\n",numinputs);
	printf("numoutputs=%d.\n",numoutputs);
	printf("numuavs=%d.\n",numuavs);
	printf("numcbs=%d.\n",numcbs);
	printf("useglob=%d.\n",useglob);
	printf("usevobj=%d.\n",usevobj);
	printf("usevwin=%d.\n",usevwin);	
	printf("useintconstforloop=%d.\n\n",useintconstforloop);


	int notesize=sizeof(mynoteheader)-sizeof(CALNoteHeader)+sizeof(caymanproginfo)
		+4*(numinputs+numoutputs+2*numsampinfo+2*numcbs+4*numuavs+5+useglob+2*useintconstforloop);


	unsigned int sqpgmresources=0x70000000+(stacksize<<8)+numgprs; //prime cache enable
	// always set, following calcl's example

	unsigned int cbshadermask=0x0; //funnily this seems to set each used
	// channel to F irrespective of whether it is masked...
	for (int i=0;i<numoutputs;i++){
		cbshadermask+=(0xf<<outputs[i]);
	}
	unsigned int dbshadercontrol;
	if (useglob) 
		dbshadercontrol=0x4600; 
	else 
		dbshadercontrol=0x4210;
	//nb also seen 0x4211 and 0x4601 if using uavs and no outputs
	// seems to be replacing a colour output with a z one -- see sqpgmexportsps also...

	unsigned int codelencodelen=(codelen << 16) + codelen;
	unsigned int sqpgmexportsps=numoutputs<<1; // add one to export z
	unsigned int spipsincontrol0=0x0;
	unsigned int spipsincontrol1=0x0;
	unsigned int spipsincontrol2=0x0;

	// both seem to have to be be nonzero,
	// even if you don't use outputs
	// perhaps only is you use a global buffer.
	// Not sure how this is affected if one has no colour but z...
	if(cbshadermask==0) cbshadermask=0xf; 
	if(sqpgmexportsps==0) sqpgmexportsps=0x2;

	if (usevwin&&usevobj) 
	{spipsincontrol0=0x100;spipsincontrol1=0x1100;}
	// vobj in R1.w and vWin is R0.xy 
	else if (usevwin) 
		spipsincontrol0=0x100; // vwin in R0.xy
	else if(usevobj) 
		spipsincontrol1=0x100; // vobj in R0.w

	printf("sqpgmexportsps=0x%8.8x.\n",sqpgmexportsps);
	printf("spipsincontrol0=0x%8.8x.\n",spipsincontrol0);
	printf("spipsincontrol1=0x%8.8x.\n",spipsincontrol1);
	printf("spipsincontrol2=0x%8.8x.\n",spipsincontrol2);
	printf("codelen=%d, codelencodelen=0x%8.8x.\n\n",codelen,codelencodelen);


	strtab=strtabbuf;
	int strtabcount=0;
	int symtabcount=0;

	symtab[symtabcount++]=Elf32_Sym();

	for (int i=0;i<numinputs;i++){
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,i,2);
		strtab+=sprintf(strtab,"i%d",inputs[i]);
		strtab++;
		strtabcount++;
	}

	for (int i=0;i<numsampinfo;i++){
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,i,11);
		strtab+=sprintf(strtab,"s%d",sampinfo[i][1]);
		strtab++;
		strtabcount++;
	}

	for (int i=0;i<numoutputs;i++){
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,i,3);
		strtab+=sprintf(strtab,"o%d",outputs[i]);
		strtab++;
		strtabcount++;
	}

	for (int i=0;i<numuavs;i++){
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,i,16);
		strtab+=sprintf(strtab,"uav%d",uavs[i]);
		strtab++;
		strtabcount++;
	}

	if(useglob) {
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,0,9);
		strtab+=sprintf(strtab,"g[]");
		strtab++;
		strtabcount++;
	}

	for (int i=0;i<numcbs;i++){
		symtab[symtabcount++]=Elf32_Sym(strtab-strtabbuf+1,i,10);
		strtab+=sprintf(strtab,"cb%d",cbs[i]);
		strtab++;
		strtabcount++;
	}
	sprintf(strtab,""); //final null
	strtabcount++;

	printf("strtabcount=%d\n",strtabcount);

	hdr.e_ident[0]=0x7f;
	hdr.e_ident[1]='E';
	hdr.e_ident[2]='L';
	hdr.e_ident[3]='F';
	hdr.e_ident[4]=1;
	hdr.e_ident[5]=1;
	hdr.e_ident[6]=1;
	hdr.e_ident[7]=0x64;
	hdr.e_ident[8]=1;
	hdr.e_ident[9]=0;
	hdr.e_ident[10]=0;
	hdr.e_ident[11]=0;
	hdr.e_ident[12]=0;
	hdr.e_ident[13]=0;
	hdr.e_ident[14]=0;
	hdr.e_ident[15]=0;

	hdr.e_type=2;
	hdr.e_machine=0x7d;
	hdr.e_version=1;
	hdr.e_entry=0;
	hdr.e_phoff=sizeof(hdr);
	hdr.e_shoff=sizeof(hdr)+sizeof(phdr)+sizeof(progenc)+sizeof(shstrtab);
	hdr.e_flags=1; //?
	hdr.e_ehsize=0x34;
	hdr.e_phentsize=0x20;
	hdr.e_phnum=3;
	hdr.e_shentsize=40;
	hdr.e_shnum=6;
	hdr.e_shstrndx=1;

	phdr[0].p_type=PT_LOPROC+2;
	phdr[0].p_offset=sizeof(hdr)+sizeof(phdr);
	phdr[0].p_vaddr=0;
	phdr[0].p_paddr=0;
	phdr[0].p_filesz=sizeof(progenc);
	phdr[0].p_memsz=0;
	phdr[0].p_flags=0;
	phdr[0].p_align=0;

	phdr[1].p_type=PT_NOTE;
	phdr[1].p_offset=sizeof(hdr)+sizeof(phdr)+sizeof(progenc)+sizeof(shstrtab)+sizeof(shdr);
	phdr[1].p_vaddr=0;
	phdr[1].p_paddr=0;
	phdr[1].p_filesz=notesize;
	phdr[1].p_memsz=0;
	phdr[1].p_flags=0;
	phdr[1].p_align=0;

	phdr[2].p_type=PT_LOAD;
	phdr[2].p_offset=phdr[1].p_offset+notesize;
	phdr[2].p_vaddr=0;
	phdr[2].p_paddr=0;
	phdr[2].p_filesz=progsize+sizeof(data)+symtabcount*sizeof(Elf32_Sym)+strtab-strtabbuf+2;
	phdr[2].p_memsz=phdr[2].p_filesz;
	phdr[2].p_flags=0;
	phdr[2].p_align=0;

	progenc.d_machine=CAL_TARGET_CAYMAN;
	progenc.d_type=CAL_PROGRAM_TYPE_PS;
	progenc.d_offset=phdr[1].p_offset;
	progenc.d_size=phdr[1].p_filesz+phdr[2].p_filesz;
	progenc.d_flags=0;

	int shstrtabos=sizeof(hdr)+sizeof(phdr)+sizeof(progenc);
	int shos=sizeof(hdr)+sizeof(phdr)+sizeof(progenc)+sizeof(shstrtab);

	shdr[0].sh_name=0;
	shdr[0].sh_type=0;
	shdr[0].sh_flags=0;
	shdr[0].sh_addr=0;
	shdr[0].sh_offset=0;
	shdr[0].sh_size=0;
	shdr[0].sh_link=0;
	shdr[0].sh_info=0;
	shdr[0].sh_addralign=0;
	shdr[0].sh_entsize=0;

	shdr[1].sh_name=1;
	shdr[1].sh_type=SHT_STRTAB;
	shdr[1].sh_flags=0;
	shdr[1].sh_addr=0;
	shdr[1].sh_offset=shstrtabos;
	shdr[1].sh_size=0x28;
	shdr[1].sh_link=0;
	shdr[1].sh_info=0;
	shdr[1].sh_addralign=0;
	shdr[1].sh_entsize=0;

	shdr[2].sh_name=11;
	shdr[2].sh_type=SHT_PROGBITS;
	shdr[2].sh_flags=0;
	shdr[2].sh_addr=0;
	shdr[2].sh_offset=sizeof(hdr)+sizeof(phdr)+sizeof(progenc)
		+sizeof(shstrtab)+sizeof(shdr)+notesize;
	shdr[2].sh_size=progsize;
	shdr[2].sh_link=0;
	shdr[2].sh_info=0;
	shdr[2].sh_addralign=0;
	shdr[2].sh_entsize=0;

	shdr[3].sh_name=17;
	shdr[3].sh_type=SHT_PROGBITS;
	shdr[3].sh_flags=0;
	shdr[3].sh_addr=0;
	shdr[3].sh_offset=sizeof(hdr)+sizeof(phdr)+sizeof(progenc)
		+sizeof(shstrtab)+sizeof(shdr)+notesize+progsize;
	shdr[3].sh_size=0x1280;
	shdr[3].sh_link=0;
	shdr[3].sh_info=0;
	shdr[3].sh_addralign=0;
	shdr[3].sh_entsize=0x1280;

	shdr[4].sh_name=23;
	shdr[4].sh_type=SHT_SYMTAB;
	shdr[4].sh_flags=0;
	shdr[4].sh_addr=0;
	shdr[4].sh_offset=shdr[3].sh_offset+0x1280;
	shdr[4].sh_size=sizeof(Elf32_Sym)*symtabcount;
	shdr[4].sh_link=5;
	shdr[4].sh_info=1;
	shdr[4].sh_addralign=0;
	shdr[4].sh_entsize=0x10;

	shdr[5].sh_name=31;
	shdr[5].sh_type=SHT_STRTAB;
	shdr[5].sh_flags=0;
	shdr[5].sh_addr=0;
	shdr[5].sh_offset=shdr[4].sh_offset+shdr[4].sh_size;
	shdr[5].sh_size=strtab-strtabbuf+2;
	shdr[5].sh_link=0;
	shdr[5].sh_info=0;
	shdr[5].sh_addralign=0;
	shdr[5].sh_entsize=0;

	mynoteheader[1]=CALNoteHeader(1,sizeof(caymanproginfo));
	mynoteheader[2]=CALNoteHeader(2,4*numinputs);
	mynoteheader[3]=CALNoteHeader(3,4*numoutputs);
	mynoteheader[4]=CALNoteHeader(4,4);
	mynoteheader[5]=CALNoteHeader(5,0);
	if(useintconstforloop) {mynoteheader[6]=CALNoteHeader(6,8);} 
	  else {mynoteheader[6]=CALNoteHeader(6,0);}
	mynoteheader[7]=CALNoteHeader(7,0);
	mynoteheader[8]=CALNoteHeader(8,4);
	if(useglob) mynoteheader[9]=CALNoteHeader(9,4); else mynoteheader[9]=CALNoteHeader(9,0);
	mynoteheader[10]=CALNoteHeader(10,8*numcbs);
	mynoteheader[11]=CALNoteHeader(11,8*numsampinfo);
	mynoteheader[12]=CALNoteHeader(12,0);
	mynoteheader[13]=CALNoteHeader(13,4);
	mynoteheader[14]=CALNoteHeader(14,0);
	mynoteheader[15]=CALNoteHeader(15,4);
	mynoteheader[16]=CALNoteHeader(16,16*numuavs);
	mynoteheader[17]=CALNoteHeader(17,4);

	int pos=0;

	caymanproginfo[pos++]=CALProgramInfoEntry(0xA210,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA211,sqpgmresources);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA212,0x000000C0);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA213,sqpgmexportsps);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B3,spipsincontrol0);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B4,spipsincontrol1);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B9,spipsincontrol2);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B8,0x00000001);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B6,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000000,0x00000001);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000001,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA191,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA192,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA193,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA194,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA195,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA196,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA197,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA198,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA199,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19A,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19B,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19C,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19D,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19E,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA19F,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A0,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A1,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A2,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A3,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A4,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A5,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A6,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A7,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A8,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1A9,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AA,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AB,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AC,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AD,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AE,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1AF,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA1B0,codelencodelen);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA08F,cbshadermask);
	caymanproginfo[pos++]=CALProgramInfoEntry(0xA203,dbshadercontrol);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x2301,0x400000F8);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x2302,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x2300,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x8000001F,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000020,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000010,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000011,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000012,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000013,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000014,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000015,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000016,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000017,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000018,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x80000019,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x8000001A,0x00000000);
	caymanproginfo[pos++]=CALProgramInfoEntry(0x8000001B,0x00000000);



	FILE* fp;
	fp=fopen(strcat(strcpy(elffile,argv[1]),elffilepostfix),"wb");
	fwrite(&hdr,1,sizeof(hdr),fp);
	fwrite(phdr,1,sizeof(phdr),fp);
	fwrite(&progenc,1,sizeof(progenc),fp);
	fwrite(shstrtab,1,sizeof(shstrtab),fp);
	fwrite(shdr,1,sizeof(shdr),fp);



	fwrite(&mynoteheader[2],1,sizeof(CALNoteHeader),fp);
	fwrite(inputs,4,numinputs,fp);

	fwrite(&mynoteheader[3],1,sizeof(CALNoteHeader),fp);
	fwrite(outputs,4,numoutputs,fp);

	fwrite(&mynoteheader[16],1,sizeof(CALNoteHeader),fp);

	for (int i=0;i<numuavs;i++){
		CALUAVEntry tmpuavinfo(uavs[i]);
		fwrite(&tmpuavinfo,1,sizeof(CALUAVEntry),fp);
	}

	fwrite(&mynoteheader[4],1,sizeof(CALNoteHeader),fp);
	fwrite("\0\0\0\0",1,4,fp);

	fwrite(&mynoteheader[5],1,sizeof(CALNoteHeader),fp);
	fwrite(&mynoteheader[6],1,sizeof(CALNoteHeader),fp);
	if (useintconstforloop) 
	  {
	    CALDataSegmentDesc uicfl;
	    uicfl.offset=0;
	    uicfl.size=16;
	    fwrite(&uicfl,1,8,fp);
	    data[0x1000]=0xff;
	    data[0x1001]=0xff;
	    data[0x1002]=0xff;
	    data[0x1003]=0xff;
	  }

	fwrite(&mynoteheader[7],1,sizeof(CALNoteHeader),fp);
	fwrite(&mynoteheader[8],1,sizeof(CALNoteHeader),fp);
	fwrite("\0\0\0\0",1,4,fp);
	fwrite(&mynoteheader[9],1,sizeof(CALNoteHeader),fp);
	if(useglob) fwrite(&useglob,1,4,fp);
	fwrite(&mynoteheader[10],1,sizeof(CALNoteHeader),fp);
	for (int i=0;i<numcbs;i++){
		int tmpi2[2];
		tmpi2[0]=cbs[i];
		tmpi2[1]=cbssz[i];
		fwrite(tmpi2,1,sizeof(tmpi2),fp);
	}
	fwrite(&mynoteheader[11],1,sizeof(CALNoteHeader),fp);
	for (int i=0;i<numsampinfo;i++){
		int tmpi2[2];
		tmpi2[0]=sampinfo[i][0];
		tmpi2[1]=sampinfo[i][1];
		fwrite(tmpi2,1,sizeof(tmpi2),fp);
	}


	fwrite(&mynoteheader[13],1,sizeof(CALNoteHeader),fp);
	fwrite("\0\0\0\0",1,4,fp);
	fwrite(&mynoteheader[12],1,sizeof(CALNoteHeader),fp);
	fwrite(&mynoteheader[1],1,sizeof(CALNoteHeader),fp);
	fwrite(caymanproginfo,1,sizeof(caymanproginfo),fp);

	fwrite(&mynoteheader[14],1,sizeof(CALNoteHeader),fp);
	fwrite(&mynoteheader[15],1,sizeof(CALNoteHeader),fp);
	fwrite("\0\0\0\0",1,4,fp);
	fwrite(&mynoteheader[17],1,sizeof(CALNoteHeader),fp);
	fwrite("\0\0\0\0",1,4,fp);

	fwrite(prog,1,progsize,fp);
	fwrite(data,1,sizeof(data),fp);
	fwrite(symtab,sizeof(Elf32_Sym),symtabcount,fp);

	fwrite("\0",1,1,fp);
	fwrite(strtabbuf,1,strtab-strtabbuf+1,fp);

	fclose(fp);

	printf("symtabcount=%d.\n",symtabcount);

	free(prog);



 return 0;
}
