/* Copyright (C) 2011 Steven Gratton */
%{
#include "y.tab.h"
%}

%%

USE_GLOB {return UGLOB;}
USE_VWIN {return UVWIN;}
USE_VOBJ {return UVOBJ;}
USE_LOOPS {return UIC;}
STACK_SIZE=[0-9]+ {yylval.i=atof(yytext+11); return STACKSIZEEQ;}

CODE_LEN=[0-9]+ {yylval.i=atof(yytext+10); return CODELENEQ;}

NUM_GPRS=[0-9]+ {yylval.i=atof(yytext+9); return NUMGPRSEQ;}

USE_INPUTS: {return INPUTS;}

USE_OUTPUTS: {return OUTPUTS;}

USE_UAVS: {return UAVS;}

USE_CBS: {return CBS;}

uav[0-9]+ {yylval.i=atof(yytext+3); return UAV;}
i[0-9]+ {yylval.i=atof(yytext+1); return INP;}
o[0-9]+ {yylval.i=atof(yytext+1); return OUT;}
cb[0-9]+ {yylval.i=atof(yytext+2); return CB;}
"["[0-9]+ {yylval.i=atof(yytext+1); return CBSZ;}

"]"

[#].*

[ ]+
%%

int yywrap (void) {
return 1;
}

