/* Copyright (C) 2011 Steven Gratton */
#ifndef OPS_H
#define OPS_H

#include <cstdio>
#include <cstring>

#include "cayman.h"

extern FILE* cfp;
extern FILE* texfp;
extern FILE* alufp;

extern unsigned char* cbp;
extern unsigned char* texbp;
extern unsigned char* alubp;

  typedef struct reginfo_s {
  int reg; int chan; int neg; int abs;
}  reginfo;



struct cf_op : 
	cf_word0,cf_word1 {};

struct cf_alu_op : 
	cf_alu_word0, cf_alu_word1 {};

struct cf_export_rat_op: 
	cf_alloc_export_word0_rat, cf_alloc_export_word1_buf {};

struct cf_export_buf_op :
	cf_alloc_export_word0, cf_alloc_export_word1_buf {};

struct cf_export_swiz_op :
	cf_alloc_export_word0, cf_alloc_export_word1_swiz {};

struct vtx_gpr_op :
	vtx_word0, vtx_word1_gpr, vtx_word2, vtx_word3 {};

struct tex_op :
	tex_word0, tex_word1, tex_word2, tex_word3 {};

struct mem_rd_op :
	mem_rd_word0, mem_rd_word1, mem_rd_word2, mem_rd_word3 {};

struct alu_two_op : 
	alu_word0, alu_word1_op2 {};

struct alu_three_op: 
	alu_word0,alu_word1_op3 {};
/*
struct alu_execute_mask_two_op :
	alu_word0, alu_word1_op2_execute_mask {};
*/

cf_op make_cf_op(cf_inst_tag inst,
				 int addr,
				 int jts,
				 int pc,
				 int cfconst,
				 int cond,
				 int count,
				 int vpm,
				 int barrier);			

cf_alu_op make_cf_alu_op(cf_alu_inst_tag inst,
						 int addr,
						 int kb0,
						 int kb1,
						 int km0,
						 int km1,
						 int kcaddr0,
						 int kcaddr1,
						 int count,
						 int ac,
						 int wqm,
						 int barrier);

cf_export_rat_op make_cf_export_rat_op(rat_inst_tag ratinst, cf_inst_mem_buf_tag inst,
									   int ratid,
									   int rim,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int es,
									   int arraysize,
									   int compmask,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier);

cf_export_buf_op make_cf_export_buf_op(cf_inst_mem_buf_tag inst,
									   int arraybase,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int elemsize,
									   int arraysize,
									   int compmask,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier);

cf_export_swiz_op make_cf_export_swiz_op(cf_inst_swiz_tag inst,
									   int arraybase,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int elemsize,
									   int selx,
									   int sely,
									   int selz,
									   int selw,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier);

vtx_gpr_op make_vtx_gpr_op(vc_inst_tag inst,
						   int ft,
						   int fwq,
						   int buffid,
						   int srcgpr,
						   int srcrel,
						   int ssx,
						   int ssy,
						   int sr,
						   int lr,
						   int coalescedread,
						   int dstgpr,
						   int dstrel,
						   int dsx,
						   int dsy,
						   int dsz,
						   int dsw,
						   int ucf,
						   int dataformat,
						   int nfa,
						   int fca,
						   int sma,
						   int offset,
						   int es,
						   int cbns,
						   int ac,
						   int bim);

tex_op simple_make_tex_op(tex_inst_tag inst,
				   int dstgpr,
				   int srcgpr,
				   int resid,
				   int samplerid);

tex_op make_tex_op(tex_inst_tag inst,
				   int instmod,
				   int fwq,
				   int resid,
				   int srcgpr,
				   int sr,
				   int ac,
				   int rim,
				   int sim,
				   int dstgpr,
				   int dr,
				   int dsx,
				   int dsy,
				   int dsz,
				   int dsw,
				   int lodbias,
				   int ctx,
				   int cty,
				   int ctz,
				   int ctw,
				   float offx,
				   float offy,
				   float offz,
				   int samplerid,
				   int ssx,
				   int ssy,
				   int ssz,
				   int ssw);




mem_rd_op make_mem_rd_op(mem_rd_inst_tag inst,
						 int elemsize,
						 int fwq,
						 mem_rd_mem_op_tag memop,
						 int uncached,
						 int indexed,
						 int ssy,
						 int srcgpr,
						 int srcrel,
						 int ssx,
						 int burstcount,
						 int ldsreq,
						 int coalescedread,
						 int dstgpr,
						 int dstrel,
						 int dsx,
						 int dsy,
						 int dsz,
						 int dsw,
						 int dataformat,
						 int numformatall,
						 int formatcompall,
						 int srfmodeall,
						 int arraybase,
						 int endianswap,
						 int arraysize
						 );

alu_two_op make_alu_two_op(op2_inst_tag inst,
						   int s0sel, int s0r, int s0c, int s0n, int s0a,
						   int s1sel, int s1r, int s1c, int s1n, int s1a,
						   int dstgpr, int dr, int dc, int wm, int om,
						   int im,
						   int ps,
						   int l,
						   int uem,
						   int up,
						   int bs,
						   int c);

alu_three_op make_alu_three_op(op3_inst_tag inst,
						   int s0sel, int s0r, int s0c, int s0n,
						   int s1sel, int s1r, int s1c, int s1n,
						   int s2sel, int s2r, int s2c, int s2n,
						   int dstgpr, int dr, int dc,
						   int im,
						   int ps,
						   int l,
						   int bs,
						   int c);

alu_literal make_alu_literal(float a, float b);

alu_two_op simple_make_alu_two_op(op2_inst_tag inst,
				  reginfo dst,
				  reginfo src0,
				  reginfo src1,
				  int last);

alu_three_op simple_make_alu_three_op(op3_inst_tag inst,
				  reginfo dst,
				  reginfo src0,
				  reginfo src1,
				  reginfo src2,
				  int last);

#endif
