/* Copyright (C) 2011 Steven Gratton */
#include <cstring>

typedef enum CALtargetEnum {
   CAL_TARGET_600=0x0,   
   CAL_TARGET_610=0x1,
   CAL_TARGET_630=0x2,  
   CAL_TARGET_670=0x3,
   CAL_TARGET_7XX=0x4, 
   CAL_TARGET_770=0x4,
   CAL_TARGET_710=0xb,
   CAL_TARGET_730=0xc, 
   CAL_TARGET_CYPRESS=0x9,
   CAL_TARGET_JUNIPER=0xd, 
   CAL_TARGET_REDWOOD=0xe, 
   CAL_TARGET_CEDAR=0xf,    
   CAL_TARGET_RESERVED0=0x16,
   CAL_TARGET_RESERVED1=0x17,
   CAL_TARGET_WRESTLER=0x18,     
   CAL_TARGET_CAYMAN=0x11,
   CAL_TARGET_RESERVED2=0x12,
   CAL_TARGET_BARTS=0x13,
} CALtarget;

typedef enum CALCLprogramTypeEnum {
  CAL_PROGRAM_TYPE_PS=0,  // pixel program
  CAL_PROGRAM_TYPE_CS=4  // compute program
} CALCLprogramType;


typedef unsigned int Elf32_Addr;
typedef unsigned short Elf32_Half;
typedef unsigned int Elf32_Off;
typedef signed int Elf32_Sword;
typedef unsigned int Elf32_Word;

#define EI_NIDENT 16
#define ET_LOPROC 0xff00

typedef struct {
unsigned char e_ident[EI_NIDENT];
Elf32_Half e_type;
Elf32_Half e_machine;
Elf32_Word e_version;
Elf32_Addr e_entry;
Elf32_Off e_phoff;
Elf32_Off e_shoff;
Elf32_Word e_flags;
Elf32_Half e_ehsize;
Elf32_Half e_phentsize;
Elf32_Half e_phnum;
Elf32_Half e_shentsize;
Elf32_Half e_shnum;
Elf32_Half e_shstrndx;
} Elf32_Ehdr;


typedef struct
{
Elf32_Word p_type;
Elf32_Off p_offset;
Elf32_Addr p_vaddr;
Elf32_Addr p_paddr;
Elf32_Word p_filesz;
Elf32_Word p_memsz;
Elf32_Word p_flags;
Elf32_Word p_align;
} Elf32_Phdr;

typedef struct {
Elf32_Word sh_name;
Elf32_Word sh_type;
Elf32_Word sh_flags;
Elf32_Addr sh_addr;
Elf32_Off sh_offset;
Elf32_Word sh_size;
Elf32_Word sh_link;
Elf32_Word sh_info;
Elf32_Word sh_addralign;
Elf32_Word sh_entsize;
} Elf32_Shdr;

struct Elf32_Sym {
Elf32_Word st_name;
Elf32_Addr st_value;
Elf32_Word st_size;
unsigned char st_info;
unsigned char st_other;
Elf32_Half st_shndx;
Elf32_Sym(): st_name(0),st_value(0),st_size(0), st_info('\0'), st_other('\0'), st_shndx(0) {};
Elf32_Sym(int name,int val,int index) : st_name(name), st_value(val), st_size(0), st_info('\0'), st_other('\0'), st_shndx(index) {};
};


enum sht_type_tag {
	SHT_NULL=0,
SHT_PROGBITS=1,
SHT_SYMTAB=2,
SHT_STRTAB=3,
SHT_RELA=4,
SHT_HASH=5,
SHT_DYNAMIC=6,
SHT_NOTE=7,
SHT_NOBITS=8,
SHT_REL=9,
SHT_SHLIB=10,
SHT_DYNSYM=11,
SHT_LOPROC=0x70000000,
SHT_HIPROC=0x7fffffff,
SHT_LOUSER=0x80000000,
SHT_HIUSER=0xffffffff,
};

enum p_type_tag {
PT_NULL=0,
PT_LOAD=1,
PT_DYNAMIC=2,
PT_INTERP=3,
PT_NOTE=4,
PT_SHLIB=5,
PT_PHDR=6,
PT_LOPROC=0x70000000,
PT_HIPROC=0x7fffffff,
};

struct CALProgramInfoEntry{
  Elf32_Word address; // address
  Elf32_Word value; // value
CALProgramInfoEntry() {}
CALProgramInfoEntry(unsigned int a,unsigned int v): address(a), value(v) {}
} ;

typedef struct {
  Elf32_Word input; // input/resource identifier 
  Elf32_Word sampler; // identfier for sampler
} CALSamplerMapEntry;

struct CALConstantBufferMask {
  Elf32_Word index; // const buff identifier
  Elf32_Word size; // size of buff, in vec4fs 
CALConstantBufferMask() {}
CALConstantBufferMask(Elf32_Word index,Elf32_Word size):index(index),size(size) {}
} ;

typedef struct {
  Elf32_Word offset;//byte offset to data start
  Elf32_Word size;// data size in bytes
} CALDataSegmentDesc;

struct CALNoteHeader{
Elf32_Word namesz;
Elf32_Word descsz;
Elf32_Word type;
char name[8];
CALNoteHeader() {}
CALNoteHeader(int tp,int sz): namesz(8),descsz(sz),type(tp) {
strcpy(name,"ATI CAL");}
} ;

typedef struct {
Elf32_Word d_machine;
Elf32_Word d_type;
Elf32_Off d_offset;
Elf32_Word d_size;
Elf32_Word d_flags; }
CALEncodingDictionaryEntry;

// Field f1 seems to be 2 for arena UAV
struct CALUAVEntry {
	int uavnum;
	int f1;
	int f2;
	int f3;
	CALUAVEntry() : uavnum(0), f1(0), f2(0), f3(0) {}
	CALUAVEntry(int num) : uavnum(num), f1(0), f2(0), f3(5) {} 
};


enum CALNoteType_tag {
ELF_NOTE_ATI_INPUTS=2,
ELF_NOTE_ATI_OUTPUTS=3,
//ELF_NOTE_ATI_FLOATCONSTS=5, //?
//ELF_NOTE_ATI_INTCONSTS=6, //?
//ELF_NOTE_ATI_BOOLCONSTS=7, //?
//ELF_NOTE_ATI_EARLYEXIT=8, //?
ELF_NOTE_ATI_GLOBAL_BUFFERS=9,
ELF_NOTE_ATI_CONSTANT_BUFFERS=10,
ELF_NOTE_ATI_INPUT_SAMPLER_MAP=11, //?
//ELF_NOTE_ATI_SCRATCH_BUFFER=12, //?
//ELF_NOTE_ATI_PERSISTANT_BUFFER=13, //?
ELF_NOTE_ATI_PROGRAM_INFO=1,
ELF_NOTE_ATI_UAV=16,
} ;
