// Copyright (C) 2011 Steven Gratton

#include <iostream>
#include <calcl.h>
#include <cstdio>


using namespace std;


void disp(const char* msg)
{
	cout << msg;
}

FILE* fpgpu;
void dispfile(const char* msg)
{
	fprintf(fpgpu,"%s",msg);
}


int main(int argc, char* argv[])
{
  if (argc!=4) {
    fprintf(stderr,"usage: ilimg file.il file.elf file.isa\n");
    exit(-1);
  }


	CALuint version[3];
	calclGetVersion(&version[0], &version[1], &version[2]);
	fprintf(stderr, "Using CAL Compiler version %d.%d.%d...\n",
		version[0], version[1], version[2]);
   FILE* fp;
   fpos_t inpsz;
   fp=fopen(argv[1],"r");
   fseek(fp,0l,SEEK_END);
   fgetpos(fp,&inpsz);
   rewind(fp);
   char* inpbuff=(char*) malloc(inpsz+10);
   fread(inpbuff,1,inpsz,fp);
   fclose(fp);
	inpbuff[inpsz]='\0';

	char* kern=inpbuff;

	CALobject obj=NULL;
	CALresult err=(CALresult)0;
	err=calclCompile(&obj,CAL_LANGUAGE_IL,kern,CAL_TARGET_CAYMAN);
	cout << "Err: " << err << ", " << calclGetErrorString() << endl;

	CALimage img=NULL;
	calclLink(&img,&obj,1);
	//	calclDisassembleImage(img,disp);

	CALuint sz=0;
	calclImageGetSize(&sz,img);
	unsigned char *buff = new unsigned char[sz]; 
	
	memset(buff,'w',sz);
	
	calclImageWrite((CALvoid*)buff,sz,img);

	//	cout << "size=" << sz << endl;

	fp=fopen(argv[2],"wb");
	fwrite((void*)buff,1,sz,fp);
	fclose(fp);

	fpgpu=fopen(argv[3],"w");
	calclDisassembleImage(img,dispfile);
	fclose(fpgpu);

	delete [] buff;

	return 0;
}
