/* Copyright (C) 2011 Steven Gratton */
%{

#include <stdio.h>
#include <stdlib.h>
#include "defs.h"

  FILE* alufp;
  FILE* cfp;
  FILE* texfp;
  unsigned char* alubp;
  unsigned  char* cbp;
  unsigned  char* texbp;
  void yyerror(char*);
  int yylex(void);
  extern FILE* yyin;

int igcount=0;
int thisslotcount=0;
int totalslotcount=0;

%}

%start aluclause

%union {
  reginfo r;
  int i;
  int i2[2];
  int4 i4;
  float f;
  float2 f2;
  a2opinfo a2op;
  a3opinfo a3op;
  float2 ff[2];
  int flags[5];
}

%token <i> REG POSTREGMOD ALU2OP ALU3OP IM PS LAST UEM UPPRED WM OMOD BS DESTREL CLAMP
%token <f> FLIT
%token VECMULADD VECMUL VECADD VECMOV VECZERO
%type <r> reg
%type <i4> optprm
%type <f2> fltflt
%type <f> flt
%type <ff> fltflts
%type <flags> flags
%type <i2> flag
%type <a2op> alu2operation
%type <a3op> alu3operation
%left '-' '|'
%nonassoc UMINUS

%%

aluclause: instgroup
| aluclause instgroup 
{
printf("nonempty clause\n");
//if(thisslotcount>4) {printf("ig too big -- oops!\n");exit(-1);} 
thisslotcount=0;
}
;

instgroup:  vecinstgroup  '\n'
{printf("in vecinstgroup\n");
thisslotcount+=4;totalslotcount+=4;}
| reginstgroup '\n'
{printf("in reginstgroup\n");}
| '\n'
{printf("Skipping a valid blank line.\n");}
;

vecinstgroup: VECMULADD REG REG optprm REG optprm REG optprm 
        {
printf("EMITTING vecmuladd\n");
 make_vecmuladdig($2,$3,$4,$5,$6,$7,$8);
}
| VECMUL REG REG optprm REG optprm 
{
printf("EMITTING vecmul\n");
 make_vecmulig($2,$3,$4,$5,$6);}
| VECADD REG REG optprm REG optprm 
{printf("EMITTING vecadd\n");
  make_vecaddig($2,$3,$4,$5,$6);}
| VECMOV REG REG optprm
{printf("EMITTING vecmov\n");
  make_vecmovig($2,$3,$4);}
| VECZERO REG 
{
printf("EMITTING veczero\n");
make_veczeroig($2);
}
;

optprm: {$$.i[0]=0;$$.i[1]=1;$$.i[2]=2;$$.i[3]=3;}
| POSTREGMOD {$$.i[0]=$1;$$.i[1]=$1;$$.i[2]=$1;$$.i[3]=$1;}
;

reginstgroup: slots fltflts
;

slots:  slot slot slot slot 
    {printf("found a quadruple slot\n");}
  | slot  slot  slot 
    {printf("found a triple slot\n");}
  | slot  slot 
    {printf("found a double slot\n");}
  | slot 
    {printf("found a single slot\n");}
  ;

slot :  alu3operation 
{
printf("EMITTING alu3op\n",$1);
//simple_make_alu_three_op($1.inst,$1.regno[0],$1.regno[1],$1.regno[2],$1.regno[3],0);
make_alu_three_op($1.inst,
	   $1.regno[1].reg,0,$1.regno[1].chan,$1.regno[1].neg,
	   $1.regno[2].reg,0,$1.regno[2].chan,$1.regno[2].neg,
	   $1.regno[3].reg,0,$1.regno[3].chan,$1.regno[3].neg,
	   $1.regno[0].reg,$1.flgs[8],$1.regno[0].chan,
	   $1.flgs[0],$1.flgs[1],$1.flgs[2],
	   $1.flgs[7],$1.flgs[9]);
}
| alu2operation 
{
printf("EMITTING alu2op\n");
//simple_make_alu_two_op($1.inst,$1.regno[0],$1.regno[1],$1.regno[2],0);}
 printf("XXX \t dstgpr=%d.\n",$1.regno[0].reg);
make_alu_two_op($1.inst,
   $1.regno[1].reg,0,$1.regno[1].chan,$1.regno[1].neg,$1.regno[1].abs,
   $1.regno[2].reg,0,$1.regno[2].chan,$1.regno[2].neg,$1.regno[2].abs,
   $1.regno[0].reg,$1.flgs[8],$1.regno[0].chan,1-$1.flgs[5],$1.flgs[6],
$1.flgs[0],$1.flgs[1],$1.flgs[2],
$1.flgs[3],$1.flgs[4],
$1.flgs[7],$1.flgs[9]);
}
;

alu3operation: ALU3OP reg reg reg reg flags '\n'
{
printf("found an alu3op, inst=\n",$1);
  $$.inst=(op3_inst_tag)$1;
  $$.regno[0].reg=$2.reg;
  $$.regno[0].chan=$2.chan;
  $$.regno[0].neg=$2.neg;
  $$.regno[1].reg=$3.reg;
  $$.regno[1].chan=$3.chan;
  $$.regno[1].neg=$3.neg;
  $$.regno[2].reg=$4.reg;
  $$.regno[2].chan=$4.chan;
  $$.regno[2].neg=$4.neg;
  $$.regno[3].reg=$5.reg;
  $$.regno[3].chan=$5.chan;
  $$.regno[3].neg=$5.neg;
  $$.flgs[0]=$6[0];
  $$.flgs[1]=$6[1];
  $$.flgs[2]=$6[2];
  $$.flgs[3]=$6[3];
  $$.flgs[4]=$6[4];
  $$.flgs[5]=$6[5];
  $$.flgs[6]=$6[6];
  $$.flgs[7]=$6[7];
  $$.flgs[8]=$6[8];
  $$.flgs[9]=$6[9];
}
;

alu2operation: ALU2OP reg reg reg flags '\n'
{
printf("found an alu2op, inst=%d\n",$1);
  $$.inst=(op2_inst_tag)$1;
  $$.regno[0].reg=$2.reg;
  $$.regno[0].chan=$2.chan;
  $$.regno[0].neg=$2.neg;
  $$.regno[1].reg=$3.reg;
  $$.regno[1].chan=$3.chan;
  $$.regno[1].neg=$3.neg;
  $$.regno[2].reg=$4.reg;
  $$.regno[2].chan=$4.chan;
  $$.regno[2].neg=$4.neg;
  $$.flgs[0]=$5[0];
  $$.flgs[1]=$5[1];
  $$.flgs[2]=$5[2];
  $$.flgs[3]=$5[3];
  $$.flgs[4]=$5[4];
  $$.flgs[5]=$5[5];
  $$.flgs[6]=$5[6];
  $$.flgs[7]=$5[7];
  $$.flgs[8]=$5[8];
  $$.flgs[9]=$5[9];
}
|ALU2OP reg reg flags '\n'
{
printf("found an alu2op, inst=%d\n",$1);
  $$.inst=(op2_inst_tag)$1;
  $$.regno[0].reg=$2.reg;
  $$.regno[0].chan=$2.chan;
  $$.regno[0].neg=$2.neg;
  $$.regno[1].reg=$3.reg;
  $$.regno[1].chan=$3.chan;
  $$.regno[1].neg=$3.neg;
  $$.regno[2].reg=ALU_SRC_0;
  $$.regno[2].chan=0;
  $$.regno[2].neg=0;
  $$.flgs[0]=$4[0];
  $$.flgs[1]=$4[1];
  $$.flgs[2]=$4[2];
  $$.flgs[3]=$4[3];
  $$.flgs[4]=$4[4];
  $$.flgs[5]=$4[5];
  $$.flgs[6]=$4[6];
  $$.flgs[7]=$4[7];
  $$.flgs[8]=$4[8];
  $$.flgs[9]=$4[9];
}
|ALU2OP reg flags '\n'
{
printf("found an alu2op, inst=%d\n",$1);
  $$.inst=(op2_inst_tag)$1;
  $$.regno[0].reg=$2.reg;
  $$.regno[0].chan=$2.chan;
  $$.regno[0].neg=$2.neg;
  $$.regno[1].reg=ALU_SRC_0;
  $$.regno[1].chan=0;
  $$.regno[1].neg=0;
  $$.regno[2].reg=ALU_SRC_0;
  $$.regno[2].chan=0;
  $$.regno[2].neg=0;
  $$.flgs[0]=$3[0];
  $$.flgs[1]=$3[1];
  $$.flgs[2]=$3[2];
  $$.flgs[3]=$3[3];
  $$.flgs[4]=$3[4];
  $$.flgs[5]=$3[5];
  $$.flgs[6]=$3[6];
  $$.flgs[7]=$3[7];
  $$.flgs[8]=$3[8];
  $$.flgs[9]=$3[9];
}
;

flags: 
{}
| flags flag
{
$$[0]=$1[0];
$$[1]=$1[1];
$$[2]=$1[2];
$$[3]=$1[3];
$$[4]=$1[4];
$$[5]=$1[5];
$$[6]=$1[6];
$$[7]=$1[7];
$$[8]=$1[8];
$$[9]=$1[9];
$$[$2[0]]=$2[1];
}
;

flag: 
 IM
{
	printf("Found an IM flag: %d \n",$1);
	$$[0]=0;
	$$[1]=$1;
}
| PS
{
	printf("Found a PS flag: %d \n",$1);
	$$[0]=1;
	$$[1]=$1;
}
| LAST
{
	printf("Found an L flag: %d \n",$1);
	$$[0]=2;
	$$[1]=$1;
}
| UEM
{
	printf("Found a UEM flag: %d \n",$1);
	$$[0]=3;
	$$[1]=$1;
}
|UPPRED
{
	printf("Found an UPPRED flag: %d \n",$1);
	$$[0]=4;
	$$[1]=$1;
}
| WM
{
	printf("Found a WM flag: %d \n",$1);
	$$[0]=5;
	$$[1]=$1;
}
| OMOD
{
	printf("Found an OMOD flag: %d \n",$1);
	$$[0]=6;
	$$[1]=$1;
}
| BS
{
	printf("Found a BS flag: %d \n",$1);
	$$[0]=7;
	$$[1]=$1;
}
| DESTREL
{
	printf("Found a UEM flag: %d \n",$1);
	$$[0]=8;
	$$[1]=$1;
}
| CLAMP
{
	printf("Found a CLAMP flag: %d \n",$1);
	$$[0]=9;
	$$[1]=$1;
}
;


fltflts	:  fltflt fltflt '\n'
	  	{
$$[0].a=$1.a;$$[0].b=$1.b;$$[1].a=$2.a;$$[1].b=$2.b;
printf("EMITTING fltflt fltflt\n");
make_alu_literal($1.a,$1.b); make_alu_literal($2.a,$2.b);
}
	| fltflt flt '\n' 
	  	{
printf("EMITTING fltflt flt\n");
$$[0].a=$1.a;$$[0].b=$1.b;$$[1].a=$2;$$[1].b=0.f;
make_alu_literal($1.a,$1.b); make_alu_literal($2,0.f);
} 
	| fltflt '\n'
	  	{
printf("EMITTING fltflt\n");
$$[0].a=$1.a;$$[0].b=$1.b;$$[1].a=0.f;$$[1].b=0.f;
make_alu_literal($1.a,$1.b);
}
	| flt '\n' 
	     	{
printf("EMITTING flt\n");
$$[0].a=$1;$$[0].b=0.f;$$[1].a=0.f;$$[1].b=0.f;
make_alu_literal($1,0.f);
}
	| 
		{
printf("NOT EMITTING any literal\n");
$$[0].a=0.f;$$[0].b=0.f;$$[1].a=0.f;$$[1].b=0.f;
}
	;    


fltflt	: FLIT FLIT 
	     {$$.a=$1;$$.b=$2;}
	;
	     
flt	:  FLIT  
      	   {$$=$1;} 
	;

reg	: '|' reg '|'
	  {
printf("abs:\n");
$$.reg=$2.reg;
$$.chan=$2.chan;
$$.neg=0;
$$.abs=1;
}
	| '-' reg  %prec UMINUS
{
printf("*-1:\n");
$$.reg=$2.reg;
$$.chan=$2.chan;
if($2.neg==0) $$.neg=1; else {if($2.neg==1) $$.neg=0;}}
;
	|  REG POSTREGMOD 
	      {
printf("found R.#\n");
		$$.reg=$1; $$.neg=0; 
  		switch($2) {
 		case(0): case(1): case(2): case(3): $$.chan=$2; break;
		 default:
   		 exit(-1);
		 }
 	}
  	| REG 
{printf("found R\n");
    	$$.reg=$1; printf("found a reg!\n");}
  	;

%%

void yyerror(char *s) {
printf("%s",s);
}

int main(int argc, char* argv[])
{
  yyin=fopen(argv[1],"r");
  alufp=fopen(argv[2],"wb");
yyparse();
 fclose(alufp);
 //printf("total slotcount=%d\n",totalslotcount);
//if(totalslotcount>128) {printf("total slotcount in clause too big -- oops!\n");exit(-1);}
return 0;
}
