/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "defs.h"
#include "y.tab.h"
%}

%%

INDEX_AR_X {
yylval.i=FLAG_INDEX_AR_X;
return IM;
}

INDEX_AR_LOOP {
yylval.i=FLAG_INDEX_LOOP;
return IM;
}

INDEX_GLOBAL {
yylval.i=FLAG_INDEX_GLOBAL;
return IM;
}

INDEX_GLOBAL_AR_X {
yylval.i=FLAG_INDEX_GLOBAL_AR_X;
return IM;
}

PRED_SEL_OFF {
yylval.i=FLAG_PRED_SEL_OFF;
return PS;
}

PRED_SEL_ZERO {
yylval.i=FLAG_PRED_SEL_ZERO;
return PS;
}

PRED_SEL_ONE {
yylval.i=FLAG_PRED_SEL_ONE;
return PS;
}



VEC_012 {
yylval.i=0;
return BS;
}

VEC_021 {
yylval.i=1;
return BS;
}

VEC_120 {
yylval.i=2;
return BS;
}

VEC_102 {
yylval.i=3;
return BS;
}

VEC_201 {
yylval.i=4;
return BS;
}

VEC_210 {
yylval.i=5;
return BS;
}


R[0-9]+ {
yylval.i=atoi(yytext+1);
printf("returning reg %d.\n",yylval.i);
return REG;
}


KC0.[0-9]+ {
yylval.i=atoi(yytext+4)+128;
assert(yylval.i<160);
return REG;
}

KC1.[0-9]+ {
yylval.i=atoi(yytext+4)+160;
assert(yylval.i<192);
return REG;
}

ALU_SRC_1_DBL_L {
yylval.i=244;
return REG;
}


ALU_SRC_1_DBL_M {
yylval.i=245;
return REG;
}


ALU_SRC_0_5_DBL_L {
yylval.i=246;
return REG;
}


ALU_SRC_0_5_DBL_M {
yylval.i=247;
return REG;
}


ALU_SRC_0 {
yylval.i=248;
return REG;
}


ALU_SRC_1 {
yylval.i=249;
return REG;
}


ALU_SRC_1_INT {
yylval.i=250;
return REG;
}


ALU_SRC_M_1_INT {
yylval.i=251;
return REG;
}


ALU_SRC_0_5 {
yylval.i=252;
return REG;
}


ALU_SRC_LITERAL {
yylval.i=253;
return REG;
}


ALU_SRC_PV {
yylval.i=254;
return REG;
}

PV {
yylval.i=254;
return REG;
}

[.][xXyYzZwW] {
switch(yytext[1]){
case('x'):
case('X'):
yylval.i=0;
break;
case('y'):
case('Y'):
yylval.i=1;
break;
case('z'):
case('Z'):
yylval.i=2;
break;
case('w'):
case('W'):
yylval.i=3;
break;
default:
assert(1);
}
return POSTREGMOD;
}

"VECMULADD" return VECMULADD;
"VECMUL" return VECMUL;
"VECADD" return VECADD;
"VECMOV" return VECMOV;
"VECZERO" {printf("returning VECZERO\n");return VECZERO;}

BFE_UINT   	{yylval.i=OP3_INST_BFE_UINT ; return ALU3OP;}
BFE_INT   	{yylval.i=OP3_INST_BFE_INT ; return ALU3OP;}
BFI_INT   	{yylval.i=OP3_INST_BFI_INT ; return ALU3OP;}
FMA   	{yylval.i=OP3_INST_FMA ; return ALU3OP;}
MULADD_INT24   	{yylval.i=OP3_INST_MULADD_INT24 ; return ALU3OP;}
CNDNE_64   	{yylval.i=OP3_INST_CNDNE_64 ; return ALU3OP;}
FMA_64   	{yylval.i=OP3_INST_FMA_64 ; return ALU3OP;}
LERP_UINT   	{yylval.i=OP3_INST_LERP_UINT ; return ALU3OP;}
BIT_ALIGN_INT   	{yylval.i=OP3_INST_BIT_ALIGN_INT ; return ALU3OP;}
BYTE_ALIGN_INT   	{yylval.i=OP3_INST_BYTE_ALIGN_INT ; return ALU3OP;}
SAD_ACCUM_UINT   	{yylval.i=OP3_INST_SAD_ACCUM_UINT ; return ALU3OP;}
SAD_ACCUM_HI_UINT   	{yylval.i=OP3_INST_SAD_ACCUM_HI_UINT ; return ALU3OP;}
MULADD_UINT24   	{yylval.i=OP3_INST_MULADD_UINT24 ; return ALU3OP;}
LDS_IDX_OP   	{yylval.i=OP3_INST_LDS_IDX_OP ; return ALU3OP;}
MULADD   	{yylval.i=OP3_INST_MULADD ; return ALU3OP;}
MULADD_M2   	{yylval.i=OP3_INST_MULADD_M2 ; return ALU3OP;}
MULADD_M4   	{yylval.i=OP3_INST_MULADD_M4 ; return ALU3OP;}
MULADD_D2   	{yylval.i=OP3_INST_MULADD_D2 ; return ALU3OP;}
MULADD_IEEE   	{yylval.i=OP3_INST_MULADD_IEEE ; printf("emitting muladd_ieee\n"); return ALU3OP;}
CNDE   	{yylval.i=OP3_INST_CNDE ; return ALU3OP;}
CNDGT   	{yylval.i=OP3_INST_CNDGT ; return ALU3OP;}
CNDGE   	{yylval.i=OP3_INST_CNDGE ; return ALU3OP;}
CNDE_INT   	{yylval.i=OP3_INST_CNDE_INT ; return ALU3OP;}
CMNDGT_INT   	{yylval.i=OP3_INST_CMNDGT_INT ; return ALU3OP;}
CMNDGE_INT   	{yylval.i=OP3_INST_CMNDGE_INT ; return ALU3OP;}
INST_MUL_LIT {yylval.i=OP3_INST_MUL_LIT ; return ALU3OP;}
ADD   	{yylval.i=OP2_INST_ADD ; printf("emitting add as ALU2OP %d\n",yylval.i); return ALU2OP;}
MUL   	{yylval.i=OP2_INST_MUL ; return ALU2OP;}
MUL_IEEE   	{yylval.i=OP2_INST_MUL_IEEE ; return ALU2OP;}
MAX   	{yylval.i=OP2_INST_MAX ; return ALU2OP;}
MIN   	{yylval.i=OP2_INST_MIN ; return ALU2OP;}
MAX_DX10   	{yylval.i=OP2_INST_MAX_DX10 ; return ALU2OP;}
MIN_DX10   	{yylval.i=OP2_INST_MIN_DX10 ; return ALU2OP;}
SETE   	{yylval.i=OP2_INST_SETE ; return ALU2OP;}
SETGT   	{yylval.i=OP2_INST_SETGT ; return ALU2OP;}
SETGE   	{yylval.i=OP2_INST_SETGE ; return ALU2OP;}
SETNE   	{yylval.i=OP2_INST_SETNE ; return ALU2OP;}
SETE_DX10   	{yylval.i=OP2_INST_SETE_DX10 ; return ALU2OP;}
SETGT_DX10   	{yylval.i=OP2_INST_SETGT_DX10 ; return ALU2OP;}
SETGE_DX10   	{yylval.i=OP2_INST_SETGE_DX10 ; return ALU2OP;}
SETNE_DX10   	{yylval.i=OP2_INST_SETNE_DX10 ; return ALU2OP;}
FRACT   	{yylval.i=OP2_INST_FRACT ; return ALU2OP;}
TRUNC   	{yylval.i=OP2_INST_TRUNC ; return ALU2OP;}
CEIL   	{yylval.i=OP2_INST_CEIL ; return ALU2OP;}
RNDNE   	{yylval.i=OP2_INST_RNDNE ; return ALU2OP;}
FLOOR   	{yylval.i=OP2_INST_FLOOR ; return ALU2OP;}
ASHR_INT   	{yylval.i=OP2_INST_ASHR_INT ; return ALU2OP;}
LSHR_INT   	{yylval.i=OP2_INST_LSHR_INT ; return ALU2OP;}
LSHL_INT   	{yylval.i=OP2_INST_LSHL_INT ; return ALU2OP;}
MOV   	{yylval.i=OP2_INST_MOV ; return ALU2OP;}
NOP   	{yylval.i=OP2_INST_NOP ; return ALU2OP;}
PRED_SETGT_UINT   	{yylval.i=OP2_INST_PRED_SETGT_UINT ; return ALU2OP;}
PRED_SETGE_UINT   	{yylval.i=OP2_INST_PRED_SETGE_UINT ; return ALU2OP;}
PRED_SETE   	{yylval.i=OP2_INST_PRED_SETE ; return ALU2OP;}
PRED_SETGT   	{yylval.i=OP2_INST_PRED_SETGT ; return ALU2OP;}
PRED_SETGE   	{yylval.i=OP2_INST_PRED_SETGE ; return ALU2OP;}
PRED_SETNE   	{yylval.i=OP2_INST_PRED_SETNE ; return ALU2OP;}
PRED_SET_INV   	{yylval.i=OP2_INST_PRED_SET_INV ; return ALU2OP;}
PRED_SET_POP   	{yylval.i=OP2_INST_PRED_SET_POP ; return ALU2OP;}
PRED_SET_CLR   	{yylval.i=OP2_INST_PRED_SET_CLR ; return ALU2OP;}
PRED_SET_RESTORE   	{yylval.i=OP2_INST_PRED_SET_RESTORE ; return ALU2OP;}
PRED_SETE_PUSH   	{yylval.i=OP2_INST_PRED_SETE_PUSH ; return ALU2OP;}
PRED_SETGT_PUSH   	{yylval.i=OP2_INST_PRED_SETGT_PUSH ; return ALU2OP;}
PRED_SETGE_PUSH   	{yylval.i=OP2_INST_PRED_SETGE_PUSH ; return ALU2OP;}
PRED_SETNE_PUSH   	{yylval.i=OP2_INST_PRED_SETNE_PUSH ; return ALU2OP;}
KILLE   	{yylval.i=OP2_INST_KILLE ; return ALU2OP;}
KILLGT   	{yylval.i=OP2_INST_KILLGT ; return ALU2OP;}
KILLGE   	{yylval.i=OP2_INST_KILLGE ; return ALU2OP;}
KILLNE   	{yylval.i=OP2_INST_KILLNE ; return ALU2OP;}
AND_INT   	{yylval.i=OP2_INST_AND_INT ; return ALU2OP;}
OR_INT   	{yylval.i=OP2_INST_OR_INT ; return ALU2OP;}
XOR_INT   	{yylval.i=OP2_INST_XOR_INT ; return ALU2OP;}
NOT_INT   	{yylval.i=OP2_INST_NOT_INT ; return ALU2OP;}
ADD_INT   	{yylval.i=OP2_INST_ADD_INT ; printf("emitting addint...\n"); return ALU2OP;}
SUB_INT   	{yylval.i=OP2_INST_SUB_INT ; return ALU2OP;}
MAX_INT   	{yylval.i=OP2_INST_MAX_INT ; return ALU2OP;}
MIN_INT   	{yylval.i=OP2_INST_MIN_INT ; return ALU2OP;}
MAX_UINT   	{yylval.i=OP2_INST_MAX_UINT ; return ALU2OP;}
MIN_UINT   	{yylval.i=OP2_INST_MIN_UINT ; return ALU2OP;}
SETE_INT   	{yylval.i=OP2_INST_SETE_INT ; return ALU2OP;}
SETGT_INT   	{yylval.i=OP2_INST_SETGT_INT ; return ALU2OP;}
SETGE_INT   	{yylval.i=OP2_INST_SETGE_INT ; return ALU2OP;}
SETNE_INT   	{yylval.i=OP2_INST_SETNE_INT ; return ALU2OP;}
SETGT_UINT   	{yylval.i=OP2_INST_SETGT_UINT ; return ALU2OP;}
SETGE_UINT   	{yylval.i=OP2_INST_SETGE_UINT ; return ALU2OP;}
KILLGT_UINT   	{yylval.i=OP2_INST_KILLGT_UINT ; return ALU2OP;}
KILLGE_UINT   	{yylval.i=OP2_INST_KILLGE_UINT ; return ALU2OP;}
PRED_SETE_INT   	{yylval.i=OP2_INST_PRED_SETE_INT ; return ALU2OP;}
PRED_SETGT_INT   	{yylval.i=OP2_INST_PRED_SETGT_INT ; return ALU2OP;}
PRED_SETGE_INT   	{yylval.i=OP2_INST_PRED_SETGE_INT ; return ALU2OP;}
PRED_SETNE_INT   	{yylval.i=OP2_INST_PRED_SETNE_INT ; return ALU2OP;}
KILLE_INT   	{yylval.i=OP2_INST_KILLE_INT ; return ALU2OP;}
KILLGT_INT   	{yylval.i=OP2_INST_KILLGT_INT ; return ALU2OP;}
KILLGE_INT   	{yylval.i=OP2_INST_KILLGE_INT ; return ALU2OP;}
KILLNE_INT   	{yylval.i=OP2_INST_KILLNE_INT ; return ALU2OP;}
PRED_SETE_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETE_PUSH_INT ; return ALU2OP;}
PRED_SETGT_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETGT_PUSH_INT ; return ALU2OP;}
PRED_SETGE_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETGE_PUSH_INT ; return ALU2OP;}
PRED_SETNE_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETNE_PUSH_INT ; return ALU2OP;}
PRED_SETLT_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETLT_PUSH_INT ; return ALU2OP;}
PRED_SETLE_PUSH_INT   	{yylval.i=OP2_INST_PRED_SETLE_PUSH_INT ; return ALU2OP;}
FLT_TO_INT   	{yylval.i=OP2_INST_FLT_TO_INT ; return ALU2OP;}
BFREV_INT   	{yylval.i=OP2_INST_BFREV_INT ; return ALU2OP;}
ADDC_UINT   	{yylval.i=OP2_INST_ADDC_UINT ; return ALU2OP;}
SUBB_UINT   	{yylval.i=OP2_INST_SUBB_UINT ; return ALU2OP;}
GROUP_BARRIER   	{yylval.i=OP2_INST_GROUP_BARRIER ; return ALU2OP;}
SET_MODE   	{yylval.i=OP2_INST_SET_MODE ; return ALU2OP;}
SET_LDS_SIZE   	{yylval.i=OP2_INST_SET_LDS_SIZE ; return ALU2OP;}
MUL_INT24   	{yylval.i=OP2_INST_MUL_INT24 ; return ALU2OP;}
MULHI_INT24   	{yylval.i=OP2_INST_MULHI_INT24 ; return ALU2OP;}
EXP_IEEE   	{yylval.i=OP2_INST_EXP_IEEE ; return ALU2OP;}
LOG_CLAMPED   	{yylval.i=OP2_INST_LOG_CLAMPED ; return ALU2OP;}
LOG_IEEE   	{yylval.i=OP2_INST_LOG_IEEE ; return ALU2OP;}
RECIP_CLAMPED   	{yylval.i=OP2_INST_RECIP_CLAMPED ; return ALU2OP;}
RECIP_FF   	{yylval.i=OP2_INST_RECIP_FF ; return ALU2OP;}
RECIP_IEEE   	{yylval.i=OP2_INST_RECIP_IEEE ; return ALU2OP;}
RECIPSQRT_CLAMPED   	{yylval.i=OP2_INST_RECIPSQRT_CLAMPED ; return ALU2OP;}
RECIPSQRT_FF   	{yylval.i=OP2_INST_RECIPSQRT_FF ; return ALU2OP;}
RECIPSQRT_IEEE   	{yylval.i=OP2_INST_RECIPSQRT_IEEE ; return ALU2OP;}
SQRT_IEEE   	{yylval.i=OP2_INST_SQRT_IEEE ; return ALU2OP;}
SIN   	{yylval.i=OP2_INST_SIN ; return ALU2OP;}
COS   	{yylval.i=OP2_INST_COS ; return ALU2OP;}
MULLO_INT   	{yylval.i=OP2_INST_MULLO_INT ; return ALU2OP;}
MULHI_INT   	{yylval.i=OP2_INST_MULHI_INT ; return ALU2OP;}
MULLO_UINT   	{yylval.i=OP2_INST_MULLO_UINT ; return ALU2OP;}
MULHI_UINT   	{yylval.i=OP2_INST_MULHI_UINT ; return ALU2OP;}
RECIP_64   	{yylval.i=OP2_INST_RECIP_64 ; return ALU2OP;}
RECIP_CLAMPED_64   	{yylval.i=OP2_INST_RECIP_CLAMPED_64 ; return ALU2OP;}
RECIPSQRT_64   	{yylval.i=OP2_INST_RECIPSQRT_64 ; return ALU2OP;}
RECIPSQRT_CLAMPED_64   	{yylval.i=OP2_INST_RECIPSQRT_CLAMPED_64 ; return ALU2OP;}
SQRT_64   	{yylval.i=OP2_INST_SQRT_64 ; return ALU2OP;}
FLT_TO_UINT   	{yylval.i=OP2_INST_FLT_TO_UINT ; return ALU2OP;}
INT_TO_FLT   	{yylval.i=OP2_INST_INT_TO_FLT ; return ALU2OP;}
UINT_TO_FLT   	{yylval.i=OP2_INST_UINT_TO_FLT ; return ALU2OP;}
BFM_INT   	{yylval.i=OP2_INST_BFM_INT ; return ALU2OP;}
FLT32_TO_FLT16_RTZ   	{yylval.i=OP2_INST_FLT32_TO_FLT16_RTZ ; return ALU2OP;}
FLT32_TO_FLT16   	{yylval.i=OP2_INST_FLT32_TO_FLT16 ; return ALU2OP;}
FLT16_TO_FLT32   	{yylval.i=OP2_INST_FLT16_TO_FLT32 ; return ALU2OP;}
UBYTE0_FLT   	{yylval.i=OP2_INST_UBYTE0_FLT ; return ALU2OP;}
UBYTE1_FLT   	{yylval.i=OP2_INST_UBYTE1_FLT ; return ALU2OP;}
UBYTE2_FLT   	{yylval.i=OP2_INST_UBYTE2_FLT ; return ALU2OP;}
UBYTE3_FLT   	{yylval.i=OP2_INST_UBYTE3_FLT ; return ALU2OP;}
BCNT_INT   	{yylval.i=OP2_INST_BCNT_INT ; return ALU2OP;}
FFBH_UINT   	{yylval.i=OP2_INST_FFBH_UINT ; return ALU2OP;}
FFBL_INT   	{yylval.i=OP2_INST_FFBL_INT ; return ALU2OP;}
FFBH_INT   	{yylval.i=OP2_INST_FFBH_INT ; return ALU2OP;}
FLT_TO_UINT4   	{yylval.i=OP2_INST_FLT_TO_UINT4 ; return ALU2OP;}
DOT_IEEE   	{yylval.i=OP2_INST_DOT_IEEE ; return ALU2OP;}
FLT_TO_INT_RPI   	{yylval.i=OP2_INST_FLT_TO_INT_RPI ; return ALU2OP;}
FLT_TO_INT_FLOOR   	{yylval.i=OP2_INST_FLT_TO_INT_FLOOR ; return ALU2OP;}
MULHI_UINT24   	{yylval.i=OP2_INST_MULHI_UINT24 ; return ALU2OP;}
MBCNT_32HI_INT   	{yylval.i=OP2_INST_MBCNT_32HI_INT ; return ALU2OP;}
OFFSET_TO_FLT   	{yylval.i=OP2_INST_OFFSET_TO_FLT ; return ALU2OP;}
MUL_UINT24   	{yylval.i=OP2_INST_MUL_UINT24 ; return ALU2OP;}
BCNT_ACCUM_PREV_INT   	{yylval.i=OP2_INST_BCNT_ACCUM_PREV_INT ; return ALU2OP;}
MBCNT_32LO_ACCUM_PREV_INT   	{yylval.i=OP2_INST_MBCNT_32LO_ACCUM_PREV_INT ; return ALU2OP;}
SETE_64   	{yylval.i=OP2_INST_SETE_64 ; return ALU2OP;}
SETNE_64   	{yylval.i=OP2_INST_SETNE_64 ; return ALU2OP;}
SETGT_64   	{yylval.i=OP2_INST_SETGT_64 ; return ALU2OP;}
SETGE_64   	{yylval.i=OP2_INST_SETGE_64 ; return ALU2OP;}
MIN_64   	{yylval.i=OP2_INST_MIN_64 ; return ALU2OP;}
MAX_64   	{yylval.i=OP2_INST_MAX_64 ; return ALU2OP;}
DOT4   	{yylval.i=OP2_INST_DOT4 ; return ALU2OP;}
DOT4_IEEE   	{yylval.i=OP2_INST_DOT4_IEEE ; return ALU2OP;}
CUBE   	{yylval.i=OP2_INST_CUBE ; return ALU2OP;}
MAX4   	{yylval.i=OP2_INST_MAX4 ; return ALU2OP;}
FREXP_64   	{yylval.i=OP2_INST_FREXP_64 ; return ALU2OP;}
LDEXP_64   	{yylval.i=OP2_INST_LDEXP_64 ; return ALU2OP;}
FRACT_64   	{yylval.i=OP2_INST_FRACT_64 ; return ALU2OP;}
PRED_SETGT_64   	{yylval.i=OP2_INST_PRED_SETGT_64 ; return ALU2OP;}
PRED_SETE_64   	{yylval.i=OP2_INST_PRED_SETE_64 ; return ALU2OP;}
PRED_SETGE_64   	{yylval.i=OP2_INST_PRED_SETGE_64 ; return ALU2OP;}
MUL_64   	{yylval.i=OP2_INST_MUL_64 ; return ALU2OP;}
ADD_64   	{yylval.i=OP2_INST_ADD_64 ; return ALU2OP;}
FLT64_TO_FLT32   	{yylval.i=OP2_INST_FLT64_TO_FLT32 ; return ALU2OP;}
FLT32_TO_FLT64   	{yylval.i=OP2_INST_FLT32_TO_FLT64 ; return ALU2OP;}
SAD_ACCUM_PREV_UINT   	{yylval.i=OP2_INST_SAD_ACCUM_PREV_UINT ; return ALU2OP;}
DOT   	{yylval.i=OP2_INST_DOT ; return ALU2OP;}
MUL_PREV   	{yylval.i=OP2_INST_MUL_PREV ; return ALU2OP;}
MUL_IEEE_PREV   	{yylval.i=OP2_INST_MUL_IEEE_PREV ; return ALU2OP;}
ADD_PREV   	{yylval.i=OP2_INST_ADD_PREV ; return ALU2OP;}
MULADD_PREV   	{yylval.i=OP2_INST_MULADD_PREV ; return ALU2OP;}
MULADD_IEEE_PREV   	{yylval.i=OP2_INST_MULADD_IEEE_PREV ; return ALU2OP;}
INTERP_XY   	{yylval.i=OP2_INST_INTERP_XY ; return ALU2OP;}
INTERP_ZW   	{yylval.i=OP2_INST_INTERP_ZW ; return ALU2OP;}
INTERP_X   	{yylval.i=OP2_INST_INTERP_X ; return ALU2OP;}
INTERP_Z   	{yylval.i=OP2_INST_INTERP_Z ; return ALU2OP;}
STORE_FLAGS   	{yylval.i=OP2_INST_STORE_FLAGS ; return ALU2OP;}
LOAD_STORE_FLAGS   	{yylval.i=OP2_INST_LOAD_STORE_FLAGS ; return ALU2OP;}
INTERP_LOAD_P0   	{yylval.i=OP2_INST_INTERP_LOAD_P0 ; return ALU2OP;}
INTERP_LOAD_P10   	{yylval.i=OP2_INST_INTERP_LOAD_P10 ; return ALU2OP;}
INTERP_LOAD_P20   	{yylval.i=OP2_INST_INTERP_LOAD_P20 ; return ALU2OP;}


[-]?[0-9]+([.][0-9]+)?([dDeE][-]?[0-9]+)?[f] {yylval.f=atof(yytext);return FLIT;}

NOWRITE {
yylval.i=FLAG_NOWRITE;
return WM;
}

UP {
yylval.i=FLAG_UP;
return UPPRED;
}

M2 {
yylval.i=FLAG_OMOD_M2;
return OMOD;
}

M4 {
yylval.i=FLAG_OMOD_M4;
return OMOD;
}

D2 {
yylval.i=FLAG_OMOD_D2;
return OMOD;
}

DR {
yylval.i=1;
return DESTREL;
}

C {
yylval.i=1;
return CLAMP;
}


L {
yylval.i=FLAG_L;
return LAST;
}

U {
yylval.i=FLAG_UEM;
return UEM;
}


[-|\n] return *yytext;

[ \t]+ ;

%%

int yywrap(void){
return 1;
}

