/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdlib.h>
#include <stdio.h>
#include "ops.h"
#include "y.tab.h"
%}

%%

R[0-9]+ {
yylval.i=atoi(yytext+1);
return REG;
}

[.][xXyYzZwW_01][xXyYzZwW_01][xXyYzZwW_01][xXyYzZwW_01] {

switch(yytext[1]){
case('x'):
case('X'):
yylval.i4[0]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[0]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[0]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[0]=SEL_W;
break;
case('0'):
yylval.i4[0]=SEL_0;
break;
case('1'):
yylval.i4[0]=SEL_1;
break;
case('_'):
yylval.i4[0]=SEL_MASK;
break;
}

switch(yytext[2]){
case('x'):
case('X'):
yylval.i4[1]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[1]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[1]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[1]=SEL_W;
break;
case('0'):
yylval.i4[1]=SEL_0;
break;
case('1'):
yylval.i4[1]=SEL_1;
break;
case('_'):
yylval.i4[1]=SEL_MASK;
break;
}

switch(yytext[3]){
case('x'):
case('X'):
yylval.i4[2]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[2]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[2]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[2]=SEL_W;
break;
case('0'):
yylval.i4[2]=SEL_0;
break;
case('1'):
yylval.i4[2]=SEL_1;
break;
case('_'):
yylval.i4[2]=SEL_MASK;
break;
}

switch(yytext[4]){
case('x'):
case('X'):
yylval.i4[3]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[3]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[3]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[3]=SEL_W;
break;
case('0'):
yylval.i4[3]=SEL_0;
break;
case('1'):
yylval.i4[3]=SEL_1;
break;
case('_'):
yylval.i4[3]=SEL_MASK;
break;
}

return SEL;
}

.[xXyYzZwW] {
switch(yytext[1]){
case('x'):
case('X'):
yylval.i=0;
break;
case('y'):
case('Y'):
yylval.i=1;
break;
case('z'):
case('Z'):
yylval.i=2;
break;
case('w'):
case('W'):
yylval.i=3;
break;
}
return POSTREGMOD;
}

T[0-9]+ {
yylval.i=atoi(yytext+1);
return TARG;
}

S[0-9]+ {
yylval.i=atoi(yytext+1);
return SAMP;
}

f[0-9]+ {
yylval.i=atoi(yytext+1);
return BUFID;
}


FETCH   	{yylval.i=VC_INST_FETCH ; return VCOP;}
SEMANTIC   	{yylval.i=VC_INST_SEMANTIC ; return VCOP;}
GET_BUFFER_RESINFO   	{yylval.i=VC_INST_GET_BUFFER_RESINFO ; return VCOP;}

LD   	{yylval.i=TEX_INST_LD ; return TEXOP;}
GET_TEXTURE_RESINFO   	{yylval.i=TEX_INST_GET_TEXTURE_RESINFO ; return TEXOP;}
GET_NUMBER_OF_SAMPLES   	{yylval.i=TEX_INST_GET_NUMBER_OF_SAMPLES ; return TEXOP;}
GET_COMP_TEX_LOD   	{yylval.i=TEX_INST_GET_COMP_TEX_LOD ; return TEXOP;}
GET_GRADIENTS_H   	{yylval.i=TEX_INST_GET_GRADIENTS_H ; return TEXOP;}
GET_GRADIENTS_V   	{yylval.i=TEX_INST_GET_GRADIENTS_V ; return TEXOP;}
SET_TEXTURE_OFFSETS   	{yylval.i=TEX_INST_SET_TEXTURE_OFFSETS ; return TEXOP;}
KEEP_GRADIENTS   	{yylval.i=TEX_INST_KEEP_GRADIENTS ; return TEXOP;}
SET_GRADIENTS_H   	{yylval.i=TEX_INST_SET_GRADIENTS_H ; return TEXOP;}
SET_GRADIENTS_V   	{yylval.i=TEX_INST_SET_GRADIENTS_V ; return TEXOP;}
SAMPLE   	{yylval.i=TEX_INST_SAMPLE ; return TEXOP;}
SAMPLE_L   	{yylval.i=TEX_INST_SAMPLE_L ; return TEXOP;}
SAMPLE_LB   	{yylval.i=TEX_INST_SAMPLE_LB ; return TEXOP;}
SAMPLE_LZ   	{yylval.i=TEX_INST_SAMPLE_LZ ; return TEXOP;}
SAMPLE_G   	{yylval.i=TEX_INST_SAMPLE_G ; return TEXOP;}
GATHER4   	{yylval.i=TEX_INST_GATHER4 ; return TEXOP;}
SAMPLE_G_LB   	{yylval.i=TEX_INST_SAMPLE_G_LB ; return TEXOP;}
GATHER4_O   	{yylval.i=TEX_INST_GATHER4_O ; return TEXOP;}
SAMPLE_C   	{yylval.i=TEX_INST_SAMPLE_C ; return TEXOP;}
SAMPLE_C_L   	{yylval.i=TEX_INST_SAMPLE_C_L ; return TEXOP;}
SAMPLE_C_LB   	{yylval.i=TEX_INST_SAMPLE_C_LB ; return TEXOP;}
SAMPLE_C_LZ   	{yylval.i=TEX_INST_SAMPLE_C_LZ ; return TEXOP;}
SAMPLE_C_G   	{yylval.i=TEX_INST_SAMPLE_C_G ; return TEXOP;}
GATHER4_C   	{yylval.i=TEX_INST_GATHER4_C ; return TEXOP;}
SAMPLE_C_G_LB   	{yylval.i=TEX_INST_SAMPLE_C_G_LB ; return TEXOP;}
GATHER4_C_O   	{yylval.i=TEX_INST_GATHER4_C_O ; return TEXOP;}

MEM   	{yylval.i=MEM_INST_MEM ; return  MEMRDOP;}

BCNT:[0-9]+ {
yylval.i=atoi(yytext+5)-1;
return BURSTCOUNTFLAG;
}

"RD_SCRATCH" {yylval.i=MEM_RD_SCRATCH; return MEMOPFLAG;}
"RD_SCATTER" {yylval.i=MEM_RD_SCATTER; return MEMOPFLAG;}


"FMT_INVALID" {yylval.i=FMT_INVALID; return FMTFLAG;}
"FMT_16_16_16_16_FLOAT" {yylval.i=FMT_16_16_16_16_FLOAT; return FMTFLAG;}
"FMT_8" {yylval.i=FMT_8; return FMTFLAG;}
"FMT_RESERVED_33" {yylval.i=FMT_RESERVED_33; return FMTFLAG;}
"FMT_4_4" {yylval.i=FMT_4_4; return FMTFLAG;}
"FMT_32_32_32_32" {yylval.i=FMT_32_32_32_32; return FMTFLAG;}
"FMT_3_3_2" {yylval.i=FMT_3_3_2; return FMTFLAG;}
"FMT_32_32_32_32_FLOAT" {yylval.i=FMT_32_32_32_32_FLOAT; return FMTFLAG;}
"FMT_RESERVED_4" {yylval.i=FMT_RESERVED_4; return FMTFLAG;}
"FMT_RESERVED_36" {yylval.i=FMT_RESERVED_36; return FMTFLAG;}
"FMT_16" {yylval.i=FMT_16; return FMTFLAG;}
"FMT_1" {yylval.i=FMT_1; return FMTFLAG;}
"FMT_16_FLOAT" {yylval.i=FMT_16_FLOAT; return FMTFLAG;}
"FMT_1_REVERSED" {yylval.i=FMT_1_REVERSED; return FMTFLAG;}
"FMT_8_8" {yylval.i=FMT_8_8; return FMTFLAG;}
"FMT_GB_GR" {yylval.i=FMT_GB_GR; return FMTFLAG;}
"FMT_5_6_5" {yylval.i=FMT_5_6_5; return FMTFLAG;}
"FMT_BG_RG" {yylval.i=FMT_BG_RG; return FMTFLAG;}
"FMT_6_5_5" {yylval.i=FMT_6_5_5; return FMTFLAG;}
"FMT_32_AS_8" {yylval.i=FMT_32_AS_8; return FMTFLAG;}
"FMT_1_5_5_5" {yylval.i=FMT_1_5_5_5; return FMTFLAG;}
"FMT_32_AS_8_8" {yylval.i=FMT_32_AS_8_8; return FMTFLAG;}
"FMT_4_4_4_4" {yylval.i=FMT_4_4_4_4; return FMTFLAG;}
"FMT_5_9_9_9_SHAREDEXP" {yylval.i=FMT_5_9_9_9_SHAREDEXP; return FMTFLAG;}
"FMT_5_5_5_1" {yylval.i=FMT_5_5_5_1; return FMTFLAG;}
"FMT_8_8_8" {yylval.i=FMT_8_8_8; return FMTFLAG;}
"FMT_32" {yylval.i=FMT_32; return FMTFLAG;}
"FMT_16_16_16" {yylval.i=FMT_16_16_16; return FMTFLAG;}
"FMT_32_FLOAT" {yylval.i=FMT_32_FLOAT; return FMTFLAG;}
"FMT_16_16_16_FLOAT" {yylval.i=FMT_16_16_16_FLOAT; return FMTFLAG;}
"FMT_16_16" {yylval.i=FMT_16_16; return FMTFLAG;}
"FMT_32_32_32" {yylval.i=FMT_32_32_32; return FMTFLAG;}
"FMT_16_16_FLOAT" {yylval.i=FMT_16_16_FLOAT; return FMTFLAG;}
"FMT_32_32_32_FLOAT" {yylval.i=FMT_32_32_32_FLOAT; return FMTFLAG;}
"FMT_8_24" {yylval.i=FMT_8_24; return FMTFLAG;}
"FMT_BC1" {yylval.i=FMT_BC1; return FMTFLAG;}
"FMT_8_24_FLOAT" {yylval.i=FMT_8_24_FLOAT; return FMTFLAG;}
"FMT_BC2" {yylval.i=FMT_BC2; return FMTFLAG;}
"FMT_24_8" {yylval.i=FMT_24_8; return FMTFLAG;}
"FMT_BC3" {yylval.i=FMT_BC3; return FMTFLAG;}
"FMT_24_8_FLOAT" {yylval.i=FMT_24_8_FLOAT; return FMTFLAG;}
"FMT_BC4" {yylval.i=FMT_BC4; return FMTFLAG;}
"FMT_10_11_11" {yylval.i=FMT_10_11_11; return FMTFLAG;}
"FMT_BC5" {yylval.i=FMT_BC5; return FMTFLAG;}
"FMT_10_11_11_FLOAT" {yylval.i=FMT_10_11_11_FLOAT; return FMTFLAG;}
"FMT_APC0" {yylval.i=FMT_APC0; return FMTFLAG;}
"FMT_11_11_10" {yylval.i=FMT_11_11_10; return FMTFLAG;}
"FMT_APC1" {yylval.i=FMT_APC1; return FMTFLAG;}
"FMT_11_11_10_FLOAT" {yylval.i=FMT_11_11_10_FLOAT; return FMTFLAG;}
"FMT_APC2" {yylval.i=FMT_APC2; return FMTFLAG;}
"FMT_2_10_10_10" {yylval.i=FMT_2_10_10_10; return FMTFLAG;}
"FMT_APC3" {yylval.i=FMT_APC3; return FMTFLAG;}
"FMT_8_8_8_8" {yylval.i=FMT_8_8_8_8; return FMTFLAG;}
"FMT_APC4" {yylval.i=FMT_APC4; return FMTFLAG;}
"FMT_10_10_10_2" {yylval.i=FMT_10_10_10_2; return FMTFLAG;}
"FMT_APC5" {yylval.i=FMT_APC5; return FMTFLAG;}
"FMT_X24_8_32_FLOAT" {yylval.i=FMT_X24_8_32_FLOAT; return FMTFLAG;}
"FMT_APC6" {yylval.i=FMT_APC6; return FMTFLAG;}
"FMT_32_32" {yylval.i=FMT_32_32; return FMTFLAG;}
"FMT_APC7" {yylval.i=FMT_APC7; return FMTFLAG;}
"FMT_32_32_FLOAT" {yylval.i=FMT_32_32_FLOAT; return FMTFLAG;}
"FMT_CTX1" {yylval.i=FMT_CTX1; return FMTFLAG;}
"FMT_16_16_16_16" {yylval.i=FMT_16_16_16_16; return FMTFLAG;}
"FMT_RESERVED_63" {yylval.i=FMT_RESERVED_63; return FMTFLAG;}

[-]?[0-9]+([.][0-9]+)?([dDeE][-]?[0-9]+)?[f] {yylval.f=atof(yytext);return FLIT;}

[,\n] {return *yytext;}

[ \t]+ ;

%%

int yywrap(void){
return 1;
}

