/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdio.h>
#include <stdlib.h>
#include "ops.h"
#define MAXPROGLEN 1000

  FILE* alufp;
  FILE* cfp;
  FILE* texfp;
  unsigned char* alubp;
  unsigned  char* cbp;
  unsigned  char* texbp;

 void yyerror(char*);
  int yylex(void);
  extern FILE* yyin;

  int addr[MAXPROGLEN];
  int count[MAXPROGLEN];

  int cfc=0;
%}

%start cfprog

%union{
  int i;
  int i2[2];
  int i4[4];
  int i16[16];
 }


%token <i> CFINST CFALUINST RATINST MEMBUFINST SWIZINST 
%token <i> MARKFLAG ADDRFLAG CNTFLAG BURSTCOUNTFLAG COMPMASKFLAG  
%token <i> ARRAYSIZEFLAG ARRAYBASEFLAG ESFLAG JTSFLAG PCFLAG
%token <i> CFCONSTFLAG VPMFLAG BARRIERFLAG KB0FLAG KB1FLAG
%token <i> KCADDR0FLAG KCADDR1FLAG KM0FLAG KM1FLAG CONDFLAG 
%token <i> ACFLAG WQMFLAG RATIDFLAG RIMFLAG TYPEFLAG REG RWRELFLAG
%token <i4> SEL
%type <i> optionalreg
%type <i2> cfinstflag cfaluinstflag ratinstflag membufinstflag swizinstflag
%type <i4> selinfo
%type <i16>  cfinstflags cfaluinstflags ratinstflags membufinstflags swizinstflags
%%


cfprog: aninst 
| cfprog aninst
;


aninst: cfinst {cfc++; printf("in aninst\n");}
| cfaluinst {cfc++;}
| ratinst {cfc++;}
| membufinst {cfc++;}
| swizinst {cfc++;}
| '\n' {printf("blank line...\n");}
;

cfinst: CFINST cfinstflags '\n'
{
  printf("in cfinst, cfc=%d.\n",cfc);
make_cf_op(
(cf_inst_tag) $1,
addr[cfc],
 $2[1],
 $2[2],
 $2[3],
 $2[4],
count[cfc],
 $2[6],
 $2[7]
 );
}
;

cfinstflags: {
  $$[0]=-1;
  $$[1]=0;
  $$[2]=0;
  $$[3]=0;
  $$[4]=0;
  $$[5]=0;
  $$[6]=0;
  $$[7]=1;
  $$[8]=0;
  $$[9]=0;
  $$[10]=0;
  $$[11]=0;
  $$[12]=0;
  $$[13]=0;
  $$[14]=0;
  $$[15]=0;
}
| cfinstflags cfinstflag
{
  $$[0]=$1[0];
  $$[1]=$1[1];
  $$[2]=$1[2];
  $$[3]=$1[3];
  $$[4]=$1[4];
  $$[5]=$1[5];
  $$[6]=$1[6];
  $$[7]=$1[7];
  $$[8]=$1[8];
  $$[9]=$1[9];
  $$[10]=$1[10];
  $$[11]=$1[11];
  $$[12]=$1[12];
  $$[13]=$1[13];
  $$[14]=$1[14];
  $$[15]=$1[15];
  $$[$2[0]]=$2[1];
}
;

 cfinstflag: ADDRFLAG {$$[0]=0; $$[1]=$1;}
  | JTSFLAG {$$[0]=1; $$[1]=$1;}
  | PCFLAG {$$[0]=2; $$[1]=$1;}
| CFCONSTFLAG {$$[0]=3; $$[1]=$1;}
| CONDFLAG {$$[0]=4; $$[1]=$1;}
| CNTFLAG {$$[0]=5; $$[1]=$1;}
| VPMFLAG {$$[0]=6; $$[1]=$1;}
| BARRIERFLAG {$$[0]=7; $$[1]=$1;}
    ;
;

cfaluinst: CFALUINST cfaluinstflags '\n'
{
make_cf_alu_op(
(cf_alu_inst_tag) $1,
addr[cfc],
 $2[1],
 $2[2],
 $2[3],
 $2[4],
 $2[5],
 $2[6],
 count[cfc],
 $2[8],
 $2[9],
 $2[10]
 );
}
;

cfaluinstflags:{
  $$[0]=-1;
  $$[1]=0;
  $$[2]=0;
  $$[3]=0;
  $$[4]=0;
  $$[5]=0;
  $$[6]=0;
  $$[7]=-1;
  $$[8]=0;
  $$[9]=0;
  $$[10]=1;
  $$[11]=0;
  $$[12]=0;
  $$[13]=0;
  $$[14]=0;
  $$[15]=0;
}
|cfaluinstflags cfaluinstflag 
{
  $$[0]=$1[0];
  $$[1]=$1[1];
  $$[2]=$1[2];
  $$[3]=$1[3];
  $$[4]=$1[4];
  $$[5]=$1[5];
  $$[6]=$1[6];
  $$[7]=$1[7];
  $$[8]=$1[8];
  $$[9]=$1[9];
  $$[10]=$1[10];
  $$[11]=$1[11];
  $$[12]=$1[12];
  $$[13]=$1[13];
  $$[14]=$1[14];
  $$[15]=$1[15];
  $$[$2[0]]=$2[1];
}
;

cfaluinstflag: ADDRFLAG {$$[0]=0; $$[1]=$1;}
| KB0FLAG {$$[0]=1; $$[1]=$1;}
| KB1FLAG {$$[0]=2; $$[1]=$1;}
| KM0FLAG {$$[0]=3; $$[1]=$1;}
| KM1FLAG {$$[0]=4; $$[1]=$1;}
| KCADDR0FLAG {$$[0]=5; $$[1]=$1;}
| KCADDR1FLAG {$$[0]=6; $$[1]=$1;}
| CNTFLAG {$$[0]=7; $$[1]=$1;}
| ACFLAG {$$[0]=8; $$[1]=$1;}
| WQMFLAG {$$[0]=9; $$[1]=$1;}
| BARRIERFLAG {$$[0]=10; $$[1]=$1;}
;

ratinst: MEMBUFINST RATINST REG optionalreg ratinstflags '\n'
{

make_cf_export_rat_op(
(rat_inst_tag) $2,
(cf_inst_mem_buf_tag) $1,
$5[0],
$5[1],
$5[2],
$3,
$5[3],
$4,
$5[4],
$5[5],
$5[6],
$5[7],
$5[8],
$5[9],
$5[10]
);
}
;

ratinstflags:{
  $$[0]=0;
  $$[1]=0;
  $$[2]=0;
  $$[3]=0;
  $$[4]=0;
  $$[5]=0;
  $$[6]=0;
  $$[7]=0;
  $$[8]=0;
  $$[9]=0;
  $$[10]=1;
  $$[11]=0;
  $$[12]=0;
  $$[13]=0;
  $$[14]=0;
  $$[15]=0;
}
|ratinstflags ratinstflag
{
  $$[0]=$1[0];
  $$[1]=$1[1];
  $$[2]=$1[2];
  $$[3]=$1[3];
  $$[4]=$1[4];
  $$[5]=$1[5];
  $$[6]=$1[6];
  $$[7]=$1[7];
  $$[8]=$1[8];
  $$[9]=$1[9];
  $$[10]=$1[10];
  $$[11]=$1[11];
  $$[12]=$1[12];
  $$[13]=$1[13];
  $$[14]=$1[14];
  $$[15]=$1[15];
  $$[$2[0]]=$2[1];
}
;

ratinstflag: RATIDFLAG {$$[0]=0; $$[1]=$1;}
| RIMFLAG {$$[0]=1; $$[1]=$1;}
| TYPEFLAG {$$[0]=2; $$[1]=$1;}
  | RWRELFLAG {$$[0]=3; $$[1]=$1;}
|ESFLAG {$$[0]=4; $$[1]=$1;}
|ARRAYSIZEFLAG {$$[0]=5; $$[1]=$1;}
  | COMPMASKFLAG  {$$[0]=6; $$[1]=$1;}
  | BURSTCOUNTFLAG  {$$[0]=7; $$[1]=$1;}
  | VPMFLAG  {$$[0]=8; $$[1]=$1;}
|MARKFLAG  {$$[0]=9; $$[1]=$1;}
| BARRIERFLAG  {$$[0]=10; $$[1]=$1;}
;

membufinst: MEMBUFINST REG optionalreg membufinstflags '\n'
{
 make_cf_export_buf_op(
 (cf_inst_mem_buf_tag) $1,
 $4[0],
 $4[1],
 $2,
 $4[2],
 $3,
 $4[3],
 $4[4],
 $4[5],
 $4[6],
 $4[7],
 $4[8],
 $4[9]
 );
}
;

membufinstflags:{
  $$[0]=0;
  $$[1]=0;
  $$[2]=0;
  $$[3]=0;
  $$[4]=0;
  $$[5]=0;
  $$[6]=0;
  $$[7]=0;
  $$[8]=0;
  $$[9]=1;
  $$[10]=0;
  $$[11]=0;
  $$[12]=0;
  $$[13]=0;
  $$[14]=0;
  $$[15]=0;
}
|membufinstflags membufinstflag
{
  $$[0]=$1[0];
  $$[1]=$1[1];
  $$[2]=$1[2];
  $$[3]=$1[3];
  $$[4]=$1[4];
  $$[5]=$1[5];
  $$[6]=$1[6];
  $$[7]=$1[7];
  $$[8]=$1[8];
  $$[9]=$1[9];
  $$[10]=$1[10];
  $$[11]=$1[11];
  $$[12]=$1[12];
  $$[13]=$1[13];
  $$[14]=$1[14];
  $$[15]=$1[15];
  $$[$2[0]]=$2[1];
}
;

 membufinstflag: ARRAYBASEFLAG {$$[0]=0;$$[1]=$1;} 
|TYPEFLAG {$$[0]=1; $$[1]=$1;}
  | RWRELFLAG {$$[0]=2; $$[1]=$1;}
|ESFLAG {$$[0]=3; $$[1]=$1;}
|ARRAYSIZEFLAG {$$[0]=4; $$[1]=$1;}
  | COMPMASKFLAG  {$$[0]=5; $$[1]=$1;}
  | BURSTCOUNTFLAG  {$$[0]=6; $$[1]=$1;}
  | VPMFLAG  {$$[0]=7; $$[1]=$1;}
|MARKFLAG  {$$[0]=8; $$[1]=$1;}
| BARRIERFLAG  {$$[0]=9; $$[1]=$1;}
  ;

swizinst: SWIZINST REG selinfo optionalreg swizinstflags '\n'
{
  printf("bcnt=%d\n",$5[4]);
make_cf_export_swiz_op
(
 (cf_inst_swiz_tag) $1,
 $5[0],
 $5[1],
 $2,
 $5[2],
 $4,
 $5[3],
 $3[0],
 $3[1],
 $3[2],
 $3[3],
 $5[4],
 $5[5],
 $5[6],
 $5[7]
 );
}
;

optionalreg: {$$=0;}
| REG {$$=$1;}
;

swizinstflags:{
  $$[0]=0;
  $$[1]=0;
  $$[2]=0;
  $$[3]=0;
  $$[4]=0;
  $$[5]=0;
  $$[6]=0;
  $$[7]=1;
  $$[8]=0;
  $$[9]=0;
  $$[10]=0;
  $$[11]=0;
  $$[12]=0;
  $$[13]=0;
  $$[14]=0;
  $$[15]=0;
}
|swizinstflags swizinstflag
{
  $$[0]=$1[0];
  $$[1]=$1[1];
  $$[2]=$1[2];
  $$[3]=$1[3];
  $$[4]=$1[4];
  $$[5]=$1[5];
  $$[6]=$1[6];
  $$[7]=$1[7];
  $$[8]=$1[8];
  $$[9]=$1[9];
  $$[10]=$1[10];
  $$[11]=$1[11];
  $$[12]=$1[12];
  $$[13]=$1[13];
  $$[14]=$1[14];
  $$[15]=$1[15];
  $$[$2[0]]=$2[1];
}
;

 selinfo: {
$$[0]=0;
$$[1]=1;
$$[2]=2;
$$[3]=3;
}
  | SEL {
    $$[0]=$1[0];
    $$[1]=$1[1];
    $$[2]=$1[2];
    $$[3]=$1[3];
  }
  ;

swizinstflag:ARRAYBASEFLAG {$$[0]=0;$$[1]=$1;}
|TYPEFLAG {$$[0]=1; $$[1]=$1;}
  | RWRELFLAG {$$[0]=2; $$[1]=$1;}
|ESFLAG {$$[0]=3; $$[1]=$1;}
| BURSTCOUNTFLAG  {$$[0]=4; $$[1]=$1; printf("bcnt in flag=%d.\n",$1);}
  | VPMFLAG  {$$[0]=5; $$[1]=$1;}
|MARKFLAG  {$$[0]=6; $$[1]=$1;}
| BARRIERFLAG  {$$[0]=7; $$[1]=$1;}
  ;


%%

void yyerror(char *s) {
printf("yyerror: %s\n",s);
}

  int main(int argc, char* argv[]){
    int i,a,b,c;
    FILE* cfinfo;
    cfinfo=fopen(argv[3],"r");
    while(fscanf(cfinfo,"%d %d %d",&a,&b,&c)!=EOF) {
      printf("a,b,c: %d %d %d\n",a,b,c);
      if (c!=0)
	{addr[a]=b;count[a]=c-1;}
      else 
	{addr[a]=b;count[a]=c;}
    }
    fclose(cfinfo);
    for(i=0;i<=a;i++){
      printf("%d\t%d\t%d\n",i,addr[i],count[i]);
    }

    yyin=fopen(argv[1],"r");
    cfp=fopen(argv[2],"wb");
    yyparse();
    fclose(cfp);
    return 0;
  }
