// Copyright (C) 2011 Steven Gratton

#include <iostream>
#include <cstdio>

#include "calcl.h"
#include "cal.h"

#include <ctime>

void disp(const char* msg)
{
   printf("%s",msg);
}

FILE* fisa;
void filedisp(const char* msg)
{
        fprintf(fisa,"%s",msg);
}

int main(int argc, char* argv[])
{
  if (argc!=3){
    fprintf(stderr,"usage: imgdisasm file1.elf file2.txt\n");
    exit(-1);
  }

	calInit();
	CALdevice device=0;
   CALuint version[3];
   calclGetVersion(&version[0], &version[1], &version[2]);
   fprintf(stderr, "CAL Compiler version %d.%d.%d\n",
      version[0], version[1], version[2]);


   calDeviceOpen(&device,0);

   FILE* fp;
   fpos_t sz;
   fp=fopen(argv[1],"rb");
   fseek(fp,0l,SEEK_END);
   fgetpos(fp,&sz);
   rewind(fp);
   char* buff=(char*) malloc(sz);
   fread(buff,1,sz,fp);
   fclose(fp);

   CALimage img=NULL;

   printf("size=%d.\n",sz);

   calImageRead(&img,buff,sz);

   printf("Error string: %s\n",calGetErrorString());

   fisa=fopen(argv[2],"w");
   fprintf(fisa,"\n");
   calclDisassembleImage(img,filedisp);
   fclose(fisa);


   calShutdown();
return 0;
}
