/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdio.h>
#include <stdlib.h>
#include "ops.h"
  FILE* alufp;
  FILE* cfp;
  FILE* texfp;
  
  FILE* samplerinfofp;
  int sampinfo[160][18]={0,};

  unsigned char* alubp;
  unsigned  char* cbp;
  unsigned  char* texbp;

  void yyerror(char*);
  int yylex(void);
  extern FILE* yyin;

  int instcount=0;
%}

%start texclause

%union {
  int i;
  int i4[4];
  float f;
  float f3[3];
}

%token <i> TEXOP VCOP MEMRDOP REG POSTREGMOD TARG SAMP BUFID MEMOPFLAG
%token <i> BURSTCOUNTFLAG FMTFLAG
%token <f> FLIT
%token <i4> SEL
%type <i> optbcnt
%type <f3> optoffsets

%%

texclause:
| texclause inst
;

inst: texinst '\n'
| vcinst '\n'
| memrdinst '\n'
;

texinst: TEXOP REG SEL REG SEL TARG SAMP optoffsets
{
  make_tex_op((tex_inst_tag)$1,0,0,$6,$4,0,0,0,0,
	      $2,0,$3[0],$3[1],$3[2],$3[3],
	      0,0,0,0,0,
	      $8[0],$8[1],$8[2],
	      $7, $5[0], $5[1], $5[2], $5[3]);
  sampinfo[$6][$7]++;
  instcount++;
}
|TEXOP REG REG SEL TARG SAMP optoffsets
{
  make_tex_op((tex_inst_tag)$1,0,0,$5,$3,0,0,0,0,
	      $2,0,0,1,2,3,
	      0,0,0,0,0,
	      $7[0],$7[1],$7[2],
	      $6, $4[0], $4[1], $4[2], $4[3]);
  sampinfo[$5][$6]++;
  instcount++;
}
| TEXOP REG REG POSTREGMOD TARG SAMP optoffsets
{
  make_tex_op((tex_inst_tag)$1,0,0,$5,$3,0,0,0,0,
	      $2,0,0,1,2,3,
	      0,0,0,0,0,
	      $7[0],$7[1],$7[2],
	      $6, $4, $4, $4, $4);
  sampinfo[$5][$6]++;
  instcount++;
}
;

optoffsets: {$$[0]=0.f;$$[1]=0.f;$$[2]=0.f;}
| FLIT ',' FLIT ',' FLIT 
{$$[0]=$1; $$[1]=$3; $$[2]=$5;}
;

vcinst: VCOP REG REG BUFID 
{
  make_vtx_gpr_op((vc_inst_tag)$1,
		  0,1,$4,$3,0,0,0,0,0,0,
		  $2,0,0,1,2,3,1,0,0,0,0,
		  0,0,0,0,0);
instcount++;
}
;

memrdinst: MEMRDOP MEMOPFLAG REG REG optbcnt
{
  int tmpes;
  //  if($2==MEM_RD_SCRATCH) tmpes=3; else tmpes=0; 
  tmpes=3;
  make_mem_rd_op((mem_rd_inst_tag)$1,tmpes,0,(mem_rd_mem_op_tag)$2,
		 1,1,0,$4,0,0,$5,0,0,
		 $3,0,0,1,2,3,FMT_32_32_32_32_FLOAT,0,0,
		 0,0,0,0);
  instcount++;
}
;

optbcnt: {$$=0;}
| BURSTCOUNTFLAG {$$=$1;}
;

%%

void yyerror(char *s) {
printf("%s",s);
}

int main(int argc, char* argv[])
{
  yyin=fopen(argv[1],"r");
  texfp=fopen(argv[2],"wb");
  yyparse();
  fclose(texfp);
  printf("Instcount=%d.\n",instcount);

  samplerinfofp=fopen(argv[3],"w");
    for (int j=17;j>=0;j--){
      for (int i=0;i<160;i++){
	// the for loop follows what amd actually do...
	// (would seem more logical to just add one entry
	// per pair, i.e. drop the for loop for an if:)
	//	if (sampinfo[i][j]>0){
	  for (int k=0;k<sampinfo[i][j];k++){
	  fprintf(samplerinfofp,"%d\t%d\n", i,j);
	}
      }
    }
    fclose(samplerinfofp);

  return 0;
}

