/* Copyright (C) 2011 Steven Gratton */
#include "ops.h"

cf_op make_cf_op(cf_inst_tag inst,
				 int addr,
				 int jts,
				 int pc,
				 int cfconst,
				 int cond,
				 int count,
				 int vpm,
				 int barrier) {
	cf_op op;
	 op.addr = addr;
	 op.jumptable_sel = jts;
	 op.reserved0 = 0;
	 op.pop_count = pc;
	 op.cf_const = cfconst;
	 op.cond = cond;
	 op.count = count;
	 op.reserved1_1 = 0;
	 op.valid_pixel_mode = vpm;
	 op.reserved1_2 = 0;
	 op.cf_inst = inst;
	 op.reserved1_3 = 0; 
	 op.barrier =  barrier;
	if(cfp!=NULL) fwrite((void*)&op,8,1,cfp);
	if(cbp!=NULL) {memcpy((void*)cbp,(void*)&op,8);cbp+=8;}
	return op;
}

cf_alu_op make_cf_alu_op(cf_alu_inst_tag inst,
						 int addr,
						 int kb0,
						 int kb1,
						 int km0,
						 int km1,
						 int kcaddr0,
						 int kcaddr1,
						 int count,
						 int ac,
						 int wqm,
						 int barrier){
	cf_alu_op op;
	op.addr=addr;
	op.kcache_bank0=kb0;
	op.kcache_bank1=kb1;
	op.kcache_mode0=km0;
	op.kcache_mode1=km1;
	op.kcache_addr0=kcaddr0;
	op.kcache_addr1=kcaddr1;
	op.count=count;
	op.alt_const=ac;
	op.cf_inst=inst;
	op.whole_quad_mode=wqm;
	op.barrier=barrier;
	if(cfp!=NULL) fwrite((void*)&op,8,1,cfp);
	if(cbp!=NULL) {memcpy((void*)cbp,(void*)&op,8);cbp+=8;}
	return op;
}

cf_export_rat_op make_cf_export_rat_op(rat_inst_tag ratinst, cf_inst_mem_buf_tag inst,
									   int ratid,
									   int rim,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int es,
									   int arraysize,
									   int compmask,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier){
cf_export_rat_op op;
	op.rat_id=ratid;
	op.rat_inst=ratinst;
	op.reserved0=0;
	op.rat_index_mode=rim;
	op.type=type;
	op.rw_gpr=rwgpr;
	op.rw_rel=rwrel;
	op.index_gpr=indexgpr;
	op.elem_size=es;
	op.array_size=arraysize; 
	op.comp_mask=compmask;
	op.burst_count=burstcount;
	op.valid_pixel_mode=vpm;
	op.reserved1=0;
	op.cf_inst=inst;
	op.mark=mark;
	op.barrier=barrier;
	if(cfp!=NULL) fwrite((void*)&op,8,1,cfp);
	if(cbp!=NULL) {memcpy((void*)cbp,(void*)&op,8);cbp+=8;}
	return op;
}

cf_export_buf_op make_cf_export_buf_op(cf_inst_mem_buf_tag inst,
									   int arraybase,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int elemsize,
									   int arraysize,
									   int compmask,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier){
	cf_export_buf_op op;
	op.array_base=arraybase; 
	op.type=type;
	op.rw_gpr=rwgpr;
	op.rw_rel=rwrel;
	op.index_gpr=indexgpr;
	op.elem_size=elemsize;
	op.array_size=arraysize; 
	op.comp_mask=compmask;
	op.burst_count=burstcount;
	op.valid_pixel_mode=vpm;
	op.reserved1=0;
	op.cf_inst=inst;
	op.mark=mark;
	op.barrier=barrier;
    if(cfp!=NULL) fwrite((void*)&op,8,1,cfp);
	if(cbp!=NULL) {memcpy((void*)cbp,(void*)&op,8);cbp+=8;}
	return op;
}

cf_export_swiz_op make_cf_export_swiz_op(cf_inst_swiz_tag inst,
									   int arraybase,
									   int type,
									   int rwgpr,
									   int rwrel,
									   int indexgpr,
									   int elemsize,
									   int selx,
									   int sely,
									   int selz,
									   int selw,
									   int burstcount,
									   int vpm,
									   int mark,
									   int barrier){
	cf_export_swiz_op op;
	op.array_base=arraybase; 
	op.type=type;
	op.rw_gpr=rwgpr;
	op.rw_rel=rwrel;
	op.index_gpr=indexgpr;
	op.elem_size=elemsize;
	op.sel_x=selx;
	op.sel_y=sely;
	op.sel_z=selz;
	op.sel_w=selw;
	op.reserved1_1=0;
	op.burst_count=burstcount;
	op.valid_pixel_mode=vpm;
	op.reserved1_2=0;
	op.cf_inst=inst;
	op.mark=mark;
	op.barrier=barrier;
	if(cfp!=NULL) fwrite((void*)&op,8,1,cfp);
	if(cbp!=NULL) {memcpy((void*)cbp,(void*)&op,8);cbp+=8;}
	return op;
}

vtx_gpr_op make_vtx_gpr_op(vc_inst_tag inst,
						   int ft,
						   int fwq,
						   int buffid,
						   int srcgpr,
						   int srcrel,
						   int ssx,
						   int ssy,
						   int sr,
						   int lr,
						   int coalescedread,
						   int dstgpr,
						   int dstrel,
						   int dsx,
						   int dsy,
						   int dsz,
						   int dsw,
						   int ucf,
						   int dataformat,
						   int nfa,
						   int fca,
						   int sma,
						   int offset,
						   int es,
						   int cbns,
						   int ac,
						   int bim){
	vtx_gpr_op op;
	op.vc_inst=inst;
	op.fetch_type=ft;
	op.fetch_whole_quad=fwq;
	op.buffer_id=buffid;
	op.src_gpr=srcgpr;
	op.src_rel=srcrel;
	op.src_sel_x=ssx;
	op.src_sel_y=ssy;
	op.structured_read=sr;
	op.lds_req=lr;
	op.coalesced_read=coalescedread;
	op.dst_gpr=dstgpr; 
	op.dst_rel=dstrel;
	op.reserved1=0;
	op.dst_sel_x=dsx;
	op.dst_sel_y=dsy;
	op.dst_sel_z=dsz;
	op.dst_sel_w=dsw;
	op.use_const_fields=ucf;
	op.data_format=dataformat;
	op.num_format_all=nfa;
	op.format_comp_all=fca;
	op.srf_mode_all=sma;
	op.offset=offset;
	op.endian_swap=es;
	op.const_buf_no_stride=cbns;
	op.reserved2_1=0;
	op.alt_const=ac;
	op.buffer_index_mode=bim; 
	op.reserved2_2=0;
	op.pad=0xdeadfec;
	if(texfp!=NULL) fwrite((void*)&op,16,1,texfp);
	if(texbp!=NULL) {memcpy((void*)texbp,(void*)&op,16);texbp+=16;}
	return op;
}



// needs testing...
unsigned int flt2s31(float x){
	int y;
if (x>7.5f) x=7.5f;
if (x<-8.f) x=-8.f;
y=2.f*x;
return 0x1f & y;
}

tex_op make_tex_op(tex_inst_tag inst,
				   int instmod,
				   int fwq,
				   int resid,
				   int srcgpr,
				   int sr,
				   int ac,
				   int rim,
				   int sim,
				   int dstgpr,
				   int dr,
				   int dsx,
				   int dsy,
				   int dsz,
				   int dsw,
				   int lodbias,
				   int ctx,
				   int cty,
				   int ctz,
				   int ctw,
				   float offx,
				   float offy,
				   float offz,
				   int samplerid,
				   int ssx,
				   int ssy,
				   int ssz,
				   int ssw){
	tex_op op;
	op.tex_inst=inst;
	op.inst_mod=instmod;
	op.fetch_whole_quad=fwq;
	op.resource_id=resid;
	op.src_gpr=srcgpr;
	op.src_rel=sr;
	op.alt_const=ac;
	op.resource_index_mode=rim;
	op.sampler_index_mode=sim;
	op.reserved0=0;
	op.dst_gpr=dstgpr;
	op.dst_rel=dr;
	op.reserved1=0;
	op.dst_sel_x=dsx;
	op.dst_sel_y=dsy;
	op.dst_sel_z=dsz;
	op.dst_sel_w=dsw;
	op.lod_bias=lodbias;
	op.coord_type_x=ctx;
	op.coord_type_y=cty;
	op.coord_type_z=ctz;
	op.coord_type_w=ctw;
	op.offset_x=flt2s31(offx);
	op.offset_y=flt2s31(offy);
	op.offset_z=flt2s31(offz);
	op.sampler_id=samplerid;
	op.src_sel_x=ssx;
	op.src_sel_y=ssy;
	op.src_sel_z=ssz;
	op.src_sel_w=ssw;
	op.pad=0xdeadfec; 
	if(texfp!=NULL) fwrite((void*)&op,16,1,texfp);
	if(texbp!=NULL) {memcpy((void*)texbp,(void*)&op,16);texbp+=16;}
	return op;
}

tex_op simple_make_tex_op(tex_inst_tag inst,
				   int dstgpr,
				   int srcgpr,
				   int resid,
				   int samplerid) {
	tex_op op;
	op=make_tex_op(inst,
				    0,
				    0,
				    resid,
				    srcgpr,
				    0,
				    0,
				    0,
				    0,
				    dstgpr,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0,
				    0.f,
					0.f,
					0.f,
				    samplerid,
					0,
					0,
					0,
					0);
	return op;
}


mem_rd_op make_mem_rd_op(mem_rd_inst_tag inst,
						 int elemsize,
						 int fwq,
						 mem_rd_mem_op_tag memop,
						 int uncached,
						 int indexed,
						 int ssy,
						 int srcgpr,
						 int srcrel,
						 int ssx,
						 int burstcount,
						 int ldsreq,
						 int coalescedread,
						 int dstgpr,
						 int dstrel,
						 int dsx,
						 int dsy,
						 int dsz,
						 int dsw,
						 int dataformat,
						 int numformatall,
						 int formatcompall,
						 int srfmodeall,
						 int arraybase,
						 int endianswap,
						 int arraysize
						 ) {
	mem_rd_op op;
 	op.mem_inst=inst;
	op.elem_size=elemsize;
	op.fetch_whole_quad=fwq;
	op.mem_op=memop;
	op.uncached=uncached;
	op.indexed=indexed;
	op.src_sel_y=ssy;
	op.reserved0=0;
	op.src_gpr=srcgpr;
	op.src_rel=srcrel;
	op.src_sel_x=ssx;
	op.burst_cnt=burstcount;
	op.lds_req=ldsreq;
	op.coalesced_read=coalescedread;
	op.dst_gpr=dstgpr;
	op.dst_rel=dstrel;
	op.reserved1_1=0;
	op.dst_sel_x=dsx;
	op.dst_sel_y=dsy;
	op.dst_sel_z=dsz;
	op.dst_sel_w=dsw;
	op.reserved1_2=0;
	op.data_format=dataformat;
	op.num_format_all=numformatall;
	op.format_comp_all=formatcompall;
	op.srf_mode_all=srfmodeall;
	op.array_base=arraybase;
	op.reserved2_1=0;
	op.endian_swap=endianswap;
	// following amdil usage...
	op.reserved2_2=2;
	op.array_size=arraysize;
	op.pad=0xdeadfec;
	if(texfp!=NULL) fwrite((void*)&op,16,1,texfp);
	if(texbp!=NULL) {memcpy((void*)texbp,(void*)&op,16);texbp+=16;}
	return op;
}

alu_two_op make_alu_two_op(op2_inst_tag inst,
						   int s0sel, int s0r, int s0c, int s0n, int s0a,
						   int s1sel, int s1r, int s1c, int s1n, int s1a,
						   int dstgpr, int dr, int dc, int wm, int om,
						   int im,
						   int ps,
						   int l,
						   int uem,
						   int up,
						   int bs,
						   int c){
   alu_two_op op;
	op.src0_sel=s0sel;
	op.src0_rel=s0r;
	op.src0_chan=s0c;
	op.src0_neg=s0n;
	op.src1_sel=s1sel;
	op.src1_rel=s1r;
	op.src1_chan=s1c;
	op.src1_neg=s1n;
	op.index_mode=im;
	op.pred_sel=ps;
	op.last=l;
	op.src0_abs=s0a;
	op.src1_abs=s1a;
	op.update_exec_mask=uem;
	op.update_pred=up;
	op.write_mask=wm;
	op.omod=om;
	op.alu_inst=inst;
	op.bank_swizzle=bs;
	op.dst_gpr=dstgpr;
	op.dst_rel=dr;
	op.dst_chan=dc;
	op.clamp=c;
	if(alufp!=NULL) fwrite((void*)&op,8,1,alufp);
	if(alubp!=NULL) {memcpy((void*)alubp,(void*)&op,8);alubp+=8;}
	return op;
}

alu_three_op make_alu_three_op(op3_inst_tag inst,
						   int s0sel, int s0r, int s0c, int s0n,
						   int s1sel, int s1r, int s1c, int s1n,
						   int s2sel, int s2r, int s2c, int s2n,
						   int dstgpr, int dr, int dc,
						   int im,
						   int ps,
						   int l,
						   int bs,
						   int c){
	alu_three_op op;
	op.src0_sel=s0sel;
	op.src0_rel=s0r;
	op.src0_chan=s0c;
	op.src0_neg=s0n;
	op.src1_sel=s1sel;
	op.src1_rel=s1r;
	op.src1_chan=s1c;
	op.src1_neg=s1n;
	op.index_mode=im;
	op.pred_sel=ps;
	op.last=l;
	op.src2_sel=s2sel;
	op.src2_rel=s2r;
	op.src2_chan=s2c;
	op.src2_neg=s2n;
	op.alu_inst=inst;
	op.bank_swizzle=bs;
	op.dst_gpr=dstgpr;
	op.dst_rel=dr;
	op.dst_chan=dc;
	op.clamp=c;
	if(alufp!=NULL) fwrite((void*)&op,8,1,alufp);
	if(alubp!=NULL) {memcpy((void*)alubp,(void*)&op,8);alubp+=8;}
	return op;
}

alu_literal make_alu_literal(float a, float b){
	alu_literal z;
	z.a=a;
	z.b=b;
	if(alufp!=NULL) fwrite((void*)&z,4,2,alufp);
	if(alubp!=NULL) {memcpy((void*)alubp,(void*)&z,8);alubp+=8;}
	return z;
}


alu_two_op simple_make_alu_two_op(op2_inst_tag inst,
				  reginfo dst,
				  reginfo src0,
				  reginfo src1,
				  int last)
{
	alu_two_op op;
	op=make_alu_two_op(inst,
		src0.reg,0,src0.chan,src0.neg,src0.abs,
		src1.reg,0,src1.chan,src1.neg,src1.abs,
		dst.reg,0,dst.chan,
		0,0,0,0,last,0,0,0,0);
	return op;
}

alu_three_op simple_make_alu_three_op(op3_inst_tag inst,
				  reginfo dst,
				  reginfo src0,
				  reginfo src1,
				  reginfo src2,
				  int last)
{
	alu_three_op op;
	op=make_alu_three_op(
		inst,
		src0.reg,0,src0.chan,src0.neg,
		src1.reg,0,src1.chan,src1.neg,
		src2.reg,0,src2.chan,src2.neg,
		dst.reg,0,dst.chan,0,0,last,0,0
		);
	return op;
}


