/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdlib.h>
  #include <stdio.h>

#define MAXPROGLEN 1000

  int cfc=-1;
  int vcc,tcc;
  int nextv,nextt;
  int aluaddr[MAXPROGLEN]; int alucount[MAXPROGLEN];
  int texaddr[MAXPROGLEN]; int texcount[MAXPROGLEN];

  int labaddr[MAXPROGLEN];
  int wantedlab[MAXPROGLEN];

  int addr[MAXPROGLEN];
  int count[MAXPROGLEN];

  int labmax=0;

  void yyerror(char*);
  int yylex(void);
  extern FILE* yyin;
%}

%start prog

%union{
  int i;
  int i2[2];
  float f;
 }

%token <i> CFINST CFALUINST RATINST MEMBUFINST SWIZINST
%token <i> ALU2OP ALU3OP 
%token VECMULADD VECMUL VECADD VECMOV VECZERO
%token <i> LABFLAG ADDRLABFLAG
%token <f> FLIT 

%token <i> TEXOP VCOP MEMRDOP
%type <i> texop aluops floats ig normalig 
%type <i2> aluclause texclause 

%%

prog: segment
| prog segment
;

segment: aluclause 
{aluaddr[cfc]=nextv; alucount[cfc]=$1[1];nextv=nextv+$1[1]; vcc++;
  printf("done an alu clause.\n");}
|  texclause 
{texaddr[cfc]=nextt; texcount[cfc]=$1[1];nextt=nextt+$1[1]; tcc++;}
| cfinst {cfc++;
  printf("done a cfinst.\n");
}
| label
| '\n'
;

label: LABFLAG '\n' {labaddr[$1]=cfc+1; if($1>labmax) labmax=$1;}

cfinst: CFINST autolab '\n'
| CFALUINST autolab '\n'
| RATINST '\n'
| MEMBUFINST '\n'
| SWIZINST '\n'
;

autolab:
| ADDRLABFLAG {wantedlab[cfc+1]=$1;}
;

aluclause: ig {$$[0]=0; $$[1]+=$1;
printf("solitary ig in a clause\n");
}
|aluclause ig {$$[0]=0; $$[1]=$1[1]+$2;
printf("ig in a clause\n");
}
;

ig: vecop {$$=4;printf("ig=vecop\n");}
| normalig {$$=$1; printf("ig=nig\n");}
;

vecop: VECMULADD '\n' 
|VECMUL '\n'
|VECADD '\n'
|VECMOV '\n'
|VECZERO '\n'
;

normalig: aluops floats '\n' {$$=$1+$2; 
   printf("found a normalig\n");
}
;

aluops: aluop {$$=1;}
| aluops aluop {$$=$1+1;}
;

aluop: ALU2OP '\n' {printf("found alu2op\n");}
| ALU3OP '\n' {printf("found alu3op\n");}
;

floats: {$$=0;}
| FLIT '\n' {$$=1;}
| FLIT FLIT '\n' {$$=1;}
| FLIT FLIT FLIT '\n'  {$$=2;}
| FLIT FLIT FLIT FLIT '\n' {$$=2;}
;

texclause: texop {$$[0]=0; $$[1]+=2;}
| texclause texop {$$[1]=$1[1]+2;}
;

texop : TEXOP texflts '\n'
|VCOP '\n'
|MEMRDOP '\n'
;

texflts:
| FLIT FLIT FLIT
;

%%

void yyerror(char *s) {
printf("yyerror: %s\n",s);
}

  int main(int argc, char* argv[]){
    int i,alustart,texstart,alurecount,texrecount,cftot;
    FILE* cfproginfo;
    for(i=0;i<MAXPROGLEN;i++){
      wantedlab[i]=-1;
    }
    yyin=fopen(argv[1],"r");
    yyparse();
    fclose(yyin);
    printf("\n%d %d %d \n\n",cfc,vcc,tcc);
    for (i=0;i<=cfc;i++) printf("%d\t%d\t%d\t%d\t%d\t%d\n",i,
				aluaddr[i],alucount[i],texaddr[i],
				texcount[i],wantedlab[i]);
    printf("\nlabmax=%d.\n\n",labmax);
    for (i=0;i<=labmax;i++) printf("labaddr[%d]=%d.\n",i,labaddr[i]);

    cftot=cfc+1;

    alurecount=0;
    for (i=0;i<=cfc;i++) {
      alurecount+=alucount[i];
    }

    texrecount=0;
    for (i=0;i<=cfc;i++) {
      texrecount+=texcount[i];
    }

    printf("\n\n%d %d\n",alurecount,texrecount);

    alustart=32*((cftot+31)/32);

    // made this 256-byte aligned; doesn't have to be...
    texstart=32*((alustart+alurecount+31)/32);

    printf("\n\n%d %d\n",alustart,texstart);

    for (i=0;i<cftot;i++){
      // only expect one to be non-zero
      // and tex over 2 because count is num of instructions for tex
      count[i]=texcount[i]/2 + alucount[i];
      if(alucount[i]!=0) addr[i]=aluaddr[i]+alustart;
      if(texcount[i]!=0) addr[i]=texaddr[i]+texstart;
      if(wantedlab[i]!=-1) addr[i]=labaddr[wantedlab[i]];
    }
    
    cfproginfo=fopen(argv[2],"w");
    for(i=0;i<cftot;i++) fprintf(cfproginfo,"%d\t%d\t%d\n",i,addr[i],count[i]); 
    fclose(cfproginfo);
 
    cfproginfo=fopen(argv[3],"w");
    fprintf(cfproginfo,"%d\t%d\t%d\t%d\t%d\n",cftot,alurecount,texrecount,alustart,texstart);
    fclose(cfproginfo);
   return 0;

 }
