/* Copyright (C) 2011 Steven Gratton */
%{
#include <stdio.h>
#include <stdlib.h>
#include "y.tab.h"
#include "ops.h"

%}

%%

CF_NOP {yylval.i=CF_INST_NOP ; return  CFINST;}
TC {yylval.i=CF_INST_TC ; return  CFINST;}
GDS {yylval.i=CF_INST_GDS ; return  CFINST;}
LOOP_START {yylval.i=CF_INST_LOOP_START ; return  CFINST;}
LOOP_END {yylval.i=CF_INST_LOOP_END ; return  CFINST;}
LOOP_START_DX10 {yylval.i=CF_INST_LOOP_START_DX10 ; return  CFINST;}
LOOP_START_NO_AL {yylval.i=CF_INST_LOOP_START_NO_AL ; return  CFINST;}
LOOP_CONTINUE {yylval.i=CF_INST_LOOP_CONTINUE ; return  CFINST;}
LOOP_BREAK {yylval.i=CF_INST_LOOP_BREAK ; return  CFINST;}
JUMP {yylval.i=CF_INST_JUMP ; return  CFINST;}
PUSH {yylval.i=CF_INST_PUSH ; return  CFINST;}
ELSE {yylval.i=CF_INST_ELSE ; return  CFINST;}
POP {yylval.i=CF_INST_POP ; return  CFINST;}
CALL {yylval.i=CF_INST_CALL ; return  CFINST;}
CALL_FS {yylval.i=CF_INST_CALL_FS ; return  CFINST;}
RETURN {yylval.i=CF_INST_RETURN ; return  CFINST;}
EMIT_VERTEX {yylval.i=CF_INST_EMIT_VERTEX ; return  CFINST;}
EMIT_CUT_VERTEX {yylval.i=CF_INST_EMIT_CUT_VERTEX ; return  CFINST;}
CUT_VERTEX {yylval.i=CF_INST_CUT_VERTEX ; return  CFINST;}
KILL {yylval.i=CF_INST_KILL ; return  CFINST;}
WAIT_ACK {yylval.i=CF_INST_WAIT_ACK ; return  CFINST;}
TC_ACK {yylval.i=CF_INST_TC_ACK ; return  CFINST;}
JUMPTABLE {yylval.i=CF_INST_JUMPTABLE ; return  CFINST;}
GLOBAL_WAVE_SYNC {yylval.i=CF_INST_GLOBAL_WAVE_SYNC ; return  CFINST;}
HALT {yylval.i=CF_INST_HALT ; return  CFINST;}
END {yylval.i=CF_INST_END ; return  CFINST;}
LDS_DEALLOC {yylval.i=CF_INST_LDS_DEALLOC ; return  CFINST;}
PUSH_WQM {yylval.i=CF_INST_PUSH_WQM ; return  CFINST;}
POP_WQM {yylval.i=CF_INST_POP_WQM ; return  CFINST;}
ELSE_WQM {yylval.i=CF_INST_ELSE_WQM ; return  CFINST;}
JUMP_ANY {yylval.i=CF_INST_JUMP_ANY ; return  CFINST;}
REACTIVATE {yylval.i=CF_INST_REACTIVATE ; return  CFINST;}
REACTIVATE_WQM {yylval.i=CF_INST_REACTIVATE_WQM ; return  CFINST;}
INTERRUPT {yylval.i=CF_INST_INTERRUPT ; return  CFINST;}
INTERRUPT_AND_SLEEP {yylval.i=CF_INST_INTERRUPT_AND_SLEEP ; return  CFINST;}
SET_PRIORITY {yylval.i=CF_INST_SET_PRIORITY ; return  CFINST;}

ALU {yylval.i=CF_INST_ALU ; printf("Emitting inst_alu\n"); return  CFALUINST;}
ALU_PUSH_BEFORE {yylval.i=CF_INST_ALU_PUSH_BEFORE ; return  CFALUINST;}
ALU_POP_AFTER {yylval.i=CF_INST_ALU_POP_AFTER ; return  CFALUINST;}
ALU_POP2_AFTER {yylval.i=CF_INST_ALU_POP2_AFTER ; return  CFALUINST;}
ALU_EXTENDED {yylval.i=CF_INST_ALU_EXTENDED ; return  CFALUINST;}
ALU_REACTIVATE_BEFORE {yylval.i=CF_INST_ALU_REACTIVATE_BEFORE ; return  CFALUINST;}
ALU_VALID_PIXEL_MODE {yylval.i=CF_INST_ALU_VALID_PIXEL_MODE ; return  CFALUINST;}
ALU_ELSE_AFTER {yylval.i=CF_INST_ALU_ELSE_AFTER ; return  CFALUINST;}


RAT_NOP {yylval.i=EXPORT_RAT_INST_NOP ; return  RATINST;}
RAT_STORE_TYPED {yylval.i=EXPORT_RAT_INST_STORE_TYPED ; return  RATINST;}
RAT_CMPXCHG_INT {yylval.i=EXPORT_RAT_INST_CMPXCHG_INT ; return  RATINST;}
RAT_ADD {yylval.i=EXPORT_RAT_INST_ADD ; return  RATINST;}
RAT_SUB {yylval.i=EXPORT_RAT_INST_SUB ; return  RATINST;}
RAT_RSUB {yylval.i=EXPORT_RAT_INST_RSUB ; return  RATINST;}
RAT_MIN_INT {yylval.i=EXPORT_RAT_INST_MIN_INT ; return  RATINST;}
RAT_MIN_UINT {yylval.i=EXPORT_RAT_INST_MIN_UINT ; return  RATINST;}
RAT_MAX_INT {yylval.i=EXPORT_RAT_INST_MAX_INT ; return  RATINST;}
RAT_MAX_UINT {yylval.i=EXPORT_RAT_INST_MAX_UINT ; return  RATINST;}
RAT_AND {yylval.i=EXPORT_RAT_INST_AND ; return  RATINST;}
RAT_OR {yylval.i=EXPORT_RAT_INST_OR ; return  RATINST;}
RAT_XOR {yylval.i=EXPORT_RAT_INST_XOR ; return  RATINST;}
RAT_INC_UINT {yylval.i=EXPORT_RAT_INST_INC_UINT ; return  RATINST;}
RAT_DEC_UINT {yylval.i=EXPORT_RAT_INST_DEC_UINT ; return  RATINST;}
RAT_STORE_DWORD {yylval.i=EXPORT_RAT_INST_STORE_DWORD ; return  RATINST;}
RAT_STORE_SHORT {yylval.i=EXPORT_RAT_INST_STORE_SHORT ; return  RATINST;}
RAT_STORE_BYTE {yylval.i=EXPORT_RAT_INST_STORE_BYTE ; return  RATINST;}
RAT_NOP_RTN {yylval.i=EXPORT_RAT_INST_NOP_RTN ; return  RATINST;}
RAT_XCHG_RTN {yylval.i=EXPORT_RAT_INST_XCHG_RTN ; return  RATINST;}
RAT_CMPXCHG_INT_RTN {yylval.i=EXPORT_RAT_INST_CMPXCHG_INT_RTN ; return  RATINST;}
RAT_ADD_RTN {yylval.i=EXPORT_RAT_INST_ADD_RTN ; return  RATINST;}
RAT_SUB_RTN {yylval.i=EXPORT_RAT_INST_SUB_RTN ; return  RATINST;}
RAT_RSUB_RTN {yylval.i=EXPORT_RAT_INST_RSUB_RTN ; return  RATINST;}
RAT_MIN_INT_RTN {yylval.i=EXPORT_RAT_INST_MIN_INT_RTN ; return  RATINST;}
RAT_MIN_UINT_RTN {yylval.i=EXPORT_RAT_INST_MIN_UINT_RTN ; return  RATINST;}
RAT_MAX_INT_RTN {yylval.i=EXPORT_RAT_INST_MAX_INT_RTN ; return  RATINST;}
RAT_MAX_UINT_RTN {yylval.i=EXPORT_RAT_INST_MAX_UINT_RTN ; return  RATINST;}
RAT_AND_RTN {yylval.i=EXPORT_RAT_INST_AND_RTN ; return  RATINST;}
RAT_OR_RTN {yylval.i=EXPORT_RAT_INST_OR_RTN ; return  RATINST;}
RAT_XOR_RTN {yylval.i=EXPORT_RAT_INST_XOR_RTN ; return  RATINST;}
RAT_INC_UINT_RTN {yylval.i=EXPORT_RAT_INST_INC_UINT_RTN ; return  RATINST;}
RAT_DEC_UINT_RTN {yylval.i=EXPORT_RAT_INST_DEC_UINT_RTN ; return  RATINST;}

MEM_STREAM0_BUF0 {yylval.i=CF_INST_MEM_STREAM0_BUF0 ; return  MEMBUFINST;}
MEM_STREAM0_BUF1 {yylval.i=CF_INST_MEM_STREAM0_BUF1 ; return  MEMBUFINST;}
MEM_STREAM0_BUF2 {yylval.i=CF_INST_MEM_STREAM0_BUF2 ; return  MEMBUFINST;}
MEM_STREAM0_BUF3 {yylval.i=CF_INST_MEM_STREAM0_BUF3 ; return  MEMBUFINST;}
MEM_STREAM1_BUF0 {yylval.i=CF_INST_MEM_STREAM1_BUF0 ; return  MEMBUFINST;}
MEM_STREAM1_BUF1 {yylval.i=CF_INST_MEM_STREAM1_BUF1 ; return  MEMBUFINST;}
MEM_STREAM1_BUF2 {yylval.i=CF_INST_MEM_STREAM1_BUF2 ; return  MEMBUFINST;}
MEM_STREAM1_BUF3 {yylval.i=CF_INST_MEM_STREAM1_BUF3 ; return  MEMBUFINST;}
MEM_STREAM2_BUF0 {yylval.i=CF_INST_MEM_STREAM2_BUF0 ; return  MEMBUFINST;}
MEM_STREAM2_BUF1 {yylval.i=CF_INST_MEM_STREAM2_BUF1 ; return  MEMBUFINST;}
MEM_STREAM2_BUF2 {yylval.i=CF_INST_MEM_STREAM2_BUF2 ; return  MEMBUFINST;}
MEM_STREAM2_BUF3 {yylval.i=CF_INST_MEM_STREAM2_BUF3 ; return  MEMBUFINST;}
MEM_STREAM3_BUF0 {yylval.i=CF_INST_MEM_STREAM3_BUF0 ; return  MEMBUFINST;}
MEM_STREAM3_BUF1 {yylval.i=CF_INST_MEM_STREAM3_BUF1 ; return  MEMBUFINST;}
MEM_STREAM3_BUF2 {yylval.i=CF_INST_MEM_STREAM3_BUF2 ; return  MEMBUFINST;}
MEM_STREAM3_BUF3 {yylval.i=CF_INST_MEM_STREAM3_BUF3 ; return  MEMBUFINST;}
MEM_WR_SCRATCH {yylval.i=CF_INST_MEM_WR_SCRATCH ; return  MEMBUFINST;}
MEM_RING {yylval.i=CF_INST_MEM_RING ; return  MEMBUFINST;}
MEM_EXPORT {yylval.i=CF_INST_MEM_EXPORT ; return  MEMBUFINST;}
MEM_RAT {yylval.i=CF_INST_MEM_RAT ; return  MEMBUFINST;}
MEM_RAT_CACHELESS {yylval.i=CF_INST_MEM_RAT_CACHELESS ; return  MEMBUFINST;}
MEM_RING1 {yylval.i=CF_INST_MEM_RING1 ; return  MEMBUFINST;}
MEM_RING2 {yylval.i=CF_INST_MEM_RING2 ; return  MEMBUFINST;}
MEM_RING3 {yylval.i=CF_INST_MEM_RING3 ; return  MEMBUFINST;}
MEM_EXPORT_COMBINED {yylval.i=CF_INST_MEM_EXPORT_COMBINED ; return  MEMBUFINST;}
MEM_RAT_COMBINED_CACHELESS {yylval.i=CF_INST_MEM_RAT_COMBINED_CACHELESS ; return  MEMBUFINST;}

EXPORT {yylval.i=CF_INST_EXPORT ; return  SWIZINST;}
EXPORT_DONE {yylval.i=CF_INST_EXPORT_DONE ; return  SWIZINST;}

MARK {yylval.i=1; return MARKFLAG;}

ADDR:[0-9]+ {
yylval.i=atoi(yytext+5);
return ADDRFLAG;
}

LAB:[0-9]+ 

ADDRLAB:[0-9]+ 

CNT:[0-9]+ {
yylval.i=atoi(yytext+4)-1;
return CNTFLAG;
}

BCNT:[0-9]+ {
yylval.i=atoi(yytext+5)-1;
return BURSTCOUNTFLAG;
}

COMPMASK:[0-9A-F] {
sscanf(yytext+9,"%1x",&yylval.i);
return COMPMASKFLAG;
}

ARRSZ:[0-9]+ {yylval.i=atoi(yytext+6); return ARRAYSIZEFLAG;}
ARRBASE:[0-9]+ {yylval.i=atoi(yytext+8); return ARRAYBASEFLAG;}

ES1 {yylval.i=0; return ESFLAG;}
ES2 {yylval.i=1; return ESFLAG;}
ES4 {yylval.i=3; return ESFLAG;}


JTSA {yylval.i=0; return JTSFLAG;}
JTSB  {yylval.i=1; return JTSFLAG;}
JTSC  {yylval.i=2; return JTSFLAG;}
JTSD  {yylval.i=3; return JTSFLAG;}
JTS0  {yylval.i=4; return JTSFLAG;}
JTS1  {yylval.i=5; return JTSFLAG;}

RR_ABS {yylval.i=0; return RWRELFLAG;}
RR_REL {yylval.i=1; return RWRELFLAG;}

PC:[0-9] {yylval.i=atoi(yytext+3); return PCFLAG;}

ACTIVE {yylval.i=CF_COND_ACTIVE ; return  CONDFLAG;}
FALSE {yylval.i=CF_COND_FALSE ; return  CONDFLAG;}
BOOL {yylval.i=CF_COND_BOOL ; return  CONDFLAG;}
NOT_BOOL {yylval.i=CF_COND_NOT_BOOL ; return  CONDFLAG;}

CFCONST:[0-9]+ {yylval.i=atoi(yytext+8); return CFCONSTFLAG;}

VPM {yylval.i=1; return VPMFLAG;}

NB {
yylval.i=0;
return BARRIERFLAG;
}

B {
yylval.i=1;
return BARRIERFLAG;
}

KB0:[0-9]+ {yylval.i=atoi(yytext+4); return KB0FLAG;}
KB1:[0-9]+ {yylval.i=atoi(yytext+4); return KB1FLAG;}

KCADDR0:[0-9]+ {yylval.i=atoi(yytext+8); return KCADDR0FLAG;}
KCADDR1:[0-9]+ {yylval.i=atoi(yytext+8); return KCADDR1FLAG;}

KC0_NOP   	{yylval.i=CF_KCACHE_NOP ; return  KM0FLAG;}
KC0_LOCK_1   	{yylval.i=CF_KCACHE_LOCK_1 ; return  KM0FLAG;}
KC0_LOCK_2   	{yylval.i=CF_KCACHE_LOCK_2 ; return  KM0FLAG;}
KC0_LOCK_LOOP_INDEX   	{yylval.i=CF_KCACHE_LOCK_LOOP_INDEX ; return  KM0FLAG;}

KC1_NOP {yylval.i=CF_KCACHE_NOP ; return  KM1FLAG;}
KC1_LOCK_1 {yylval.i=CF_KCACHE_LOCK_1 ; return  KM1FLAG;}
KC1_LOCK_2 {yylval.i=CF_KCACHE_LOCK_2 ; return  KM1FLAG;}
KC1_LOCK_LOOP_INDEX {yylval.i=CF_KCACHE_LOCK_LOOP_INDEX ; return  KM1FLAG;}

AC {yylval.i=1; return ACFLAG;}
WQM {yylval.i=1; return WQMFLAG;}

UAV[0-9]+ {yylval.i=atoi(yytext+3); return RATIDFLAG;}

INDEX_NONE {yylval.i=CF_INDEX_NONE; return RIMFLAG;}
INDEX_0  {yylval.i=CF_INDEX_0; return RIMFLAG;}
INDEX_1  {yylval.i=CF_INDEX_1; return RIMFLAG;}
INVALID  {yylval.i=CF_INVALID; return RIMFLAG;}

PIXEL {yylval.i=EXPORT_PIXEL ; return  TYPEFLAG;}
WRITE {yylval.i=EXPORT_WRITE ; return  TYPEFLAG;}
POS {yylval.i=EXPORT_POS ; return  TYPEFLAG;}
WRITE_IND {yylval.i=EXPORT_WRITE_IND ; return  TYPEFLAG;}
PARAM {yylval.i=EXPORT_PARAM ; return  TYPEFLAG;}
WRITE_ACK {yylval.i=EXPORT_WRITE_ACK ; return  TYPEFLAG;}
WRITE_IND_ACK {yylval.i=EXPORT_WRITE_IND_ACK ; return  TYPEFLAG;}


R[0-9]+ {
yylval.i=atoi(yytext+1);
return REG;
}

PIX[0-9] {yylval.i=atoi(yytext+3); return ARRAYBASEFLAG;} 


[.][xXyYzZwW_01][xXyYzZwW_01][xXyYzZwW_01][xXyYzZwW_01] {

switch(yytext[1]){
case('x'):
case('X'):
yylval.i4[0]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[0]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[0]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[0]=SEL_W;
break;
case('0'):
yylval.i4[0]=SEL_0;
break;
case('1'):
yylval.i4[0]=SEL_1;
break;
case('_'):
yylval.i4[0]=SEL_MASK;
break;
}

switch(yytext[2]){
case('x'):
case('X'):
yylval.i4[1]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[1]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[1]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[1]=SEL_W;
break;
case('0'):
yylval.i4[1]=SEL_0;
break;
case('1'):
yylval.i4[1]=SEL_1;
break;
case('_'):
yylval.i4[1]=SEL_MASK;
break;
}

switch(yytext[3]){
case('x'):
case('X'):
yylval.i4[2]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[2]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[2]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[2]=SEL_W;
break;
case('0'):
yylval.i4[2]=SEL_0;
break;
case('1'):
yylval.i4[2]=SEL_1;
break;
case('_'):
yylval.i4[2]=SEL_MASK;
break;
}

switch(yytext[4]){
case('x'):
case('X'):
yylval.i4[3]=SEL_X;
break;
case('y'):
case('Y'):
yylval.i4[3]=SEL_Y;
break;
case('z'):
case('Z'):
yylval.i4[3]=SEL_Z;
break;
case('w'):
case('W'):
yylval.i4[3]=SEL_W;
break;
case('0'):
yylval.i4[3]=SEL_0;
break;
case('1'):
yylval.i4[3]=SEL_1;
break;
case('_'):
yylval.i4[3]=SEL_MASK;
break;
}

return SEL;
}

[\n] return *yytext;

[ \t]+ ;

. ;

%%

int yywrap(void){
return 1;
}
