/* Copyright (C) 2011 Steven Gratton */
#ifndef CAYMAN_H
#define CAYMAN_H

enum cond_flag {
	CF_COND_ACTIVE=0,
	CF_COND_FALSE=1,
	CF_COND_BOOL=2,
	CF_COND_NOT_BOOL=3,
};

enum kcache_mode_tag {
CF_KCACHE_NOP=0,
CF_KCACHE_LOCK_1=1,
CF_KCACHE_LOCK_2=2,
CF_KCACHE_LOCK_LOOP_INDEX=3,
};

enum im_tag {
FLAG_INDEX_AR_X=0,
FLAG_INDEX_LOOP=4, 
FLAG_INDEX_GLOBAL=5, 
FLAG_INDEX_GLOBAL_AR_X=6
};

enum rim_tag {
	CF_INDEX_NONE=0,
	CF_INDEX_0=1,
	CF_INDEX_1=2,
	CF_INVALID=3,
};

enum type_tag {
	EXPORT_PIXEL=0,
	EXPORT_WRITE=0,
	EXPORT_POS=1,
	EXPORT_WRITE_IND=1,
	EXPORT_PARAM=2,
	EXPORT_WRITE_ACK=2,
	EXPORT_WRITE_IND_ACK=3,
};


enum ps_tag {
FLAG_PRED_SEL_OFF=0,
FLAG_PRED_SEL_ZERO=2,
FLAG_PRED_SEL_ONE=3
};

enum last_tag{
	FLAG_L=1
};

enum uem_tag {
	FLAG_UEM=1
};

enum up_tag {
	FLAG_UP=1
};

// nb name change so that default is to write
enum write_mask_tag {
	FLAG_NOWRITE=1,
};

enum omod_tag {
FLAG_OMOD_OFF=0,
FLAG_OMOD_M2=1,
FLAG_OMOD_M4=2,
FLAG_OMOD_D2=3
};

enum bs_tag {
	FLAG_VEC_012=0,
FLAG_VEC_021=1,
FLAG_VEC_120=2,
FLAG_VEC_102=3,
FLAG_VEC_201=4,
FLAG_VEC_210=5
};

enum dr_tag {
	FLAG_DR=1,
};

enum clamp_tag {
	FLAG_C=1,
};

enum sel_tag {
SEL_X=0,
SEL_Y=1,
SEL_Z=2,
SEL_W=3,
SEL_0=4,
SEL_1=5,
SEL_MASK=7,
};

/* these are taken from an r700isa document; hopefully still okay... */
enum data_format_tag {
FMT_INVALID=0,
FMT_16_16_16_16_FLOAT=32,
FMT_8=1,
FMT_RESERVED_33=33,
FMT_4_4=2,
FMT_32_32_32_32=34,
FMT_3_3_2=3,
FMT_32_32_32_32_FLOAT=35,
FMT_RESERVED_4=4,
FMT_RESERVED_36=36,
FMT_16=5,
FMT_1=37,
FMT_16_FLOAT=6,
FMT_1_REVERSED=38,
FMT_8_8=7,
FMT_GB_GR=39,
FMT_5_6_5=8,
FMT_BG_RG=40,
FMT_6_5_5=9,
FMT_32_AS_8=41,
FMT_1_5_5_5=10,
FMT_32_AS_8_8=42,
FMT_4_4_4_4=11,
FMT_5_9_9_9_SHAREDEXP=43,
FMT_5_5_5_1=12,
FMT_8_8_8=44,
FMT_32=13,
FMT_16_16_16=45,
FMT_32_FLOAT=14,
FMT_16_16_16_FLOAT=46,
FMT_16_16=15,
FMT_32_32_32=47,
FMT_16_16_FLOAT=16,
FMT_32_32_32_FLOAT=48,
FMT_8_24=17,
FMT_BC1=49,
FMT_8_24_FLOAT=18,
FMT_BC2=50,
FMT_24_8=19,
FMT_BC3=51,
FMT_24_8_FLOAT=20,
FMT_BC4=52,
FMT_10_11_11=21,
FMT_BC5=53,
FMT_10_11_11_FLOAT=22,
FMT_APC0=54,
FMT_11_11_10=23,
FMT_APC1=55,
FMT_11_11_10_FLOAT=24,
FMT_APC2=56,
FMT_2_10_10_10=25,
FMT_APC3=57,
FMT_8_8_8_8=26,
FMT_APC4=58,
FMT_10_10_10_2=27,
FMT_APC5=59,
FMT_X24_8_32_FLOAT=28,
FMT_APC6=60,
FMT_32_32=29,
FMT_APC7=61,
FMT_32_32_FLOAT=30,
FMT_CTX1=62,
FMT_16_16_16_16=31,
FMT_RESERVED_63=63,
};


enum src_sel_tag {
ALU_SRC_LDS_BASE_ADDR=217,
ALU_SRC_LDS_SIZE=218,
ALU_SRC_LDS_OQ_A=219,
ALU_SRC_LDS_OQ_B=220,
ALU_SRC_LDS_OQ_A_POP=221,
ALU_SRC_LDS_OQ_B_POP=222,
ALU_SRC_LDS_DIRECT_A=223,
ALU_SRC_LDS_DIRECT_B=224,
ALU_SRC_CLAUSE_GLOBAL=225,
ALU_SRC_TIME_HI=227,
ALU_SRC_TIME_LO=228,
ALU_SRC_MASK_HI=229,
ALU_SRC_MASK_LO=230,
ALU_SRC_HW_WAVE_ID=231,
ALU_SRC_SIMD_ID=232,
ALU_SRC_SE_ID=233,
ALU_SRC_HW_THREADGRP_ID=234,
ALU_SRC_WAVE_ID_IN_GRP=235,
ALU_SRC_NUM_THREADGRP_WAVES=236,
ALU_SRC_HW_ALU_ODD=237,
ALU_SRC_LOOP_IDX=238,
ALU_SRC_PARAM_BASE_ADDR=240,
ALU_SRC_NEW_PRIM_MASK=241,
ALU_SRC_PRIM_MASK_HI=242,
ALU_SRC_PRIM_MASK_LO=243,
ALU_SRC_1_DBL_L=244,
ALU_SRC_1_DBL_M=245,
ALU_SRC_0_5_DBL_L=246,
ALU_SRC_0_5_DBL_M=247,
ALU_SRC_0=248,
ALU_SRC_1=249,
ALU_SRC_1_INT=250,
ALU_SRC_M_1_INT=251,
ALU_SRC_0_5=252,
ALU_SRC_LITERAL=253,
ALU_SRC_PV=254,
};

// to do the replace, the find is something like {[0-9]+}[ ]{OP2[_A-Z0-9]*} 
//and the replace is \2=\1,

//funny business with a few _64 instructions;
// see potentially-related comments in evergreen guide:
//ALU_INST == OP2_INST_MUL_64,
//for scalar operations used on vector or transcendental unit: opcode 27 (0x1B)
//for vector operations on vector units only: opcode 202 (0xCA).

enum op2_inst_tag {
OP2_INST_ADD=0,
OP2_INST_MUL,
OP2_INST_MUL_IEEE,
OP2_INST_MAX,
OP2_INST_MIN,
OP2_INST_MAX_DX10,
OP2_INST_MIN_DX10,
OP2_INST_SETE=8,
OP2_INST_SETGT,
OP2_INST_SETGE,
OP2_INST_SETNE,
OP2_INST_SETE_DX10,
OP2_INST_SETGT_DX10,
OP2_INST_SETGE_DX10,
OP2_INST_SETNE_DX10,
OP2_INST_FRACT,
OP2_INST_TRUNC,
OP2_INST_CEIL,
OP2_INST_RNDNE,
OP2_INST_FLOOR,
OP2_INST_ASHR_INT,
OP2_INST_LSHR_INT,
OP2_INST_LSHL_INT,
OP2_INST_MOV=25,
OP2_INST_NOP  =  26  ,
//OP2_INST_MUL_64  =  27  , //?
//OP2_INST_FLT64_TO_FLT32  =  28  , //?
//OP2_INST_FLT32_TO_FLT64  =  29  , //?
OP2_INST_PRED_SETGT_UINT  =  30  ,
OP2_INST_PRED_SETGE_UINT  =  31  ,
OP2_INST_PRED_SETE  =  32  ,
OP2_INST_PRED_SETGT  =  33  ,
OP2_INST_PRED_SETGE  =  34  ,
OP2_INST_PRED_SETNE  =  35  ,
OP2_INST_PRED_SET_INV  =  36  ,
OP2_INST_PRED_SET_POP  =  37  ,
OP2_INST_PRED_SET_CLR  =  38  ,
OP2_INST_PRED_SET_RESTORE  =  39  ,
OP2_INST_PRED_SETE_PUSH  =  40  ,
OP2_INST_PRED_SETGT_PUSH  =  41  ,
OP2_INST_PRED_SETGE_PUSH  =  42  ,
OP2_INST_PRED_SETNE_PUSH  =  43  ,
OP2_INST_KILLE  =  44  ,
OP2_INST_KILLGT  =  45  ,
OP2_INST_KILLGE=46,
OP2_INST_KILLNE=47,
OP2_INST_AND_INT=48,
OP2_INST_OR_INT=49,
OP2_INST_XOR_INT=50,
OP2_INST_NOT_INT=51,
OP2_INST_ADD_INT=52,
OP2_INST_SUB_INT=53,
OP2_INST_MAX_INT=54,
OP2_INST_MIN_INT=55,
OP2_INST_MAX_UINT=56,
OP2_INST_MIN_UINT=57,
OP2_INST_SETE_INT=58,
OP2_INST_SETGT_INT=59,
OP2_INST_SETGE_INT=60,
OP2_INST_SETNE_INT=61,
OP2_INST_SETGT_UINT=62,
OP2_INST_SETGE_UINT=63,
OP2_INST_KILLGT_UINT=64,
OP2_INST_KILLGE_UINT=65,
OP2_INST_PRED_SETE_INT=66,
OP2_INST_PRED_SETGT_INT=67,
OP2_INST_PRED_SETGE_INT=68,
OP2_INST_PRED_SETNE_INT=69,
OP2_INST_KILLE_INT=70,
OP2_INST_KILLGT_INT=71,
OP2_INST_KILLGE_INT=72,
OP2_INST_KILLNE_INT=73,
OP2_INST_PRED_SETE_PUSH_INT=74,
OP2_INST_PRED_SETGT_PUSH_INT=75,
OP2_INST_PRED_SETGE_PUSH_INT=76,
OP2_INST_PRED_SETNE_PUSH_INT=77,
OP2_INST_PRED_SETLT_PUSH_INT=78,
OP2_INST_PRED_SETLE_PUSH_INT=79,
OP2_INST_FLT_TO_INT=80,
OP2_INST_BFREV_INT=81,
OP2_INST_ADDC_UINT=82,
OP2_INST_SUBB_UINT=83,
OP2_INST_GROUP_BARRIER=84,
OP2_INST_SET_MODE=87,
OP2_INST_SET_LDS_SIZE=90,
OP2_INST_MUL_INT24=91,
OP2_INST_MULHI_INT24=92,
OP2_INST_EXP_IEEE=129,
OP2_INST_LOG_CLAMPED=130,
OP2_INST_LOG_IEEE=131,
OP2_INST_RECIP_CLAMPED=132,
OP2_INST_RECIP_FF=133,
OP2_INST_RECIP_IEEE=134,
OP2_INST_RECIPSQRT_CLAMPED=135,
OP2_INST_RECIPSQRT_FF=136,
OP2_INST_RECIPSQRT_IEEE=137,
OP2_INST_SQRT_IEEE=138,
OP2_INST_SIN=141,
OP2_INST_COS=142,
OP2_INST_MULLO_INT=143,
OP2_INST_MULHI_INT=144,
OP2_INST_MULLO_UINT=145,
OP2_INST_MULHI_UINT=146,
OP2_INST_RECIP_64=149,
OP2_INST_RECIP_CLAMPED_64=150,
OP2_INST_RECIPSQRT_64=151,
OP2_INST_RECIPSQRT_CLAMPED_64=152,
OP2_INST_SQRT_64=153,
OP2_INST_FLT_TO_UINT=154,
OP2_INST_INT_TO_FLT=155,
OP2_INST_UINT_TO_FLT=156,
OP2_INST_BFM_INT=160,
OP2_INST_FLT32_TO_FLT16_RTZ=161,
OP2_INST_FLT32_TO_FLT16=162,
OP2_INST_FLT16_TO_FLT32=163,
OP2_INST_UBYTE0_FLT=164,
OP2_INST_UBYTE1_FLT=165,
OP2_INST_UBYTE2_FLT=166,
OP2_INST_UBYTE3_FLT=167,
OP2_INST_BCNT_INT=170,
OP2_INST_FFBH_UINT=171,
OP2_INST_FFBL_INT=172,
OP2_INST_FFBH_INT=173,
OP2_INST_FLT_TO_UINT4=174,
OP2_INST_DOT_IEEE=175,
OP2_INST_FLT_TO_INT_RPI=176,
OP2_INST_FLT_TO_INT_FLOOR=177,
OP2_INST_MULHI_UINT24=178,
OP2_INST_MBCNT_32HI_INT=179,
OP2_INST_OFFSET_TO_FLT=180,
OP2_INST_MUL_UINT24=181,
OP2_INST_BCNT_ACCUM_PREV_INT=182,
OP2_INST_MBCNT_32LO_ACCUM_PREV_INT=183,
OP2_INST_SETE_64=184,
OP2_INST_SETNE_64=185,
OP2_INST_SETGT_64=186,
OP2_INST_SETGE_64=187,
OP2_INST_MIN_64=188,
OP2_INST_MAX_64=189,
OP2_INST_DOT4=190,
OP2_INST_DOT4_IEEE=191,
OP2_INST_CUBE=192,
OP2_INST_MAX4=193,
OP2_INST_FREXP_64=196,
OP2_INST_LDEXP_64=197,
OP2_INST_FRACT_64=198,
OP2_INST_PRED_SETGT_64=199,
OP2_INST_PRED_SETE_64=200,
OP2_INST_PRED_SETGE_64=201,
OP2_INST_MUL_64=202,
OP2_INST_ADD_64=203,
OP2_INST_FLT64_TO_FLT32=205,
OP2_INST_FLT32_TO_FLT64=206,
OP2_INST_SAD_ACCUM_PREV_UINT=207,
OP2_INST_DOT=208,
OP2_INST_MUL_PREV=209,
OP2_INST_MUL_IEEE_PREV=210,
OP2_INST_ADD_PREV=211,
OP2_INST_MULADD_PREV=212,
OP2_INST_MULADD_IEEE_PREV=213,
OP2_INST_INTERP_XY=214,
OP2_INST_INTERP_ZW=215,
OP2_INST_INTERP_X=216,
OP2_INST_INTERP_Z=217,
OP2_INST_STORE_FLAGS=218,
OP2_INST_LOAD_STORE_FLAGS=219,
OP2_INST_INTERP_LOAD_P0=224,
OP2_INST_INTERP_LOAD_P10=225,
OP2_INST_INTERP_LOAD_P20=226,
};


enum op3_inst_tag {
 OP3_INST_BFE_UINT=4,
 OP3_INST_BFE_INT=5,
 OP3_INST_BFI_INT=6,
 OP3_INST_FMA=7,
 OP3_INST_MULADD_INT24=8,
 OP3_INST_CNDNE_64=9,
 OP3_INST_FMA_64=10,
 OP3_INST_LERP_UINT=11,
 OP3_INST_BIT_ALIGN_INT=12,
 OP3_INST_BYTE_ALIGN_INT=13,
 OP3_INST_SAD_ACCUM_UINT=14,
 OP3_INST_SAD_ACCUM_HI_UINT=15,
 OP3_INST_MULADD_UINT24=16,
 OP3_INST_LDS_IDX_OP=17,
 OP3_INST_MULADD=20,
 OP3_INST_MULADD_M2=21,
 OP3_INST_MULADD_M4=22,
 OP3_INST_MULADD_D2=23,
 OP3_INST_MULADD_IEEE=24,
 OP3_INST_CNDE=25,
 OP3_INST_CNDGT=26,
 OP3_INST_CNDGE=27,
 OP3_INST_CNDE_INT=28,
 OP3_INST_CMNDGT_INT=29,
 OP3_INST_CMNDGE_INT=30,
 OP3_INST_MUL_LIT=31
};

enum cf_inst_tag{
CF_INST_NOP=0,
CF_INST_TC=1,
CF_INST_GDS=3,
CF_INST_LOOP_START=4,
CF_INST_LOOP_END=5,
CF_INST_LOOP_START_DX10=6,
CF_INST_LOOP_START_NO_AL=7,
CF_INST_LOOP_CONTINUE=8,
CF_INST_LOOP_BREAK=9,
CF_INST_JUMP=10,
CF_INST_PUSH=11,
CF_INST_ELSE=13,
CF_INST_POP=14,
CF_INST_CALL=18,
CF_INST_CALL_FS=19,
CF_INST_RETURN=20,
CF_INST_EMIT_VERTEX=21,
CF_INST_EMIT_CUT_VERTEX=22,
CF_INST_CUT_VERTEX=23,
CF_INST_KILL=24,
CF_INST_WAIT_ACK=26,
CF_INST_TC_ACK=27,
CF_INST_JUMPTABLE=29,
CF_INST_GLOBAL_WAVE_SYNC=30,
CF_INST_HALT=31,
CF_INST_END=32,
CF_INST_LDS_DEALLOC=33,
CF_INST_PUSH_WQM=34,
CF_INST_POP_WQM=35,
CF_INST_ELSE_WQM=36,
CF_INST_JUMP_ANY=37,
CF_INST_REACTIVATE=38,
CF_INST_REACTIVATE_WQM=39,
CF_INST_INTERRUPT=40,
CF_INST_INTERRUPT_AND_SLEEP=41,
CF_INST_SET_PRIORITY=42
};


enum cf_alu_inst_tag{
CF_INST_ALU=8,
CF_INST_ALU_PUSH_BEFORE=9,
CF_INST_ALU_POP_AFTER=10,
CF_INST_ALU_POP2_AFTER=11,
CF_INST_ALU_EXTENDED=12,
CF_INST_ALU_REACTIVATE_BEFORE=13,
CF_INST_ALU_VALID_PIXEL_MODE=14,
CF_INST_ALU_ELSE_AFTER=15
};

enum rat_inst_tag{
EXPORT_RAT_INST_NOP=0,
EXPORT_RAT_INST_STORE_TYPED=1,
EXPORT_RAT_INST_CMPXCHG_INT=4,
EXPORT_RAT_INST_ADD=7,
EXPORT_RAT_INST_SUB=8,
EXPORT_RAT_INST_RSUB=9,
EXPORT_RAT_INST_MIN_INT=10,
EXPORT_RAT_INST_MIN_UINT=11,
EXPORT_RAT_INST_MAX_INT=12,
EXPORT_RAT_INST_MAX_UINT=13,
EXPORT_RAT_INST_AND=14,
EXPORT_RAT_INST_OR=15,
EXPORT_RAT_INST_XOR=16,
EXPORT_RAT_INST_INC_UINT=18,
EXPORT_RAT_INST_DEC_UINT=19,
EXPORT_RAT_INST_STORE_DWORD=20,
EXPORT_RAT_INST_STORE_SHORT=21,
EXPORT_RAT_INST_STORE_BYTE=22,
EXPORT_RAT_INST_NOP_RTN=32,
EXPORT_RAT_INST_XCHG_RTN=34,
EXPORT_RAT_INST_CMPXCHG_INT_RTN=36,
EXPORT_RAT_INST_ADD_RTN=39,
EXPORT_RAT_INST_SUB_RTN=40,
EXPORT_RAT_INST_RSUB_RTN=41,
EXPORT_RAT_INST_MIN_INT_RTN=42,
EXPORT_RAT_INST_MIN_UINT_RTN=43,
EXPORT_RAT_INST_MAX_INT_RTN=44,
EXPORT_RAT_INST_MAX_UINT_RTN=45,
EXPORT_RAT_INST_AND_RTN=46,
EXPORT_RAT_INST_OR_RTN=47,
EXPORT_RAT_INST_XOR_RTN=48,
EXPORT_RAT_INST_INC_UINT_RTN=50,
EXPORT_RAT_INST_DEC_UINT_RTN=51,
};

enum cf_inst_mem_buf_tag{
CF_INST_MEM_STREAM0_BUF0=64,
CF_INST_MEM_STREAM0_BUF1=65,
CF_INST_MEM_STREAM0_BUF2=66,
CF_INST_MEM_STREAM0_BUF3=67,
CF_INST_MEM_STREAM1_BUF0=68,
CF_INST_MEM_STREAM1_BUF1=69,
CF_INST_MEM_STREAM1_BUF2=70,
CF_INST_MEM_STREAM1_BUF3=71,
CF_INST_MEM_STREAM2_BUF0=72,
CF_INST_MEM_STREAM2_BUF1=73,
CF_INST_MEM_STREAM2_BUF2=74,
CF_INST_MEM_STREAM2_BUF3=75,
CF_INST_MEM_STREAM3_BUF0=76,
CF_INST_MEM_STREAM3_BUF1=77,
CF_INST_MEM_STREAM3_BUF2=78,
CF_INST_MEM_STREAM3_BUF3=79,
CF_INST_MEM_WR_SCRATCH=80,
CF_INST_MEM_RING=82,
CF_INST_MEM_EXPORT=85,
CF_INST_MEM_RAT=86,
CF_INST_MEM_RAT_CACHELESS=87,
CF_INST_MEM_RING1=88,
CF_INST_MEM_RING2=89,
CF_INST_MEM_RING3=90,
CF_INST_MEM_EXPORT_COMBINED=91,
CF_INST_MEM_RAT_COMBINED_CACHELESS=92,
};

enum cf_inst_swiz_tag{
CF_INST_EXPORT=83,
CF_INST_EXPORT_DONE=84,
};


// have to be careful here: the doc is a bit ambiguous
// with some numbers starting from bit 7 and others from
// bit 8
// As a guess I've multipled the latter by two...

/* listed as:
46 OP2_INST_KILLGE
47 OP2_INST_KILLNE
66 OP2_INST_PRED_SETE_INT
67 OP2_INST_PRED_SETGT_INT
68 OP2_INST_PRED_SETGE_INT
69 OP2_INST_PRED_SETNE_INT
70 OP2_INST_KILLE_INT
71 OP2_INST_KILLGT_INT
72 OP2_INST_KILLGE_INT
73 OP2_INST_KILLNE_INT
74 OP2_INST_PRED_SETE_PUSH_INT
75 OP2_INST_PRED_SETGT_PUSH_INT
76 OP2_INST_PRED_SETGE_PUSH_INT
77 OP2_INST_PRED_SETNE_PUSH_INT
78 OP2_INST_PRED_SETLT_PUSH_INT
79 OP2_INST_PRED_SETLE_PUSH_INT
199 OP2_INST_PRED_SETGT_64
200 OP2_INST_PRED_SETE_64
201 OP2_INST_PRED_SETGE_64
*/
/*
enum alu_inst_execute_mask_tag {
OP2_INST_PRED_SETGT_UINT=30,
OP2_INST_PRED_SETGE_UINT=31,
OP2_INST_PRED_SETE=32,
OP2_INST_PRED_SETGT=33,
OP2_INST_PRED_SETGE=34,
OP2_INST_PRED_SETNE=35,
OP2_INST_PRED_SET_INV=36,
OP2_INST_PRED_SET_POP=37,
OP2_INST_PRED_SET_CLR=38,
OP2_INST_PRED_SET_RESTORE=39,
OP2_INST_PRED_SETE_PUSH=40,
OP2_INST_PRED_SETGT_PUSH=41,
OP2_INST_PRED_SETGE_PUSH=42,
OP2_INST_PRED_SETNE_PUSH=43,
OP2_INST_KILLE=44,
OP2_INST_KILLGT=45,
// change here...
OP2_INST_KILLGE=46*2,
OP2_INST_KILLNE=47*2,
OP2_INST_PRED_SETE_INT=66*2,
OP2_INST_PRED_SETGT_INT=67*2,
OP2_INST_PRED_SETGE_INT=68*2,
OP2_INST_PRED_SETNE_INT=69*2,
OP2_INST_KILLE_INT=70*2,
OP2_INST_KILLGT_INT=71*2,
OP2_INST_KILLGE_INT=72*2,
OP2_INST_KILLNE_INT=73*2,
OP2_INST_PRED_SETE_PUSH_INT=74*2,
OP2_INST_PRED_SETGT_PUSH_INT=75*2,
OP2_INST_PRED_SETGE_PUSH_INT=76*2,
OP2_INST_PRED_SETNE_PUSH_INT=77*2,
OP2_INST_PRED_SETLT_PUSH_INT=78*2,
OP2_INST_PRED_SETLE_PUSH_INT=79*2,
OP2_INST_PRED_SETGT_64=199*2,
OP2_INST_PRED_SETE_64=200*2,
OP2_INST_PRED_SETGE_64=201*2,
};
*/

enum vc_inst_tag {
	VC_INST_FETCH=0,
	VC_INST_SEMANTIC=1,
	VC_INST_GET_BUFFER_RESINFO=14
};

enum tex_inst_tag {
TEX_INST_LD=3,
TEX_INST_GET_TEXTURE_RESINFO=4,
TEX_INST_GET_NUMBER_OF_SAMPLES=5,
TEX_INST_GET_COMP_TEX_LOD=6,
TEX_INST_GET_GRADIENTS_H=7,
TEX_INST_GET_GRADIENTS_V=8,
TEX_INST_SET_TEXTURE_OFFSETS=9,
TEX_INST_KEEP_GRADIENTS=10,
TEX_INST_SET_GRADIENTS_H=11,
TEX_INST_SET_GRADIENTS_V=12,
TEX_INST_SAMPLE=16,
TEX_INST_SAMPLE_L=17,
TEX_INST_SAMPLE_LB=18,
TEX_INST_SAMPLE_LZ=19,
TEX_INST_SAMPLE_G=20,
TEX_INST_GATHER4=21,
TEX_INST_SAMPLE_G_LB=22,
TEX_INST_GATHER4_O=23,
TEX_INST_SAMPLE_C=24,
TEX_INST_SAMPLE_C_L=25,
TEX_INST_SAMPLE_C_LB=26,
TEX_INST_SAMPLE_C_LZ=27,
TEX_INST_SAMPLE_C_G=28,
TEX_INST_GATHER4_C=29,
TEX_INST_SAMPLE_C_G_LB=30,
TEX_INST_GATHER4_C_O=31,
};

enum mem_rd_inst_tag{
MEM_INST_MEM=2
};

enum mem_rd_mem_op_tag{
	MEM_RD_SCRATCH=0,
	MEM_RD_SCATTER=2
};


struct cf_word0 {
	unsigned int addr:24;
	unsigned int jumptable_sel:3;
	unsigned int reserved0:5;
};

struct cf_word1 {
	unsigned int pop_count:3;
	unsigned int cf_const:5;
	unsigned int cond:2;
	unsigned int count:6;
	unsigned int reserved1_1:4;
	unsigned int valid_pixel_mode:1;
	unsigned int reserved1_2:1;
	unsigned int cf_inst:8;
	unsigned int reserved1_3:1; 
	unsigned int barrier:1;
};

struct cf_alu_word0 {
	unsigned int addr:22;
	unsigned int kcache_bank0:4;
	unsigned int kcache_bank1:4;
	unsigned int kcache_mode0:2;
};

struct cf_alu_word1 {
	unsigned int kcache_mode1:2;
	unsigned int kcache_addr0:8;
	unsigned int kcache_addr1:8;
	unsigned int count:7;
	unsigned int alt_const:1;
	unsigned int cf_inst:4;
	unsigned int whole_quad_mode:1;
	unsigned int barrier:1;
};

struct cf_alloc_export_word0 {
	unsigned int array_base:13; 
	unsigned int type:2;
	unsigned int rw_gpr:7;
	unsigned int rw_rel:1;
	unsigned int index_gpr:7;
	unsigned int elem_size:2;
};

struct cf_alloc_export_word0_rat {
	unsigned int rat_id:4;
	unsigned int rat_inst:6;
	unsigned int reserved0:1;
	unsigned int rat_index_mode:2;
	unsigned int type:2;
	unsigned int rw_gpr:7;
	unsigned int rw_rel:1;
	unsigned int index_gpr:7;
	unsigned int elem_size:2;
};

struct cf_alloc_export_word1_buf {
	unsigned int array_size:12; 
	unsigned int comp_mask:4;
	unsigned int burst_count:4;
	unsigned int valid_pixel_mode:1;
	unsigned int reserved1:1;
	unsigned int cf_inst:8;
	unsigned int mark:1;
	unsigned int barrier:1;
};

struct cf_alloc_export_word1_swiz {
	unsigned int sel_x:3;
	unsigned int sel_y:3;
	unsigned int sel_z:3;
	unsigned int sel_w:3;
	unsigned int reserved1_1:4;
	unsigned int burst_count:4;
	unsigned int valid_pixel_mode:1;
	unsigned int reserved1_2:1;
	unsigned int cf_inst:8;
	unsigned int mark:1;
	unsigned int barrier:1;
};

struct alu_word0 {
	unsigned int src0_sel:9;
	unsigned int src0_rel:1;
	unsigned int src0_chan:2;
	unsigned int src0_neg:1;
	unsigned int src1_sel:9;
	unsigned int src1_rel:1;
	unsigned int src1_chan:2;
	unsigned int src1_neg:1;
	unsigned int index_mode:3;
	unsigned int pred_sel:2;
	unsigned int last:1;
} ;

struct alu_word1_op2 {
	unsigned int src0_abs:1;
	unsigned int src1_abs:1;
	unsigned int update_exec_mask:1;
	unsigned int update_pred:1;
	unsigned int write_mask:1;
	unsigned int omod:2;
	unsigned int alu_inst:11;
	unsigned int bank_swizzle:3;
	unsigned int dst_gpr:7;
	unsigned int dst_rel:1;
	unsigned int dst_chan:2;
	unsigned int clamp:1;
} ;


struct alu_word1_op3 {
	unsigned int src2_sel:9;
	unsigned int src2_rel:1;
	unsigned int src2_chan:2;
	unsigned int src2_neg:1;
	unsigned int alu_inst:5;
	unsigned int bank_swizzle:3;
	unsigned int dst_gpr:7;
	unsigned int dst_rel:1;
	unsigned int dst_chan:2;
	unsigned int clamp:1;
} ;

struct alu_word1_op2_execute_mask {
	unsigned int src0_abs:1;
	unsigned int src1_abs:1;
	unsigned int update_exec_mask:1;
	unsigned int update_pred:1;
	unsigned int write_mask:1;
	unsigned int execute_mask_op:2;
	unsigned int alu_inst:11;
	unsigned int bank_swizzle:3;
	unsigned int dst_gpr:7;
	unsigned int dst_rel:1;
	unsigned int dst_chan:2;
	unsigned int clamp:1;
};

struct alu_literal {
	float a;
	float b;
};

struct vtx_word0 {
	unsigned int vc_inst:5;
	unsigned int fetch_type:2;
	unsigned int fetch_whole_quad:1;
	unsigned int buffer_id:8;
	unsigned int src_gpr:7;
	unsigned int src_rel:1;
	unsigned int src_sel_x:2;
	unsigned int src_sel_y:2;
	unsigned int structured_read:2;
	unsigned int lds_req:1;
	unsigned int coalesced_read:1;
};

struct vtx_word1_gpr {
	unsigned int dst_gpr:7; 
	unsigned int dst_rel:1;
	unsigned int reserved1:1;
	unsigned int dst_sel_x:3;
	unsigned int dst_sel_y:3;
	unsigned int dst_sel_z:3;
	unsigned int dst_sel_w:3;
	unsigned int use_const_fields:1;
	unsigned int data_format:6;
	unsigned int num_format_all:2;
	unsigned int format_comp_all:1;
	unsigned int srf_mode_all:1;
};

struct vtx_word2 {
	unsigned int offset:16;
	unsigned int endian_swap:2;
	unsigned int const_buf_no_stride:1;
	unsigned int reserved2_1:1;
	unsigned int alt_const:1;
	unsigned int buffer_index_mode:2; 
	unsigned int reserved2_2:9;
};

struct vtx_word3 {
	unsigned int pad;
};

struct tex_word0 {
	unsigned int tex_inst:5;
	unsigned int inst_mod:2;
	unsigned int fetch_whole_quad:1;
	unsigned int resource_id:8;
	unsigned int src_gpr:7;
	unsigned int src_rel:1;
	unsigned int alt_const:1;
	unsigned int resource_index_mode:2;
	unsigned int sampler_index_mode:2;
	unsigned int reserved0:3;
};

struct tex_word1 {
	unsigned int dst_gpr:7;
	unsigned int dst_rel:1;
	unsigned int reserved1:1;
	unsigned int dst_sel_x:3;
	unsigned int dst_sel_y:3;
	unsigned int dst_sel_z:3;
	unsigned int dst_sel_w:3;
	unsigned int lod_bias:7;
	unsigned int coord_type_x:1;
	unsigned int coord_type_y:1;
	unsigned int coord_type_z:1;
	unsigned int coord_type_w:1;

};

struct tex_word2 {
	unsigned int offset_x:5;
	unsigned int offset_y:5;
	unsigned int offset_z:5;
	unsigned int sampler_id:5;
	unsigned int src_sel_x:3;
	unsigned int src_sel_y:3;
	unsigned int src_sel_z:3;
	unsigned int src_sel_w:3;
};

struct tex_word3 {
	unsigned int pad;
};

struct mem_rd_word0 {
	unsigned int mem_inst:5;
	unsigned int elem_size:2;
	unsigned int fetch_whole_quad:1;
	unsigned int mem_op:3;
	unsigned int uncached:1;
	unsigned int indexed:1;
	unsigned int src_sel_y:2;
	unsigned int reserved0:1;
	unsigned int src_gpr:7;
	unsigned int src_rel:1;
	unsigned int src_sel_x:2;
	unsigned int burst_cnt:4;
	unsigned int lds_req:1;
	unsigned int coalesced_read:1;
};

struct mem_rd_word1 {
	unsigned int dst_gpr:7;
	unsigned int dst_rel:1;
	unsigned int reserved1_1:1;
	unsigned int dst_sel_x:3;
	unsigned int dst_sel_y:3;
	unsigned int dst_sel_z:3;
	unsigned int dst_sel_w:3;
	unsigned int reserved1_2:1;
	unsigned int data_format:6;
	unsigned int num_format_all:2;
	unsigned int format_comp_all:1;
	unsigned int srf_mode_all:1;
};

struct mem_rd_word2 {
	unsigned int array_base:13;
	unsigned int reserved2_1:3;
	unsigned int endian_swap:2;
	unsigned int reserved2_2:2;
	unsigned int array_size:12;
};

struct mem_rd_word3 {
	unsigned int pad;
};

#endif
