#!/usr/bin/python
#
# Python control of the UCam system, a test script to soak test system.
#

from Ultracam import *

import time
# Now call "time.sleep(no_of_seconds)" to pause for a while
# Also: use "raw_input('Hit return to continue:')" for a user pause

# Just setting up some string variables first to be used later on
CAMERA_URL="localhost:7063"
FILESAVE_URL="localhost:5417"

# Power ON the controller aplication
POWON = "dazle_pon_app.xml"

# Download the application for Non-Destructive Readouts, etc. 
TESTAPP = "dazle_dummy_app.xml"

# Set up the system to talk to ultracam
ucam = Ultracam(cameraURL=CAMERA_URL, filesaveURL=FILESAVE_URL)
ucam.initialise()
print "Status: ",ucam.getStatus()

# Next, lets switch the camera on
# Grab the application
pon = ucam.getApplication(POWON)
# Post it to the server
result = ucam.execute(pon)
print "POWER UP the controller using ",POWON,":", result

# Now lets run a test application 
app = ucam.getApplication(TESTAPP)

nexp = [ 1, 3]
run = 0
for nval in range(len(nexp)):
    app.setparam("NUM_EXPS", nexp[nval])
    run = run + 1
    print "\nStarting run",run,": Application =",TESTAPP,": Parameters NUM_EXPS =",nexp[nval]
    result = ucam.execute(app)
    print "Completed run",run,": Application =",TESTAPP,": Status =",result
    (state,status,file) = ucam.getFStatus()
    print "Output data file :", file+".dat"
    time.sleep(3)
