#!/usr/bin/python
#
# Python control of the UCam system, a test script to soak test system.
#

from Ultracam import *

import time
# Now call "time.sleep(no_of_seconds)" to pause for a while
# Also: use "raw_input('Hit return to continue:')" for a user pause

# Just setting up some string variables first to be used later on

# Power off the controller application
POWOFF = "do_miri_pof.xml"

# Power ON the controller aplication
POWON = "do_miri_pon.xml"

# Download the application for Single Raw Read
TESTAPP = "do_michelle_stare.xml"

# Set up the system to talk to ultracam
ucam = Ultracam(cameraURL="miri1:7063", filesaveURL="miri1:5417")
ucam.initialise()
print "Status: ",ucam.getStatus()

# First of all, lets power off
pof = ucam.getApplication(POWOFF)
# Post it to the server
result = ucam.execute(pof)
print "POWERING DOWN the controller using ",POWOFF,":", result

# Next, lets switch the camera on
# Grab the application
pon = ucam.getApplication(POWON)
# Post it to the server
result = ucam.execute(pon)
print "POWER UP the controller using ",POWON,":", result

# Now lets run an a test application 
app = ucam.getApplication(TESTAPP)

dwell = [ 5, 50, 500 ]
ysize = [ 1, 10, 100, 1000 ]
nexp  = [ 1, 1000, 3000 ]

run = 0
for dval in range(len(dwell)):
    app.setparam("DWELL", dwell[dval])
    for yval in range(len(ysize)):
        app.setparam("YSIZE", ysize[yval])
        for nval in range(len(nexp)):
            app.setparam("NUM_EXPS", nexp[nval])
            run = run + 1
            print "\nStarting run",run,": Application =",TESTAPP,": Parameters DWELL =",dwell[dval],"YSIZE =",ysize[yval],"NUM_EXPS =",nexp[nval]
            result = ucam.execute(app)
            print "Completed run",run,": Application =",TESTAPP,": Status =",result
            (state,status,file) = ucam.getFStatus()
            print "Output data file :", file+".dat"
            time.sleep(3)

# Last of all, lets power off
pof = ucam.getApplication(POWOFF)
# Post it to the server
result = ucam.execute(pof)
print "POWERING DOWN the controller using ",POWOFF,":", result
