#!/usr/bin/python

import httplib
import sys
import libxml2
import string
import time

class stType:
  st_text = {"OK":1,"BUSY":2,"ERROR":3}
  def text2val(self, text):
    return self.st_text[text]
  def val2txt(self,val):
    for k in self.st_text.keys():
      if self.st_text.keys[k] == val:
        return k
  def _equals(self, v, text):
    if type(v) == type(1):
      return v == self.st_text[text]
    else:
      return v == text
  def isOK(self, v):
    return(self._equals(v,"OK"))
  def isBUSY(self, v):
    return(self._equals(v,"BUSY"))
  def isERROR(self, v):
    return(self._equals(v,"ERROR"))
        

#
# Combined status and state;
#
#    State
#       if any are ERROR then error
#       else if any are busy then busy
#       else idle
#
#    Status
#       if any are ERROR then ERROR
#       else if any are BUSY then BUSY
#       else OK

class ustatus:
  def __init__(self, xmlelem=None):
    self.state = {}
    self.status = {}
    self.last_path = None
    self.InternalStatus = "UNKNOWN"
    if xmlelem:
      self.set_status(xmlelem)

  def __exec__(self,xmlelem):
    self.set_status(xmlelem)

  def set_status(self,xmlelem):
    self.state = {}
    self.status = {}
    self.last_path = None
    for e in xmlelem.children:
      if e.name == "state":
        for p in e.properties:
          self.state[p.name] = p.content
      if e.name == "status":
        for p in e.properties:
          self.status[p.name] = p.content
      if e.name == "lastfile":
        for p in e.properties:
          if p.name == "path":
            self.last_path = p.content


  def parse(self, buf):
    ss = buf.replace('\0',' ')
    doc = libxml2.parseDoc(ss)
    elem = doc.getRootElement()
    if elem.name != "response":
      return 0
    self.set_status(elem)
    doc.freeDoc()

  def __repr__(self):
    return "status.repr() not defined yet!"

  def getstate(self, object=None):
    state = "IDLE"
    if object==None:
      for k in self.state.keys():
        if "ERROR" == self.state[k]:
          return "ERROR"
        elif "BUSY" == self.state[k]:
          state = "BUSY"
      return state
    else:
      return self.state[object]

  def getpath(self):
    return self.last_path

  def getstatus(self, object=None):
    state = "OK"
    if object==None:
      for k in self.state.keys():
        if "ERROR" == self.state[k]:
          return "ERROR"
        elif "BUSY" == self.state[k]:
          state = "BUSY"
      return state
    else:
      return self.state[object]


class uapplication:
  rootnode = None
  doc = None

  def __init__(self, xmlelem=None):
    if xmlelem:
      self.rootnode = xmlelem

  def __exec__(self,xmlelem):
    if self.doc:
      self.doc.freeDoc()
      self.doc = None
    self.rootnode = xmlelem

  def parse(self, buf):
    if self.doc:
      self.doc.freeDoc()
      self.doc = None
    ss = buf.replace('\0',' ')
    doc = libxml2.parseDoc(ss)
    self.doc = doc
    self.rootnode = doc.getRootElement()
    if self.rootnode.name != "configure":
      self.rootnode = None
      return 0
    return 1

  def parseFile(self, filename):
    if self.doc:
      self.doc.freeDoc()
      self.doc = None
    doc = libxml2.parseFile(filename)
    self.doc = doc
    self.rootnode = doc.getRootElement()
    if self.rootnode.name != "configure":
      self.rootnode = None
      return 0
    return 1

  def save(self, filename):
    fp = open(filename,"w")
    r=fp.write(self.doc.serialize())
    fp.close()
    return r

  def __repr__(self):
    return self.doc.serialize()

  def setparam(self, parameter, value):
    i = 0
    for e in self.rootnode.children:
      if e.name == "configure_camera":
        for p in e.children:
          if p.name == "set_parameter":
            attr = p.hasProp("ref")
            if attr.content == parameter:
              p.setProp("value",repr(value))
              i = i + 1
    return i

  def getparameter(self, parameter):
    # Just return the LAST parameter with this name.
    for e in self.rootnode.children:
      if e.name == "configure_camera":
        for p in e.children:
          if p.name == "set_parameter":
            attr = p.hasProp("ref")
            if attr.content == parameter:
              pval = p.prop("value")
    return pval

def check_reason(r):
  if r.status == 200 and r.reason == "OK":
    return 1
  else:
    return 0

#  <source>Camera server</source>
#    <debug responsenumber="101"/>
#      <status software="OK" camera="OK" errnum="0"/>
#        <state camera="IDLE" identifier="0"/>

def check_response(s):
  # need to remove embedded NULL bytes.....
  ss = s.replace('\0',' ')
  doc = libxml2.parseDoc(ss)
  elem = doc.getRootElement()
  print 'Response of type %s' % elem.name
  if elem.name != "response":
    return 1
  for e in elem.children:
    if e.name == "state":
      for p in e.properties:
        print p.name, p.content
    if e.name == "status":
      for p in e.properties:
        print p.name, p.content

  doc.freeDoc()
  return 1

from types import *
class userver:
  def __init__(self, URL="http://localhost:8080", name="UNKNOWN", debug =0):
    self.initfiles = ["uk_atc.xml", "ultracam.xml"]
    self.conn=httplib.HTTPConnection(URL)
    self.status = ustatus()
    self.lastr = None
    self.addr = URL
    self.wait = 1.0
    self.commands = ["GO","ST","RST","RCO"]
    self.debug = debug
    self.name = name

  def get(self,URL):
    self.conn.request("GET",URL)
    self.lastr = self.conn.getresponse()
    if self.debug:
      print '----------------DEBUG----------------'
      print 'Server %s URL %s GET' % (self.addr,URL)
      print self.lastr
      check_response(self.lastr.read())
      print '-------------------------------------'
    return (self.lastr)

  def post(self,URL,params,headers=None):
    if headers:
      self.conn.request("POST",URL,params,headers)
    else:
      self.conn.request("POST",URL,params)
    self.lastr = self.conn.getresponse()
    if self.debug:
      print '----------------DEBUG----------------'
      print 'Server %s URL %s POST' % (self.addr,URL)
      check_response(self.lastr)
      print '-------------------------------------'
    return (self.lastr)

  #
  # High level functionality
  #
  def initialise(self):
    for i in self.initfiles:
      r = self.get("/config?%s"%i)
      if not check_reason(r):
        return 0 
    return 1

  def getApplication(self,name):
    r = self.get("/get?filename=%s"%name)
    if not check_reason(r):
      return(None)
    # return r.read()
    u = uapplication()
    u.parse(r.read())
    return u

  def getStatus(self):
    r = self.get("/status")
    self.status.parse(r.read())
    state = self.status.getstate()
    status = self.status.getstatus()
    return (state,status)

  def getFStatus(self):
    r = self.get("/fstatus")
    self.status.parse(r.read())
    state = self.status.getstate()
    status = self.status.getstatus()
    file = self.status.getpath()
    return (state,status,file)

  def part_execute(self, xmldoc=None):
    if xmldoc!=None:
      if type(xmldoc) is InstanceType:
        xmldoc = repr(xmldoc)
      headers={"Content-Type": "text/xml"}
      r = self.post("/config",xmldoc,headers)
      self.status.parse(r.read())
      stat= self.status.getstatus() 
      return stat
      #if stat != "OK":
      #  return 0
    return 0

  def waitonbusy(self, iter=5):
    # Wait whilst BUSY (with a max count of iter), generate an exception on
    # ERROR
    i = iter
    (state,status) = self.getStatus()
    while state != "OK":
      i = i - 1
      if state == "ERROR":
        raise UcamError, "Bad %s status" % self.name
      if i < 1:
        raise UcamError, "Bad %s status (too many iterations)" % self.name
      (state,status) = self.getStatus()
    return

  def execute(self, xmldoc=None):
    if xmldoc!=None:
      if type(xmldoc) is InstanceType:
        xmldoc = repr(xmldoc)
      headers={"Content-Type": "text/xml"}
      r = self.post("/config",xmldoc,headers)
      self.status.parse(r.read())
      if self.status.getstatus() != "OK":
        return 0
    r = self.get('/exec')    
    self.status.parse(r.read())
    state = self.status.getstate()
    status = self.status.getstatus()
    return (state,status)

  def wait_for_idle(self):
    (state,status) = self.getStatus()
    while state=="BUSY":
      print state,status
      time.sleep(self.wait)
      (state,status) = self.getStatus()
    return (state,status)

  def isIdle(self):
    (state,status) = self.getStatus()
    if state=="BUSY":
      return 0
    return 1

  def Exec(self, CMD):
    if not CMD in self.commands:
      raise ValueError, "CMD %s not allowed" % CMD
    r = self.get('/exec?%s'%CMD)    
    self.status.parse(r.read())
    state = self.status.getstate()
    status = self.status.getstatus()
    return (state,status)

UcamError = "Ultracam Error"


class Ultracam:
  wait = 1.0
  
  def __init__(self, cameraURL="localhost:8080",
                     filesaveURL="localhost:8070",
                     debug=0):
    self.camera=userver(cameraURL, name="camera",debug=debug)
    self.filesave=userver(filesaveURL, name="filesave",debug=debug)
  
  def initialise(self):
    if not self.camera.initialise():
      return 0
    if not self.filesave.initialise():
      return 0
    return 1

  def getApplication(self,name):
    return self.camera.getApplication(name)

  def getStatus(self):
    (cstate, cstatus) = self.camera.getStatus()
    (fstate, fstatus) = self.filesave.getStatus()
    return ( cstate, cstatus, fstate, fstatus)

  def execute(self, xmldoc=None):
    if "OK" != self.camera.part_execute(xmldoc):
      self.camera.waitonbusy()
      #raise UcamError, "Bad camera status"
    if "OK" != self.filesave.part_execute(xmldoc):
      self.filesave.waitonbusy()
      #raise UcamError, "Bad filesave status"
    return self.camera.Exec("GO")
     
  def stop(self):
    return self.camera.Exec("ST")
  def RCO(self):
    return self.camera.Exec("RCO")
  def RST(self):
    return self.camera.Exec("RST")

  def isIdle(self):
    return (self.camera.isIdle() and self.filesave.isIdle())

  def getFStatus(self):
    return self.filesave.getFStatus()

  def wait_for_idle(self, sleeptime=None):
    if sleeptime == None:
      sleeptime = self.wait
    while not (self.camera.isIdle() and self.filesave.isIdle()):
      time.sleep(sleeptime)
    return self.getStatus()
