from pylab import *

# --- load and process halo catalogue from Rockstar ---

halocat = loadtxt("../rockstar/halos_0.0.ascii")
#halocat = loadtxt("../rockstar/output128/halos_0.0.ascii")

boxsize = 60.0              # comoving boxsize in Mpc / h

m200c = halocat[:,27]       # spherical overdensity mass M200c in Msun / h

ind = where(m200c > 0)[0]                                  # exclude FoF groups that for which no M200c value is found
massfunc,binedges = histogram(log10(m200c[ind]),bins=20)   # compute histogram of halo masses
binright = binedges[1:]                                    # right edge of mass bin

n_gtr_m = (massfunc.sum() - massfunc.cumsum()) / boxsize**3 # compute n(>m)

# --- load mass function from HMFcalc ---

hmfcalc = loadtxt("mVector_Our Cosmo .txt")

# --- plot results ---

fig = figure()
ax = fig.add_subplot(111)

ax.plot(log10(hmfcalc[:,0]), hmfcalc[:,8], c="red", label="Tinker mass function")

ax.plot(binright, n_gtr_m, c="blue", label="our simulation")

ax.set_yscale("log")
ax.legend()
ax.set_xlabel(r"log10(mass/($M_\odot / h$)]")
ax.set_ylabel(r"n(>m) [$h^3 / {\rm Mpc}^3$]")
ax.set_xlim(10,15)

fig.show()

fig.savefig("hmf.pdf")

