from pylab import *

import readsnap

# --- load data ---

filename = "../Gadget-2.0.7/sim/snap_005"
halocat = loadtxt("../rockstar/halos_0.0.ascii")

#filename = "../Gadget-2.0.7/sim128/snap_005"
#halocat = loadtxt("../rockstar/output128/halos_0.0.ascii")

# --- plot particles---

header = readsnap.snapshot_header(filename)

pos = readsnap.read_block(filename, "POS ") # load positions of simulation particles

fig = figure()
ax = fig.add_subplot(111,aspect="equal")

ax.plot(pos[:,0], pos[:,1], marker=",", linestyle="none", c="blue") # plot particle positions

# --- plot halos positions ---

x = halocat[:,8]
y = halocat[:,9]
z = halocat[:,10]
m200c = halocat[:,27]

ind = where(m200c > 3.0e13)[0] # select massive halos > 3e13 Msun / h
#ind = where(m200c > 1.0e12)[0] # select massive halos > 3e13 Msun / h

ax.plot(x[ind], y[ind], marker="o", linestyle="none", c="red") # plot halo positions

ax.set_xlabel("x [Mpc/h]")
ax.set_ylabel("y [Mpc/h]")

fig.show()

