from pylab import *

import readsnap

x = 0 # axis1
y = 2 # axis2

# --- load data ---

filename = "Gal11.dat"

# --- plot particles---

header = readsnap.snapshot_header(filename)

posdisk  = readsnap.read_block(filename, "POS ", parttype=2) # load positions of disk particles
posbulge = readsnap.read_block(filename, "POS ", parttype=3) # load positions of bulge particles
iddisk   = readsnap.read_block(filename, "ID  ", parttype=2) # load IDs of disk particles
idbulge  = readsnap.read_block(filename, "ID  ", parttype=3) # load IDs of bulge particles

ind1 = where(iddisk  <= 13000)[0] # select 1st galaxy
ind2 = where(iddisk  >  13000)[0] # select 2nd galaxy
ind3 = where(idbulge <= 13000)[0] # select 1st galaxy
ind4 = where(idbulge >  13000)[0] # select 2nd galaxy

fig = figure()
ax = fig.add_subplot(111,aspect="equal")

ax.plot(posdisk[ind1,x],  posdisk[ind1,y],  marker=",", linestyle="none", c="blue")
ax.plot(posdisk[ind2,x],  posdisk[ind2,y],  marker=",", linestyle="none", c="red")
ax.plot(posbulge[ind3,x], posbulge[ind3,y], marker=",", linestyle="none", c="yellow")
ax.plot(posbulge[ind4,x], posbulge[ind4,y], marker=",", linestyle="none", c="green")

# --- plot halos positions ---
p1 = vstack((posdisk[ind1],posbulge[ind3]))
p2 = vstack((posdisk[ind2],posbulge[ind4]))

x1 = p1[:,x]
y1 = p1[:,y]
x2 = p2[:,x]
y2 = p2[:,y]
cmx1 = sum(x1)/len(x1)
cmy1 = sum(y1)/len(y1)
cmx2 = sum(x2)/len(x2)
cmy2 = sum(y2)/len(y2)
ax.plot(cmx1, cmy1, marker="x", linestyle="none", c="black")
ax.plot(cmx2, cmy2, marker="x", linestyle="none", c="black")

ax.set_xlabel("x / kpc")
ax.set_ylabel("y / kpc")
ax.set_xlim(-130., 130.)
ax.set_ylim(-130., 130.)

fig.show()
