from pylab import *

import readsnap
import matplotlib.pyplot as plt
import time

start = 0
end   = 20

nsnap = end-start+1
t  = 2.0*arange(nsnap)/(nsnap-1)
d  = zeros(nsnap)

for i in range(start,end+1):

    # --- load data ---
    filename = '../Gadget-2.0.7/Output/Gal11/snapshot_%(number)03d' %{"number":i}
    header = readsnap.snapshot_header(filename)

    posdisk  = readsnap.read_block(filename, "POS ", parttype=2) # load positions of disk particles
    posbulge = readsnap.read_block(filename, "POS ", parttype=3) # load positions of bulge particles
    iddisk   = readsnap.read_block(filename, "ID  ", parttype=2) # load ids of disk particles
    idbulge  = readsnap.read_block(filename, "ID  ", parttype=3) # load ids of bulge particles

    ind1 = where(iddisk  <= 13000)[0] # select 1st galaxy
    ind2 = where(iddisk  >  13000)[0] # select 2nd galaxy
    ind3 = where(idbulge <= 13000)[0] # select 1st galaxy
    ind4 = where(idbulge >  13000)[0] # select 2nd galaxy

    posdisk1  = posdisk[ind1]
    posdisk2  = posdisk[ind2]
    posbulge1 = posbulge[ind3]
    posbulge2 = posbulge[ind4]

    pos1 = vstack((posdisk1,posbulge1))
    pos2 = vstack((posdisk2,posbulge2))

    l1 = len(pos1)
    l2 = len(pos2)
    x1 = pos1[:,0]
    y1 = pos1[:,1]
    z1 = pos1[:,2]
    x2 = pos2[:,0]
    y2 = pos2[:,1]
    z2 = pos2[:,2]

    cmx1 = sum(x1)/l1
    cmy1 = sum(y1)/l1
    cmz1 = sum(z1)/l1
    cmx2 = sum(x2)/l2
    cmy2 = sum(y2)/l2
    cmz2 = sum(z2)/l2

    dx = sqrt((cmx1-cmx2)*(cmx1-cmx2))
    dy = sqrt((cmy1-cmy2)*(cmy1-cmy2))
    dz = sqrt((cmz1-cmz2)*(cmz1-cmz2))

    d[i] = sqrt(dx*dx+dy*dy+dz*dz)

    print t[i], d[i]


fig = plt.figure()
plt.plot(t, d, 'b-') 
plt.axis([0., 2.0, 0., 200.])
plt.xlabel('t / Gyr')
plt.ylabel('d / kpc')
plt.show()
