from pylab import *
from time import sleep

from hydro_1D import *

ncells_all = 104

q = zeros(ncells_all,dtype=float64)
q[12:52] = 1.0

q_initial = q.copy()

u = ones(ncells_all,dtype=float64)

dx = 1.0
dt = 0.2

# ----- change advection scheme here -----
fluxlim="donor-cell"
#fluxlim="Lax-Wendroff"
#fluxlim="Fromm"
#fluxlim="superbee"
# -----

boundary="periodic"

nghost = 2

nsteps = 500
  
fig = figure()
ax = fig.add_subplot(111)

set_ghosts(q,nghost,boundary)

ax.plot(arange(ncells_all),q,c="black",ls=":")
q_curve, = ax.plot(arange(ncells_all),q,c="red")

ax.set_ylim(-0.1,1.5)
fig.show()

print "press Enter"
raw_input()

for i in arange(nsteps):
  print "doing step", i
  
  #sleep(0.01)
  
  set_ghosts(q,nghost,boundary)
  set_ghosts(u,nghost,boundary)
  
  advect(q, u, dx, dt, fluxlim, nghost)

  q_curve.set_ydata(q)
  
  fig.canvas.draw()
  
  

