from pylab import *
 
 
def advect (q, u, dx, dt, fluxlim, nghost):
  # q conserved quantity
  # u advection velocity
  # dx cell size
  # dt time step
  # fluxlim type of fluxlimiter
  # first and last nghost cells are ghost cells
 
  ncells_all = q.size
  ncells = ncells_all - 2*nghost 
   
  assert nghost >= 1
  assert ncells >= 1 
  assert u.size == ncells_all
  assert dx > 0
  assert dt > 0
   
  dqi = q[1:] - q[:-1]        # qauntities *i are defined on the cell interfaces
  ui = 0.5*(u[1:] + u[:-1])
  
  if fluxlim == "donor-cell":
    phi = zeros_like(dqi)
    
  elif fluxlim == "Lax-Wendroff":
    phi = ones_like(dqi)
    
  elif fluxlim in ["Fromm","superbee"]:
    assert nghost >= 2    
    ri = zeros_like(dqi)
    
    ind = where((ui[nghost-1:nghost+ncells]>0) & (dqi[nghost-1:nghost+ncells]!=0))[0]
    ri[nghost-1:nghost+ncells][ind] = dqi[nghost-2:nghost+ncells-1][ind] / dqi[nghost-1:nghost+ncells][ind]
    
    ind = where((ui[nghost-1:nghost+ncells]<0) & (dqi[nghost-1:nghost+ncells]!=0))[0]
    ri[nghost-1:nghost+ncells][ind] = dqi[nghost:nghost+ncells+1][ind] / dqi[nghost-1:nghost+ncells][ind]
  
    if fluxlim == "Fromm":
      phi = 0.5*(1.0+ri)
    elif fluxlim == "superbee":
      phi = maximum(0,maximum(minimum(1,2*ri),minimum(2,ri)))
    else:
      assert False
  
  else:
    assert False
    
  fi = 0.5*ui*((1+sign(ui))*q[:-1] + (1-sign(ui))*q[1:]) + 0.5*absolute(ui)*(1.0 - absolute(ui)*dt/dx)*phi*dqi  # fluxes
  
  q[nghost:nghost+ncells] += dt/dx * (fi[nghost-1:nghost-1+ncells] - fi[nghost:nghost+ncells])


def set_ghosts(x,nghost,boundary): # sets values of ghost cells according to specified baundary contitions
  ncells_all = x.size
  ncells = ncells_all - 2*nghost
  
  if boundary == "periodic":
    x[:nghost] = x[ncells:ncells+nghost]
    x[-nghost:] = x[nghost:2*nghost]
  
  else:
    assert False
    
    