# IRAF script -- csubqsky.cl
#	
#   function:  to subtract the quad-sky
#               input: from the output of ccmkimg or ccmkobj, ccmkqsky
#
# programmer: sjchan (nov 97)
#  history:   nov 97 --  created: ccsubqsky.cl
#             23jan98 -- renamed to csubqsky.cl
#             4June98 -- get chip number from the skyfile
#        

procedure csubqsky(file_in, sky_list)

string	file_in   {"",prompt="(@List/of lists) of Input images (quads or chips)",mode="ql"}
string  sky_list  {"",prompt="@List of sky images (quads or chips)", mode="ql"}

struct  *filist, *filist2

begin
        string  ftmpi     #i input file list
        string  skylist  #i a file containing list of skys
        string  skyfile  #i individual sky frame
        string  ifile     #i the final version of input file 
        string  fileout   #i a file containing the output list filename
        string  quadin    #i input for csubsky
        string  filein    #i (dummy variable)final input verion for csubsky 
        string  csubqskylog   #o logfile
        string  templog    # dummy variable (temporary logfile)
        string  skytemp   # dummy variable (final version of input sky string
        int     leni       # length of input file list string
        int     lentemp    # dummy variable (length of input image)
        int     ic         # quad-counter
        int     idrop      # the location of the last "." of the input image
        string  prechar    # the pre-character of the output filenames
        string  s1
        int     idash      # dummy counter 
        string  ss3        # dummy variables
        string  schip      # chip number in string
        string  quadin2

      #  Get the rest of the parameters

        ftmpi = file_in
        skylist = sky_list
        csubqskylog = "csubqsky.log"
        templog = "csubsky.log"
        prechar = "s"

        cache imgets     # need this action due to a bug in imgets
        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
         {
           ifile = substr(ftmpi, 2, leni)
           fileout = prechar//ifile
         }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           fileout = "csubqsky.in"
         }

        leni = strlen(skylist)
        if (stridx(skylist, "@") == 1)
           skytemp = substr(skylist, 2, leni)
        else
         {
           skytemp = mktemp("fin")
           sections(skylist, option="fullname", > skytemp)
         }

     # Check existence of output files

        if (access(csubqskylog))
           delete(csubqskylog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")


      # Read the list of input  list filename
        ic = 0
        lentemp = 1
        filist = ""; filist2 = ""
        filist = ifile; filist2 = skytemp
        while ( (fscan(filist, quadin) != EOF) &&
                (fscan(filist2, skyfile) != EOF) )
         {
           quadin2 = quadin
           ic += 1     # count quad
                lentemp = strlen(quadin)
         # To locate the last "." in the string
               _locate(quadin, ".")
               idrop = _locate.value
               s1 = substr(quadin, idrop+1, lentemp)
               if ((s1 != "fits") && (s1 != "fit") && (s1 != "imh"))
                 {
                   imgets(skyfile,  param="chip")
                   schip = imgets.value
                   _locate(quadin, "_")
                   idash = _locate.value
                   ss3 = substr(quadin, 1, idash)
                   if ( (schip == "") || (schip == "0") || (schip == "/") )
                     filein = "@"//quadin2
                   else
                     {
                        quadin2 = ss3//"c0"//schip//"."//s1
                        if (access(quadin2))
                           delete(quadin2, ver-, >& "dev$null")

                        unlearn rename
                        rename(quadin, quadin2)
                        filein = "@"//quadin2
                     }
                 } # this brace is from if block (s1 !=fits,fit,imh)
               else
                 filein = quadin 
      
               print(prechar//quadin2, >> fileout)   # collect the output filenames
                                                # in filout
                print("", >> csubqskylog)
                print("Chip or Quad ", schip, >> csubqskylog )
                csubsky(filein, skyfile)
                unlearn type
                type (templog, >> csubqskylog)
                print("=========================================", >> csubqskylog)

         }    # this brace is from while (filist, quadin)

         # close the files and cleaning up
           filist = ""  ; filist2 = "" 
           if (stridx(ftmpi, "@") != 1)
             delete(ifile, ver-, >& "dev$null")
           if (stridx(skylist, "@") != 1)
             {
              delete(skytemp, ver-, >& "dev$null")
              print("")
              print("Remember to rename "//fileout//" if you wish to use it later.")
             }
          
	  print ("CSUBQSKY done.")

end

