# IRAF script -- csubqdark.cl
#	
#   function:  to subtract the quad-darks
#               input: from the output of cmkimg, cmkqdark
#
# programmer: sjchan 
#        history: nov98 -- created
#                 2july98 -- modified (scaling factor option)
#        

procedure csubqdark(file_in, dark_list, scalfac)

string	file_in   {"",prompt="@List  of Input images (chips/quads)",mode="ql"}
string  dark_list  {"",prompt="@List of darks (chips/quads)", mode="ql"}
bool    scalfac    {yes, prompt="Using exposure time to scale the darks", mode="ql"}
string  expcheck      {prompt="exposure time indicator in the header"}


struct  *filist, *filist2

begin
        string  ftmpi     #i input file list
        string  darklist  #i a file containing list of darks
        bool    scalfac1  #i the scaling factor
        string  darkfile  #i individual dark frame
        string  ifile     #i the final version of input file 
        string  fileout   #i a file containing the output list filename
        string  quadin    #i input for csubdark
        string  filein    #i (dummy variable)final input verion for csubdark 
        string  csubqdarklog   #o logfile
        string  templog    # dummy variable (temporary logfile)
        string  darktemp   # dummy variable (final version of input dark string
        int     leni       # length of input file list string
        int     lentemp    # dummy variable (length of input image)
        int     ic         # quad-counter
        int     idrop      # the location of the last "." of the input image
        string  s1      
        string  tmpcheck   # the exposure time indicator passing from
                            # csubdark     


      #  Get the rest of the parameters

        ftmpi = file_in
        darklist = dark_list
        scalfac1 = scalfac
        csubqdarklog = "csubqdark.log"
        templog = "csubdark.log"
        tmpcheck = "G"
        expcheck = "G"
 
        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
         {
           ifile = substr(ftmpi, 2, leni)
           fileout = "d"//ifile
         }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           fileout = "csubqdark.in"
         }

        leni = strlen(darklist)
        if (stridx(darklist, "@") == 1)
           darktemp = substr(darklist, 2, leni)
        else
         {
           darktemp = mktemp("fin")
           sections(darklist, option="fullname", > darktemp)
         }

     # Check existence of output files

        if (access(csubqdarklog))
           delete(csubqdarklog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")


      # Read the list of input  list filename
        ic = 0
        lentemp = 1
        filist = ""; filist2 = ""
        filist = ifile; filist2 = darktemp
        while ( (fscan(filist, quadin) != EOF) &&
                (fscan(filist2, darkfile) != EOF) )
         {
           ic += 1     # count quad
                lentemp = strlen(quadin)
         # To locate the last "." in the string
               _locate(quadin, ".")
               idrop = _locate.value
               s1 = substr(quadin, idrop+1, lentemp)
               if ((s1 != "fits") && (s1 != "fit") && (s1 != "imh"))
                 filein = "@"//quadin
               else
                 filein = quadin 

               print("d"//quadin, >> fileout)   # collect the output filenames
                                                # in filout
                print("", >> csubqdarklog)
                print("Chip or Quad ", ic, >> csubqdarklog)
                unlearn csubdark
                csubdark(filein, darkfile, scalfac1)
                unlearn type
                type(templog, >> csubqdarklog)
                tmpcheck = csubdark.check
                print("=========================================", >> csubqdarklog)
                if (tmpcheck == "B")
                  {
                    filist = ""; filist2 = ""  #close the files
                    if (stridx(ftmpi, "@") != 1)
                       delete(ifile, ver-, >& "dev$null")
                    if (stridx(darklist, "@") != 1)
                       {
                         delete(darktemp, ver-, >& "dev$null")
                         print("")
                         print("Remember to rename ", fileout, " if you wish to use it later")
                       }
                    expcheck = "B"
                    bye
                  } # this brace is from if-block (tempcheck == B)
                
         }    # this brace is from while (filist, quadin)

         # close the files and cleaning up
           filist = ""  ; filist2 = "" 
           if (stridx(ftmpi, "@") != 1)
             delete(ifile, ver-, >& "dev$null")
           if (stridx(darklist, "@") != 1)
             {
              delete(darktemp, ver-, >& "dev$null")
              print("")
              print("Remember to rename ", fileout, " if you wish to use it later")
             }
          print("CSUBQDARK done.")
          # beep; beep; beep

end

