# IRAF script -- cmksky.cl
#
#   function:  to make a combined sky frame (project=no in imcombine)
#	
# programmer: sjchan 
#    history: 
#      created: feb97: irsky.cl for iacirc package
#      modified oc97, nov97  (rename to ccmksky.cl, and then cmksky.cl)
#      modified: 6aug98 -- add an option to use pset 
#      modified: 10aug98 -- an option to use BPM
#           (masktype is set "goodvalue", if no mask image associated with it,
#             then the mask values are taken as all zeros, "none" case)
#      modified: 25aug98 -- given user a choose to use BPM (not automatic)
#		26april99 - mhoenig: changed imcombine to use a list of
#			     (inverse) median values from GSTAT when scaling,
#			     instead of imcombine's built-in "scale=median"
#			     routine. Since the latter uses IMSTAT's 
#			     not-really-a-median, we hope to get a better-scaled
#			     sky image by using the new method.
#		27april99 - mhoenig: finalized this option, adding in a scale
# 			     factor so that the signal level is similar to the
#			     one in the original images (like with the
#			     scale="median" option)


procedure cmksky(frame_in, frame_out)

string	frame_in   {"",prompt="(@List of/ *.fits) Input images",mode="ql"}
string  frame_out  {"",prompt="Output combined sky image",mode="ql"}
int     n_start    {1, prompt="the starting fold number for imcombine", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkskypar {prompt="Imcombine parameters to make sky images"}
bool    usebpm   {no, prompt="Use bad pixel map when making sky", mode="ql"}

string  *filist

begin
        string  ftmpi                # List of input images
        string  frameout             # Output combined sky image
        int     nstart               # the starting fold number for imcombine
        bool    useropt1             # user chance to choose IMCOMBINE paras
        bool    usebpm1              # use bad pixel map when making sky
        string  frametemp            # Input image
        string  ifile,ifile1, ofile  # final version of input and output
        string  cmkskylog              # logfile
        string  indc                 # indicator
        int     nl, nh               # nlow and nhigh (reject=minmax in 
                                     #    imcombine
        int     icount, ic           # number of images in input image list
        string  s1, s2               # dummy variables
        int i
	
	file midplist		     # variables for creating list of GSTAT
	string imgname		     #  medians.
	real avg		     # mean of medians
	real median		     # median value in file
	file scalelist		     # list of scaling factors
	

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow


        cache imgets   # need this action due to a bug in imgets

        #  Get the rest of the parameters
        ftmpi    =  frame_in
        frameout =  frame_out
        nstart   =  n_start
        useropt1 =  useropt
        usebpm1  =  usebpm
        cmkskylog="cmksky.log"
        ind="C"       # dummy definition
        icount = 0; ic = 0
        ifile="dummy1"
        ifile1 = "dummy1a"
        ofile="dummy2"
        nh=0
        nl=0

        #IMCOMBINE parameters

        p_sigma  = mkskypar.c_sigma
        p_plfile = mkskypar.c_plfile
        p_combine = mkskypar.c_combine
        p_reject = mkskypar.c_reject
        p_masktyp = mkskypar.c_masktyp
        p_maskval = mkskypar.c_maskval
        p_blank = mkskypar.c_blank
        p_scale = mkskypar.c_scale
        p_zero = mkskypar.c_zero
        p_weight = mkskypar.c_weight
        p_statsec = mkskypar.c_statsec
        p_expname = mkskypar.c_expname
        p_lthresh = mkskypar.c_lthresh
        p_hthresh = mkskypar.c_hthresh
        p_nlow = mkskypar.c_nlow
        p_nhigh = mkskypar.c_nhigh
        p_nkeep = mkskypar.c_nkeep
        p_lsigma = mkskypar.c_lsigma
        p_hsigma = mkskypar.c_hsigma
        p_rdnoise = mkskypar.c_rdnoise
        p_gain = mkskypar.c_gain
        p_sigscale = mkskypar.c_sigscale
        p_pclip = mkskypar.c_pclip
        p_grow = mkskypar.c_grow

		
        #  Check the existence of the logfile
           if (access(cmkskylog))
             delete(cmkskylog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ifile1))
             delete(ifile1, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
           if (access(frameout))
             delete(frameout, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(ftmpi, indc, ifile, ofile)
          
        # Read the file 'ifile' to count the number of files

        filist = ""; filist = ifile
        while (fscan(filist,frametemp) !=EOF)
         {
          ic += 1
            if (ic >= nstart)
              {
                 icount += 1
                 print(frametemp, >> ifile1)
              }
         }  # this is from the while loop (filist, frametemp)
         filist = "" #close the file

        print("No. of images for sky creation is: ", icount)
         if (icount <= 2)
           {
            nh = 0
            nl = 0
           }
         else if ((icount > 2)  && (icount < 5))
           {
            nh = 1
            nl = 1
           }
         else if ((icount >= 5) && (icount < 10))
          { 
            nh = 2
            nl = 1
          }
         else if ((icount >= 10) && (icount < 20))
          {
            nh = 5
            nl = 3
          }
         else if (icount < 30) 
         {
            nh = 10
            nl = 5
         }
         else if (icount < 40)
         {
            nh = 13
            nl = 10
         }
         else if (icount < 45)
         {
            nh = 20
            nl = 15
         }
         else if (icount < 50)
         { 
            nh = 20
            nl = 20
         }
         else if (icount < 60)
         {
            nh = 25
            nl = 20
         }
         else if (icount < 65)
         {
            nh = 30
            nl = 25 
         }
         else if (icount < 70)
         {
            nh = 30
            nl = 30 
         } 
         else if (icount < 75)
         {
             nh = 35
             nl = 30
         }
         else if (icount < 80)
         { 
             nh = 35
             nl = 35
         }
         else
         {   
             nh = 40
             nl = 35 
         }
        
        if (!useropt1)
          {
            unlearn imcombine
            filist = ""; filist = ifile
            while( fscan(filist, s1) != EOF)
              {
                imgets(s1, param= "BPM", >& 'dev$null')
                s2 = imgets.value
                goto lab
              }

           lab:
           filist = ""

           if (s2 != "0") #keyword BPM in the header
              imcombine.masktype = "goodvalue"
           else
              imcombine.masktype = "none"

      # final judgement to use bpm
           if (usebpm1)
              imcombine.masktype = "none"

           if ((usebpm1 == yes) && (s2 == "0"))
             {
               print("")
               print("Cannot find BPM keyword in the image header")
               print("You must use HEDIT to input the location of BPM")
               print("Now, using default option: Not use BPM")
               print("")
               imcombine.masktype = "none"
             } # this brace is from if-block (!usebpm1) && (s2 == 0))    

           # get image medians for scaling from GSTAT, and write them out to a
	   # file:
	   
	   midplist=mktemp("midpoints")//".list"
	   list=ifile1
	   while (fscan(list, imgname) != EOF)
	   	{
		gstatistics(imgname, fields="midpt", >& "dev$null")
		print (gstpar.midpt, >> midplist)
		}
	   
	   # get mean of medians...
	   
	   average (< midplist) | scan (s1)
	   avg=real(s1)
	   
	   # ...and obtain scaling factor from the ratio of the above two.
	   
	   scalelist=mktemp("scalings")//".list"
	   list=midplist
	   while (fscan(list, median) != EOF)
	   	{
		print (avg/median, >> scalelist)
		}
	   
	   imcombine("@"//ifile1,frameout,combine="median", reject="minmax",
              project=no, outtype="real", offset="none", 
              maskvalue=0, blank=0, scale="@"//scalelist, zero="none", weight="none",
              expname="", statsec="", nlow=nl, nhigh=nh, logfile=cmkskylog)

          }
         else
          {

            imcombine("@"//ifile1, frameout, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets="none", masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=cmkskylog)
          }

        delete (ofile//","//ifile, ver-, >& "dev$null")
	filist=""

        delete (midplist, ver-, >& "dev$null")
        delete (scalelist, ver-, >& "dev$null")

	print ("CMKSKY done.")


end

