# IRAF script -- cmkrrrimg.cl
#	
#   function:  to provide  'real' images from Read-Reset-Redad images 
#               given from a set of RRR images.
#                 
#   stage: no need
#
# programmer: sjchan (nov 97)
# history:    orignal name - ccmkimg.cl
#             23jan98: cmkrrrimg.cl
#

procedure cmkrrrimg(frame_in, tot_fold, pix_type, calc_type, answer)

string	frame_in   {"",prompt="(@List/*.fits or .imh) of Input images",mode="ql"}
int     tot_fold  {min=2, prompt="total number of folds for a fixed-pos obs",mode="ql"}
string  pix_type {"real", prompt="pixtype of output images", mode="ql"}
string  calc_type {"real", prompt="calctype for IMARITH operation", mode="ql"}
bool    answer    {yes, prompt="Sort the input list?"}

struct  *filist1, *filist2, *folist
struct  *lilist, *lolist



begin
        string  ftmpi      # input file list
        int     foldnum    # total number of folds for a fixed-pos observation
        string  ofile     # a file containing fold output filenames
        string  ifile     # the final version of input file list
        string  foldin    # a file containing fold input filenames
        string  framein     # input file list containing input image
        string  frameout    # output file list containing output images
        string  tframein[2] # dummy variables
        string  fin1, fin2  # input images pair for subtraction
        string  fout        # output images
        string  fin2sec, fin1sec
        string  cmkrrrimglog  # logfile
        int     icounter    # counter
        int     ic, ic2, ic3  # dummy counters
        int     leni       # length of input file list string
        int     tfoldno    # dummy variables tfoldno = foldnum - 1
        bool    answer1    # ask sort the input list
        string  ind        # indicator"
        string  pixty      # pixtype of output images
        string  calcty     # calcuating type for IMARITH

      #  Get the rest of the parameters

        ftmpi = frame_in
        foldnum=tot_fold
        pixty = pix_type
        calcty = calc_type
        answer1=answer
        ofile = "dd_ofold.in"
        foldin = "dummyfold"
        cmkrrrimglog = "cmkrrrimg.log"
        tfoldno = foldnum - 1
        ind = "RS"   # Real signal processing
        

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
          {
           ifile = substr(ftmpi, 2, leni)
           ofile = "dd_"//ifile
          }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           ofile = "dd_ofold.in"   
         }

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-) 
        if (access(cmkrrrimglog))
          delete(cmkrrrimglog, ver-)


      # Sort the input file list (increaing order in sequence number)
      #  if user wishes (if no: the input file has been SORTED
        if (answer1)
            _finsort(ifile)

      # Make fold input file lists and fold output file lists
        _mkllist(ifile, foldnum, foldin, ofile)

      # Read the list of input list  and the list of output list
        ic = 0; ic2 = 0; ic3 = 0

        lilist = ""; lolist = ""
        lilist = foldin; lolist = ofile
        while ( (fscan(lilist, framein) != EOF))
         {
           ic += 1
           if (ic == 1) 
             {
               tframein[ic] = framein
               goto lab   # lab is a label, need to read once more in this file
             }
           else if (ic == 2)
               tframein[2] = framein
           else 
             {
                tframein[1] = tframein[2]
                tframein[2] = framein
             }

           while ( (fscan(lolist, frameout) !=EOF))
            {
               ic2 += 1   # dummy counter
               filist1 = ""; filist2 = ""; folist = ""
               filist1 = tframein[1]; filist2 = tframein[2]; folist=frameout
               while( (fscan(filist1, fin1) !=EOF) && 
                      (fscan(filist2, fin2) !=EOF) &&
                      (fscan(folist, fout) !=EOF) )
                {
                 # Find out the right section for each half image and make
                 # the suitable pair for subtraction
                  _mksec(fin1)
                  fin2sec = fin2//_mksec.sec1
                  fin1sec = fin1//_mksec.sec2
               
                  if (access(fout))
                      imdelete(fout, ver-)    

                 ic3 = ic - 1     # record the current fold to the header

              # Provide the real signal image and update the header     
                 unlearn imarith
                 imarith(operand1=fin2sec, op="-", operand2=fin1sec,
                    result=fout,  pixtype=pixty, calctype=calcty,
                    verbose=yes, >> cmkrrrimglog)
                  hedit(fout, field="fold", value=ic3, add+, del-, ver-,
                   update+, show-)
                  hedit(fout, field="foldnum", value=tfoldno, add+, del-, ver-,
                    update+, show-)
       #           hedit(fout, field="rsflag", 
       #            value=ind, add+, del-, ver-, update+, show-)
       #
                } # this brace in from the while block(filist1, filst2, folist)
            goto lab   # 
          }   # from while block (frameout)
          lab:       # lab is from if else block (ic == 1) 
                  # and also from the while block (lolist) 
      
         }   # this brace is from while block (lilist, framein)

         # close the files and cleaning up
 
         lilist = ""; lolist = ""
          filist1 = ""; filist2 = ""
          folist = ""

          if (access(foldin))
            {
             # delete infold* files which are created from _mkllist.cl
             delete("@"//foldin, ver-)    
             delete(foldin, ver-) 
            }
          if (access(ofile))
            {
              print("")
              print("You need to rename ",ofile," and outfold* if you wish to use them later")
              print("")
            }

          print("   << ========= CMKRRRIMG DONE =========== >>")
          beep; beep; beep

end

