# IRAF script -- cmkqsky.cl
#	
#   function:  to make the quad-sky (or chip-sky)
#               input: from the output of cmkimg, cmkrrrimg (cmkquad)
#               output: prehead: "sky_q"
#
#   stage: changing
#
# programmer: sjchan 
#   history:  nov 97   -- created: ccmkqsky (bad approach)
#             dec97    -- modified: at the INT (simple comments)
#                                    can only be used for a few cases 
#             23jan98  -- renamed to cmkqsky.cl  
#             9feb98   -- modified: general approach 
#                           (ndr case: list of foldlists
#             19mar98  -- put chip
#             7aug98   -- add an option to let user have a chance to choose
#                          one's values of IMCOMBINE parameters
#             25aug98 -- add a choose to user in order to use BPM.
#      

procedure cmkqsky(file_in, file_out, pre_head, startfold, tot_quad, useropt, usebpm)

string  file_in {"@rcxxxxsky.in",prompt="@The input list of lists to produce list of sky images", mode="ql"}
string  file_out  {"",prompt="File name containing output sky list", mode="ql"}
string  pre_head {"skyj_c",prompt="The prehead of the output sky frames",mode="ql"}
string  startfold  {"1", prompt="The start #th fold for combination", mode="ql"}
int     tot_quad  {16 , prompt="Total quadrant(or chip) numbers", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkskypar {prompt="Imcombine parameters to make sky images"}
bool    usebpm   {no, prompt="Use bad pixel map when making sky"}

struct  *filist

begin

        string  fileout     #o a file containing  output sky filenames
        string  filein      #i the input list string of lists individual images
        string  ftmpi       #i temporary input list of lists individual images
        string  ifile       #i the final version of input list of lists images
                             # a file contains each fold list 
        string  quadin      #i input image
        string  frameout    #o output sky name
        string  cmkqskylog   #o logfile
        string  prehead     # prehead of the output sky files
        string  startfold1  #i the start fold-th for combination 
        int     ic         # counters
        int     iq         # dummy variables
        string  siq        # dummy variable 'iq' in string
        string  sic        # counter in string
        int     icc        # dummy counter
        int     leni       # length of input file list string
        int     totquad    # total quadrant numbers
        bool    useropt1   # User option to input IMCOMBINE parameters
        bool    usebpm1              # use bad pixel map when making sky
        string  ext        # dummy variable (extension of the output flats)
        string  templog    # dummy variable (temporary logfile)
        string  tflin      # temporary files of quadrant-images from
                            # _mkqlist
        string  filesky    # the final version of input images to make sky
        string  schip      # chip number in string   
        string  frameout2  #o output sky name (get the chip number from header)

      #  Get the rest of the parameters

        filein  = file_in
        fileout = file_out
        prehead = pre_head
        startfold1 = startfold
        totquad = tot_quad
        useropt1 = useropt
        usebpm1  = usebpm
        cmkqskylog = "cmkqsky.log"
        templog = "cmksky.log"
        ext = ".fits"
        schip = "1"

        cache imgets     # need this action due to a bug in imgets
     # Find out the suitable input option
        leni = strlen(filein)
        if (stridx(filein, "@") == 1)
           ftmpi = substr(filein, 2, leni)
        else
         {
           ftmpi = mktemp("fin")
           sections(ftmpi, option="fullname", > ftmpi)
         }

     # Check existence of output files

        if (access(cmkqskylog))
           delete(cmkqskylog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

        # print("")
        # print("=====Making lists of images to produce sky-images ======")
      # Read the main list (lists of images)
        icc = 0
        filist = ""; filist = ftmpi   # main list -- list of lists
        while (fscan(filist,ifile) !=EOF)
          {  # ifile - a file containing dithering list (different run number)
               #  e.g.: r1502_r1320.in, r1502_r1321.in, ....
            icc += 1

            # print(ifile)
                # make lists of quadrant-images
                  # divided into 16 files quad_1.in, ..., quad_16.in
                _mkqlist(ifile) 
      
                # make another 16 files which first line is from 'startfold1'
                for (iq = 1; iq <= totquad; iq += 1)
                  {
                     siq = str(iq)
                     tflin = "quad_"//siq//".in"
                     filesky = "skyquad"//siq//".in"
                     if (icc == 1)
                       {
                         if (access(filesky))
                            delete(filesky, ver-, >& "dev$null")
                       } # this brace is from if block icc == 1


                     unlearn fields
                     fields(tflin, "1", lines=startfold1//"-", >> filesky)
         
                      # delete tflin
                     delete(tflin, ver-, >& "dev$null")

                   } # this brace is frome for fold (iq=1, totquad)
            }  # this brace is from while block (filist, ifile)
           filist = "" # close the file
      
      # print("")
      # print ("Now we are ready to make sky-images")
      # print("")

      # Now, we are ready to make sky-images
         for (ic = 1; ic <= totquad; ic += 1)
             {
            # Make the temporary output sky names 
                _sdigit(ic, 2)
                sic = _sdigit.value
                frameout = prehead//sic//"tmp"//ext

      # Check the existence of the file "frameout"
              if (access(frameout))
                 delete(frameout, ver-, >& "dev$null")

              print("", >> cmkqskylog)
              print("Chip or Quad ", ic, >> cmkqskylog )
              print("Chip or quadrant: ", ic)
	      # print("")
              sic = str(ic)
              filesky = "skyquad"//sic//".in"
              unlearn cmksky
              cmksky("@"//filesky, frameout, 1, useropt1, usebpm1)

              unlearn type
              type (templog, >> cmkqskylog)

          # Rename the final output skyimg 
              imgets(frameout, param="chip")
              schip = imgets.value
              if ( (schip == "") || (schip == "0") || (schip == "/") )
                   frameout2 = prehead//sic//ext
               else
                   frameout2 = prehead//"0"//schip//ext
 
                 if (access(frameout2))
                      delete(frameout2, ver-, >& "dev$null")

                  print("", >> cmkqskylog)
                  print("Need to rename the output skyimg corresponding the right chip number or proper name", >> cmkqskylog)
                  imrename(frameout, frameout2, ver+, >> cmkqskylog)
              print(frameout2, >> fileout) # put the final skyname into a list

              print("=========================================", >> cmkqskylog)
             
              delete(filesky, ver-, >& "dev$null")
           }   # this brace is from for block (ic =1, totquad)


	  print ("CMKQSKY done.")

end

