# IRAF script -- cmkqmsnflat.cl
#	
#   function:  to make the quad-nflat
#               input: from the output of ccmkimg
#               output: prehead: "nflat_q"
#
# programmer: sjchan (nov 97)
#        

procedure cmkqmsnflat(file_in, file_out, pre_head, startfold, useropt)

string	file_in   {"",prompt="(@List of lists) of Input quad- or chip- flat images",mode="ql"}
string  file_out  {"",prompt="File name containing output nflat list", mode="ql"}
string  pre_head {"nflat_c",prompt="The prehead of the output nflat frames",mode="ql"}
int     startfold   {1, prompt="The start #th fold for combination", mode="ql"}
bool    useropt   {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset mkskypar {prompt="Imcombine parameters to make sky flat images"}

struct  *filist

begin
        string  ftmpi       #i input file list
        string  fileout     #o a file containing  output nflat filenames
        string  ifile       #i the final version of input file 
        string  filein      #i the input list of list individual nflat
        string  quadin      #i input image
        string  frameout    #o output nflat name
        string  cmkqmsnflatlog   #o logfile
        string  prehead     # prehead of the output nflat files
        int     startfold1  #i the start fold-th for combination 
        bool    useropt1   # User option to input IMCOMBINE parameters        
        int     ic, ic2     # counters
        int     leni       # length of input file list string
        string  ext        # dummy variable (extension of the output flats)
        string  templog    # dummy variable (temporary logfile)


      #  Get the rest of the parameters

        ftmpi = file_in
        fileout = file_out
        prehead = pre_head
        startfold1 = startfold
        useropt1 = useropt
        cmkqmsnflatlog = "cmkqmsnflat.log"
        templog = "cmkmsnflat.log"
        filein = "quadlist.in"
        ext = ".fits"

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

     # Check existence of output files

        if (access(cmkqmsnflatlog))
           delete(cmkqmsnflatlog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

      # Make quad input lists, the output file called "quadlist.in" which
      #  contains the list of quad_file names. Each quad_file contains
      #  list of fold files for quad#. 

        _mkqlist(ifile)

      # Read the list of input flat list filename
        ic = 0; ic2 = 0
        filist = ""
        filist = filein    # filein = quadlist.in
        while ( (fscan(filist, quadin) != EOF))
         {
           ic += 1
      # Make the output nflat names and put them into a list 
              frameout = prehead//str(ic)//ext
              print (frameout, >> fileout)

        # Check the existence of the file "frameout"
              if (access(frameout))
                 delete(frameout, ver-, >& "dev$null")

                print("", >> cmkqmsnflatlog)
                print("Quad or Chip", ic, >> cmkqmsnflatlog )
                print("Quad or Chip", ic)
                cmkmsnflat("@"//quadin, frameout, startfold1, useropt1)
                unlearn type
                type (templog, >> cmkqmsnflatlog)
                print("=========================================", >> cmkqmsnflatlog)

         }    # this brace is from while (filist, quadin)

         # close the files and cleaning up
           filist = ""   
           if (stridx(ftmpi, "@") != 1)
             delete(ifile, ver-, >& "dev$null")

          print("   << ========= CMKQMSNFLAT DONE =========== >>")
          beep; beep; beep

end

