# IRAF script -- cmkqdnflat.cl
#	
#   function:  to make the quad-nflat
#               input: from the output of ccmkimg
#               output: prehead: "nflat_q"
#
# programmer: sjchan (nov 97)
#            created: nov97
#            modified: 29apr98: two input lists: for bflats and dflats
#                               output: a list of normalized flats
#                      27may98: run cmkdnflat
#                      11aug98: to support to use pset (cmkdnflat)
#        

procedure cmkqdnflat(file_inb, file_ind, file_out, pre_head, startfold, useropt)

string  file_inb {"@bflatlist.in",prompt="(@List of lists) Bflats (Quads/Chips)",mode="ql"}
string  file_ind {"@dflatlist.in",prompt="(@List of lists) Dflats (Quads/Chips)", mode="ql"}
string  file_out  {"nflat.in",prompt="File name containing output nflat list", mode="ql"}
string  pre_head {"nflat_c",prompt="The prehead of the output nflat frames",mode="ql"}
int     startfold  {1, prompt="The start #th fold for combination", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkflatpar {prompt="Imcombine parameters to make flat images"}


struct  *filist1, *filist2


begin

        string  ftmpi[2]    #i input file list of lists (for bflats and dflats)
        string  prequad[2]  #i prefix of each quad/chip image files
        string  filein[2]   #i the input list of list individual nflat
        string  fileout     #o a file containing  output nflat filenames
        string  ifile       #i the final version of input file 
        string  quadinb     #i input image of bflat
        string  quadind     #i input image of dflat
        string  frameout    #o output nflat name
        string  cmkqdnflatlog   #o logfile
        string  prehead     # prehead of the output nflat files
        int     startfold1  #i the start fold-th for combination 
        bool    useropt1   # User option to input IMCOMBINE parameters
        int     ic, ic2     # counters
        int     leni       # length of input file list string
        string  ext        # dummy variable (extension of the output flats)
        string  templog    # dummy variable (temporary logfile)
        int     i          # dummy variable

      #  Get the rest of the parameters

        ftmpi[1]   = file_inb
        ftmpi[2]   = file_ind
        fileout    = file_out
        prehead    = pre_head
        startfold1 = startfold
        useropt1   = useropt
        cmkqdnflatlog = "cmkqdnflat.log"
        templog = "cmkdnflat.log"
        filein[1] = "quadlistb.in"
        filein[2] = "quadlistd.in"
        prequad[1] = "quadb_"
        prequad[2] = "quadd_"
        ext = ".fits"

     # Check existence of output files

        if (access(cmkqdnflatlog))
           delete(cmkqdnflatlog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

      # make suitable input lists for cmkdnflat

        for (i = 1; i <= 2; i += 1)
          {
        #  Find out the suitable input option

             leni=strlen(ftmpi[i])

             if (stridx(ftmpi[i], "@") == 1)
                ifile = substr(ftmpi[i], 2, leni)
             else
               {
                  ifile = mktemp("flat")
                  sections(ftmpi[i], option="fullname", > ifile)
               }

      # Make quad input lists, the output file called "quadlistb.in" or
      # "quadlistd.in" which contains the list of quad_file names. 
      # Each quad_file contains list of fold files for quadb_# 
      #  in quadlistb.in  and quadd_# in quadlistd.in

        cmkqlist(ifile, filein[i], prequad[i])
    
#        if (stridx(ftmpi[i], "@") != 1)
#           delete(ifile, ver-, >& "dev$null")
#

       } # this brace is from for loop (i=1; i<= 2)


      # Read the list of input flat list filename
        ic = 0; ic2 = 0
        filist1 = ""; filist2 = ""
        filist1 = filein[1]    # filein1 = quadlistb.in
        filist2 = filein[2]    # filein2 = quadlistd.in
        while ( (fscan(filist1, quadinb) != EOF) && 
                (fscan(filist2, quadind) != EOF) )
         {
           ic += 1
      # Make the output nflat names and put them into a list 
              frameout = prehead//str(ic)//ext
              print (frameout, >> fileout)

        # Check the existence of the file "frameout"
              if (access(frameout))
                 delete(frameout, ver-, >& "dev$null")

                print("")
                print("", >> cmkqdnflatlog)
                print("Quad or Chip ", ic)
                print("Quad or Chip ", ic, >> cmkqdnflatlog )
                cmkdnflat("@"//quadinb, "@"//quadind, frameout, startfold1, useropt1)
                unlearn type
                type (templog, >> cmkqdnflatlog)
                print("=========================================", >> cmkqdnflatlog)
                flpr
         }    # this brace is from while (filist1, quadinb; filist2, quadind)

         # close the files and cleaning up
           filist1 = ""; filist2 = ""


          print("   << ========= CMKQDNFLAT DONE =========== >>")
          beep; beep; beep

end


